%% How to Best Run This Tutorial?
%
% Each m-file in this tutorial is split into what is called "code sections"
% in Matlab. A code cell is a shorter block of code performing a specific
% task, separated from other code cells by a double percent sign, `%%`
% (usually with a title and brief introduction added). By default, the
% cells are visually separated from each other by a horizontal rule in the
% Matlab editor.
%
% Instead of running each m-file from the command window, or executing this
% `read_me_first` as a whole, do the following. Open one tutorial m-file in
% the Matlab editor. Arrange the editor window and the command window next
% to each other so that you can see both of them at the same time. Then run
% the m-file cell by cell. This will help you watch closely what exactly
% is going on.
%
% To execute one particular cell, place the cursor in that cell (the
% respective block of code will get highlighted), and select "Run Current
% Section" from a contextual menu (upon a right click on the mouse), or
% pressing a keyboard shortcut (which differ on different systems and
% Matlab versions). To learn more on code sections, search Matlab
% documentation for "code section".

clc;
