function Def = qreport()
% qreport  [Not a public function] Default options for quick-report functions.
%
% Backend IRIS function
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2015 IRIS Solutions Team.

%--------------------------------------------------------------------------

Def = struct();

Def.qplot = {...
    'addclick',true,@islogicalscalar, ...
    'clear',[],@isnumeric, ...
    'drawnow',false,@islogical, ...
    'grid',true,@islogicalscalar, ...
    'highlight',[],@(x) isnumeric(x) ...
    || (iscell(x) && all(cellfun(@isnumeric,x))), ...
    'mark',{},@(x) iscell(x) || ischar(x), ...
    'prefix','P%g_',@ischar, ...
    'round',Inf,@(x) isnumericscalar(x) && x >= 0 && round(x) == x, ...
    'sstate',struct(),@(x) isempty(x) || isstruct(x) || isa(x,'model'), ...
    'style',struct(),@(x) isempty(x) || isstruct(x) || (iscellstr(x) && length(x) == 1), ...
    'tight',false,@islogicalscalar, ...
    'vline',[],@(x) isempty(x) || isnumeric(x), ...
    'zeroline',false,@islogicalscalar, ...
    };

Def.qreport = {...
    'addclick',true,@islogicalscalar, ...
    'caption,captions,title,titles',{},@(x) isempty(x) || iscellstr(x) || isfunc(x), ...
    'comment',{},@(x) isempty(x) || ischar(x) || iscellstr(x), ...
    'clear',[],@isnumeric, ...
    'clone','',@ischar, ...
    'deviationfrom,deviationsfrom',[],@(x) isempty(x) || islogicalscalar(x) || isnumericscalar(x), ...
    'deviationtimes,deviationstimes',1,@isnumericscalar, ...
    'dbsave',false,@(x) islogicalscalar(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
    'drawnow',false,@islogical, ...
    'grid',true,@islogicalscalar, ...
    'highlight',[],@(x) isnumeric(x) ...
    || (iscell(x) && all(cellfun(@isnumeric,x))), ...
    'interpreter','none',@(x) any(strcmpi(x,{'latex','tex','none'})), ...
    'mark',{},@iscellstr, ...
    'maxfigure',false,@islogicalscalar, ...
    'overflow',false,@islogicalscalar, ...
    'pagenumber,pagenumbers',false,@islogicalscalar, ...    
    'plotfunc',@plot, ...
    @(x) isfunc(x) || ischar(x) || (iscell(x) && isfunc(x{1}) && iscellstr(x(2:2:end))), ...
    'prefix','P%g_',@ischar, ...
    'round',Inf,@(x) isnumericscalar(x) && x >= 0 && round(x) == x, ...
    'saveas','',@ischar, ...
    'sstate',struct(),@(x) isempty(x) || isstruct(x) || isa(x,'model'), ...
    'style',struct(),@(x) isempty(x) || isstruct(x) || (iscellstr(x) && length(x) == 1), ...
    'subplot','auto',@(x) strcmpi(x,'auto') ...
    || (isnumeric(x) && length(x) == 2 && all(~isnan(x) & x > 0 & isround(x))), ...
    'tight',false,@islogicalscalar, ...
    'transform',[],@(x) isempty(x) || isfunc(x), ...
    'vline',[],@(x) isempty(x) || isnumeric(x), ...
    'xlabel','',@(x) ischar(x) || iscellstr(x), ...
    'ylabel','',@(x) ischar(x) || iscellstr(x), ...
    'zeroline',false,@islogicalscalar, ...
    };

Def.qstyle = { ...
    'cascade',true,@islogicalscalar, ...
    'offset',0,@isnumericscalar, ...
    'warning',true,@islogicalscalar, ...
    };

end
