function Def = model()
% model  [Not a public function] Default options for model class functions.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2015 IRIS Solutions Team.

%--------------------------------------------------------------------------

solveValid = @(x) islogicalscalar(x) ...
    || (iscell(x) && iscellstr(x(1:2:end)));

deviation_dtrends = { ...
    'deviation,deviations',false,@islogicalscalar, ...
    'dtrends,dtrend',@auto,@(x) islogicalscalar(x) || isequal(x,@auto), ...
    };

precision = { ...
    'precision','double', ...
    @(x) ischar(x) && any(strcmpi(x,{'double','single'})), ...
    };

applyfilter = {
    'applyto',@all,@(x) isequal(x,@all) || iscellstr(x), ...
    'filter','',@ischar, ...
    };

swap = { ...
    'endogenise,endogenize',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'exogenise,exogenize',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    };

if true % ##### MOSW
    matrixFmt = { ...
        'MatrixFmt','namedmat', ...
        @(x) ischar(x) && any(strcmpi(x,{'namedmat','plain','numeric'})), ...
        };
else
    matrixFmt = { ...
        'MatrixFmt','plain', ...
        @(x) ischar(x) && any(strcmpi(x,{'plain','numeric'})), ...
        }; %#ok<UNRCH>
end

select = { ...
    'select',@all,@(x) (isequal(x,@all) || iscellstr(x) || ischar(x)) && ~isempty(x), ...
    };

sstate = { ...
    'sstate,sstateopt',false,@(x) islogical(x) ...
    || (iscell(x) && iscellstr(x(1:2:end))) ...
    || isa(x,'function_handle') ...
    || (iscell(x) && ~isempty(x) && isa(x{1},'function_handle')), ...
    };

system = { ...
    'eqtn,equations','all',@(x) ischar(x) ...
    'linear',@auto,@(x) islogicalscalar(x) || isequal(x,@auto), ...
    'normalize,normalise',true,@islogicalscalar, ...
    'select',true,@islogicalscalar, ...
    'symbolic',true,@islogicalscalar, ...
    };

mysstate = { ...
    'blocks,block',false,@islogicalscalar, ...
    swap{:}, ...
    'fix',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixallbut',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixlevel',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixlevelallbut',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixgrowth',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'fixgrowthallbut',{},@(x) isempty(x) || iscellstr(x) || ischar(x), ...
    'growth',false,@islogicalscalar, ...
    'linear',@auto,@(x) islogicalscalar(x) || isequal(x,@auto'), ...
    'LogMinus',{},@(x) ischar(x) || iscellstr(x), ...
    'maxiter',1000,@(x) isnumeric(x) && length(x) == 1 && round(abs(x)) == x, ...
    'maxfunevals',1000,@(x) isnumeric(x) && length(x) == 1 && round(abs(x)) == x, ...
    'optimset',{},@(x) isempty(x) || (iscell(x) && iscellstr(x(1:2:end))), ...
    'naninit,init',1,@(x) isnumericscalar(x) && isfinite(x), ...
    'refresh',true,@islogicalscalar, ...
    'resetinit',[],@(x) isempty(x) || (isnumericscalar(x) && isfinite(x)), ...
    'reuse',false,@islogicalscalar, ...
    'solver','lsqnonlin',@(x) ischar(x) || isfunc(x), ...
    'tolx',1e-12,@(x) isnumeric(x) && length(x) == 1 && x > 0, ...
    'tolfun',1e-12,@(x) isnumeric(x) && length(x) == 1 && x > 0, ...
    'Unlog',{},@(x) ischar(x) || iscellstr(x), ...
    'zeromultipliers',false,@islogicalscalar, ...
    };


Def = struct();

Def.acf = {
    'acf',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    applyfilter{:}, ...
    'nfreq',256,@isnumericscalar, ...
    'contributions,contribution',false,@islogicalscalar, ...
    'order',0,@isnumericscalar, ...
    matrixFmt{:}, ...
    select{:}, ...
    }; %#ok<*CCAT>

Def.bn = { ...
    deviation_dtrends{:}, ...
    }; %#ok<CCAT1>

Def.chkmissing = { ...
    'error',true,@islogicalscalar, ...
    };

Def.chksstate = { ...
    'error',true,@islogicalscalar, ...
    'refresh',true,@islogicalscalar, ...
    'warning',true,@islogicalscalar, ...
    };

Def.mychksstate = { ...
    'eqtn,sstateeqtn','full', @(x) islogicalscalar(x) ...
    || (ischar(x) && any(strcmpi(x,{'full','sstate'}))), ...
    'tolerance',getrealsmall(),@isnumericscalar, ...
    };

Def.diffloglik = {...
    'chksstate',true,@(x) islogicalscalar(x) ...
    || (iscell(x) && iscellstr(x(1:2:end))), ...
    'progress',false,@islogicalscalar, ...
    'refresh',true,@islogicalscalar, ...
    'solve',true,solveValid, ...
    sstate{:}, ...
    };

% Combine model/estimate with estimateobj/myestimate.
estimateobj = irisopt.estimateobj();
Def.estimate = { ...
    matrixFmt{:}, ...
    estimateobj.myestimate{:}, ...
    'chksstate',true,@(x) islogicalscalar(x) ...
    || (iscell(x) && iscellstr(x(1:2:end))), ...
    'domain','time',@(x) any(strncmpi(x,{'t','f'},1)), ...
    'filter,filteropt',{},@(x) isempty(x) ...
    || (iscell(x) && iscellstr(x(1:2:end))), ...
    'nosolution','error', @(x) (isnumericscalar(x) && x >= 1e10) ...
    || (ischar(x) && any(strcmpi(x,{'error','penalty'}))), ...
    'refresh',true,@islogicalscalar, ...
    'solve',true,solveValid, ...
    sstate{:}, ...
    'zero',false,@islogicalscalar, ...
    };

Def.fevd = {
    matrixFmt{:}, ...
    select{:}, ...
    };

Def.fmse = {
    matrixFmt{:}, ...
    select{:}, ...
    };

Def.ffrf = {
    'include',@all,@(x) isempty(x) || isequal(x,@all) || ischar(x) || iscellstr(x), ...
    'exclude',{},@(x) isempty(x) || ischar(x) || iscellstr(x), ...
    'maxiter',[],@(x) isempty(x) || (isnumericscalar(x) && x >= 0), ...
    matrixFmt{:}, ...
    select{:}, ...
    'tolerance',[],@(x) isempty(x) || (isnumericscalar(x) && x > 0), ...
    };

Def.filter = { ...
    matrixFmt{:}, ...
    'data,output','smooth',@(x) ischar(x), ...
    'refresh',true,@islogicalscalar, ...
    };

Def.fisher = { ...
    'chksgf',false,@islogicalscalar, ...
    'chksstate',true,@(x) islogicalscalar(x) ...
    || (iscell(x) && iscellstr(x(1:2:end))), ...
    'deviation',true,@islogicalscalar, ...
    'epspower',1/3,@isnumericscalar, ...
    'exclude',{},@(x) ischar(x) || iscellstr(x), ...
    'percent',false,@islogicalscalar, ...
    'progress',false,@islogicalscalar, ...
    'refresh',true,@islogicalscalar, ...
    'solve',true,solveValid,...
    sstate{:}, ...
    'tolerance',eps()^(2/3),@isnumericscalar, ...
    };

Def.forecast = {...
    'anticipate',true,@islogicalscalar, ...
    deviation_dtrends{:}, ...
    'initcond','data',@(x) isnumeric(x) ...
    || (ischar(x) && any(strcmpi(x,{'data','fixed'}))), ...
    'meanonly',false,@islogicalscalar, ...
    'std',[],@(x) isstruct(x) || isempty(x), ...
    'tolmse',getrealsmall('mse'),@(x) isnumeric(x) && length(x) == 1, ...
    };

Def.jforecast = {...
    'anticipate',true,@islogicalscalar, ...
    'currentonly',true,@islogicalscalar, ...
    deviation_dtrends{:}, ...
    'initcond','data',@(x) isnumeric(x) ...
    || (ischar(x) && any(strcmpi(x,{'data','fixed'}))), ...
    'meanonly',false,@islogicalscalar, ...
    'precision','double', ...
    @(x) ischar(x) && any(strcmpi(x,{'double','single'})), ...
    'progress',false,@islogicalscalar, ...
    'plan',[],@(x) isa(x,'plan') || isempty(x), ...
    'vary,std',[],@(x) isstruct(x) || isempty(x), ...
    };

Def.icrf = {...
    'delog',true,@islogicalscalar,...
    'size',[],@(x) isempty(x) || isnumericscalar(x), ...
    };

Def.ifrf = {...
    matrixFmt{:}, ...
    select{:}, ...
    };

Def.loglik = { ...
    'domain','time',@(x) any(strncmpi(x,{'t','f'},1)), ...
    'persist',false,@islogicalscalar, ...
    };

Def.fdlik = { ...
    'band',[2,Inf],@(x) isnumeric(x) && length(x) == 2, ...
    deviation_dtrends{:}, ...
    'exclude',[], ...
    @(x) isempty(x) || ischar(x) || iscellstr(x) || islogical(x), ...
    'objdecomp',false,@islogicalscalar, ...
    'outoflik',{},@(x) ischar(x) || iscellstr(x), ...
    'relative',true,@islogicalscalar, ...
    'zero',true,@islogicalscalar, ...
    };

Def.lognormal = { ...
    'fresh',false,@islogicalscalar, ...
    'mean',true,@islogicalscalar, ...
    'median',true,@islogicalscalar, ...
    'mode',true,@islogicalscalar, ...
    'prctile,pctile,pct',[5,95], ...
    @(x) isnumeric(x) && all(round(x(:)) > 0 & round(x(:)) < 100), ...
    'prefix','lognormal',@(x) ischar(x) && ~isempty(x), ...
    'std',true,@islogicalscalar, ...
    };

Def.kalman = { ...
    'ahead',1,@(x) isintscalar(x) && x > 0, ...    
    'chkexact',false,@islogicalscalar, ...
    'chkfmse',false,@islogicalscalar, ...
    deviation_dtrends{:}, ...
    'condition',[], ...
    @(x) isempty(x) || ischar(x) || iscellstr(x) || islogical(x), ...
    'fmsecondtol',eps(),@(x) isnumericscalar(x) && x > 0 && x < 1, ...
    'returncont,contributions',false,@islogicalscalar, ...
    'initcond,init','stochastic',@(x) ...
    isstruct(x) ...
    || (ischar(x) && any(strcmpi(x,{'stochastic','fixed','optimal'}))), ...
    'initmeanunit','optimal',@(x) ...
    isstruct(x) || (ischar(x) && any(strcmpi(x,{'optimal'}))), ...
    'lastsmooth',Inf,@(x) isempty(x) || isnumericscalar(x), ...
    'nonlinear,nonlinearise,nonlinearize',0,@(x) isintscalar(x) && x >= 0, ...
    'outoflik',{},@(x) ischar(x) || iscellstr(x), ...
    'objdecomp',false,@islogicalscalar, ...
    'objfunc,objective','loglik', ...
    @(x) ischar(x) && any(strcmpi(x,{'loglik','mloglik','-loglik','prederr'})), ...
    'objrange,objectivesample',@all,@(x) isnumeric(x) || isequal(x,@all), ...
    'pedindonly',false,@islogicalscalar, ...
    precision{:}, ...
    'plan',[],@(x) isa(x,'plan') || isempty(x), ...
    'progress',false,@islogicalscalar, ...
    'relative',true,@islogicalscalar, ...
    'vary,std',[],@(x) isempty(x) || isstruct(x), ...
    'simulate',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    'symmetric',true,@islogicalscalar, ...
    'tolerance',eps()^(2/3),@isnumeric, ...
    'tolmse',0,@(x) isnumericscalar(x) ...
    || (ischar(x) && strcmpi(x,'auto')), ...
    'weighting',[],@isnumeric, ...
    'meanonly',false,@islogicalscalar, ...
    'returnstd',true,@islogicalscalar, ...
    'returnmse',true,@islogicalscalar, ...
    };

Def.model = {
    'addlead',false,@islogicalscalar, ...
    'declareparameters',true,@islogicalscalar, ...
    'assign',[],@(x) isempty(x) || isstruct(x), ...
    'blazer',true,@islogicalscalar, ...
    'chksyntax',true,@islogicalscalar, ...
    'comment','',@ischar, ...
    'optimal','discretion', ...
    @(x) ischar(x) && any(strcmpi(x,{'consistent','commitment','discretion'})), ...
    'epsilon',[],@(x) isempty(x) || (isnumericscalar(x) && x > 0 && x < 1), ...
    'removeleads,removelead',false,@islogicalscalar, ...
    'linear',false,@islogicalscalar, ...
    'makebkw',@auto,@(x) isequal(x,@auto) || isequal(x,@all) || iscellstr(x) || ischar(x), ...
    'multiple,allowmultiple',false,@islogicalscalar, ...
    'multipliername','Mu_Eq%g',@(x) ischar(x) && ~isempty(strfind(x,'%g')), ...
    'precision','double',@(x) ischar(x) && any(strcmp(x,{'double','single'})), ...
    'quadratic',false,@islogicalscalar, ...
    'saveas','',@ischar, ...
    'sstateonly',false,@islogicalscalar, ...
    'symbdiff,symbolicdiff',true,@islogicalscalar, ...
    'std',@auto,@(x) isequal(x,@auto) || (isnumericscalar(x) && x >= 0), ...
    'stdlinear',1,@(x) isnumericscalar(x) && x >= 0, ...
    'stdnonlinear',log(1.01),@(x) isnumericscalar(x) && x >= 0, ...
    'tolerance',[],@(x) isempty(x) || (isnumericscalar(x) && x >= 0), ...
    'baseyear,torigin',@config,@(x) isequal(x,@config) || isempty(x) || isintscalar(x), ...
    };

Def.neighbourhood = { ...
    'plot',true,@islogicalscalar, ...
    'progress',false,@islogicalscalar, ...
    'neighbourhood',[],@(x) isempty(x) || isstruct(x), ...
    };

Def.tcorule = { ...
    'beta',1,@isnumericscalar, ...
    'display',5000,@isnumericscalar, ...
    'ginverse',false,@islogicalscalar, ...
    'initexp',@eye,@(x) isnumeric(x) || isfunc(x), ...
    'maxiter',50000,@isnumericscalar, ...
    'reset',false,@islogicalscalar, ...
    'tolexp',1e-10,@isnumericscalar, ...
    'tolrule',1e-10,@isnumericscalar, ...
    'tolvalue',1e-6,@isnumericscalar, ...
    'warning',true,@islogicalscalar, ...
    };

Def.regress = { ...
    'acf',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    matrixFmt{:}, ...
    };
    
Def.resample = { ...
    'bootstrapMethod','efron',@(x) ...
    (ischar(x) && any(strcmpi(x,{'efron','wild'}))) ...
    || isintscalar(x) || isnumericscalar(x,0,1), ...
    deviation_dtrends{:}, ...
    'method','montecarlo',@(x) isfunc(x) ...
    || (ischar(x) && any(strcmpi(x,{'montecarlo','bootstrap'}))), ...
    'progress',false,@islogicalscalar, ...
    'randominitcond,randomiseinitcond,randomizeinitcond,randomise,randomize', ...
    true,@(x) islogicalscalar(x) || (isnumericscalar(x) && x >= 0), ...
    'svdonly',false,@islogicalscalar, ...
    'statevector','alpha',@(x) ischar(x) && any(strcmpi(x,{'alpha','x'})), ...
    'vary',[],@(x) isempty(x) || isstruct(x), ...
    'wild',[],@(x) isempty(x) || islogicalscalar(x), ...
    };

Def.shockplot = { ...
    'dbplot',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    'deviation',true,@islogicalscalar, ...
    'dtrends,dtrend',@auto,@(x) islogicalscalar(x) || isequal(x,@auto), ...
    'simulate',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    'shocksize,size','std',@(x) isnumeric(x) ...
    || (ischar(x) && strcmpi(x,'std')), ...
    };

Def.simulate = { ...
    'anticipate',true,@islogicalscalar, ...
    'contributions,contribution',false,@islogicalscalar, ...
    'dboverlay,dbextend',false,@(x) islogicalscalar(x) || isstruct(x), ...
    deviation_dtrends{:}, ...
    'fast',true,@islogicalscalar, ...
    'ignoreshocks,ignoreshock,ignoreresiduals,ignoreresidual', ...
    false,@islogicalscalar, ...
    'missing',NaN,@isnumeric, ...
    'plan',[],@(x) isa(x,'plan') || isempty(x), ...
    'progress',false,@islogicalscalar, ...
    'sparseshocks,sparseshock',false,@islogicalscalar, ...
    ...
    ... Nonlinear solver
    ...
    'solver','plain',@(x) ischar(x) && strcmpi(x,'plain') ...
    || isequal(x,@fsolve) || isequal(x,@lsqnonlin), ...
    ...
    ... Options for plain nonlinear simulations
    ...
    'nonlinearise,nonlinearize,nonlinear', ...
    0,@(x) isempty(x) || isnumeric(x), ...
    'addsstate',true,@islogicalscalar, ...
    'display', ...
    100,@(x) islogicalscalar(x) || (isintscalar(x) && x >= 0), ...
    'error',false,@islogicalscalar, ...
    'fillout',false,@islogicalscalar, ...
    'lambda',1,@(x) isnumericscalar(x) && all(x > 0 & x <= 2), ...
    'reducelambda,lambdafactor', ...
    0.5,@(x) isnumericscalar(x) && x > 0 && x <= 1, ...
    'maxiter',100,@isnumericscalar, ...
    'tolerance',1e-5,@isnumericscalar, ...
    'upperbound',1.5,@(x) isnumericscalar(x) && all(x > 1), ...
    ...
    ... Options for Optim Tbx nonlinear simulations
    ...
    'optimset',{},@(x) isempty(x) ...
    || (iscell(x) && iscellstr(x(1:2:end))) || isstruct(x), ...
    };

Def.solve = { ...
    system{:}, ...
    'expand,forward',0,@(x) isnumeric(x) && length(x) == 1, ...
    'fast',false,@islogicalscalar, ...
    'error',false,@islogicalscalar, ...
    'progress',false,@islogicalscalar, ...
    'refresh',true,@islogicalscalar, ...
    'warning',true,@islogicalscalar, ...
    };

Def.mysourcedb = { ...
    'ndraw',1,@(x) isintscalar(x) && x >= 0, ...
    'ncol',1,@(x) isintscalar(x) && x >= 0, ...
    deviation_dtrends{:}, ...
    'randomshocks,randomshock',false,@islogicalscalar, ...
    'residuals,residual',[],@(x) isempty(x) || isfunc(x), ...
    };

Def.srf = {...
    'delog,log',true,@islogicalscalar, ...
    select{:}, ...
    'size',@auto,@(x) isequal(x,@auto) || isnumericscalar(x), ...
    };

Def.sspace = { ...
    'triangular',true,@islogicalscalar, ...
    'removeinactive',false,@islogicalscalar, ...
    };

Def.sstate = { ...
    'linear',@auto,@(x) islogicalscalar(x) || isequal(x,@auto), ...
    'solve',false,solveValid, ...
    };

Def.mysstateverbose = { ...
    mysstate{:}, ...
    'display','iter',@(x) isempty(x) || islogical(x) ...
    || (ischar(x) && any(strcmpi(x,{'iter','final','off','notify','none'}))) , ...
    'warning',true,@islogicalscalar, ...
    };

Def.mysstatesilent = { ...
    mysstate{:}, ...
    'display','off',@(x) isempty(x) || islogical(x) ...
    || (ischar(x) && any(strcmpi(x,{'iter','final','off','notify','none'}))), ...
    'warning',false,@islogicalscalar, ...
    };

Def.sstatefile = { ...
    swap{:}, ...
    'growthnames,growthname','d?',@ischar, ...
    'time',true,@islogicalscalar, ...
    };

Def.system = { ...
    system{:}, ...
    'sparse',false,@islogicalscalar, ...
    };

Def.VAR = { ...
    'acf',{},@(x) iscell(x) && iscellstr(x(1:2:end)), ...
    'order',1,@isnumericscalar, ...
    'constant,const',true,@islogicalscalar, ...
    };

Def.vma = {
    matrixFmt{:}, ...
    select{:}, ...
    };

Def.xsf = {
    applyfilter{:}, ...
    matrixFmt{:}, ...
    'progress',false,@islogicalscalar, ...
	select{:}, ...
    };

end
