function V=getdata(spec);  %Creates monthly weather variables for some specification:  %1 for no snow, 2 for HDD, 3 for original snow, 4 for RSI, 5 for RSI + absent, 6 for RSI + precip, 7 for lags, 8 for leads   

m=xlsread('WeatherData.xlsx','Sheet1','IT246:JD20607');
if spec==2; m(:,5)=m(:,7); end;
if spec>=4; m(:,4)=m(:,8); end; %Replace snowfall with one of the ReSIS indices.
m=m(:,1:7);
mz=m;
u=unique(m(:,2));
n=length(u);
for i=1:n;
    g=find(m(:,2)==u(i));
    for t=31:length(g);
        mz(g(t),3)=m(g(t),3)-mean(m(g(t-30:t-1),3));
        mz(g(t),4)=m(g(t),4)-mean(m(g(t-30:t-1),4));
        mz(g(t),5)=m(g(t),5)-mean(m(g(t-30:t-1),5));
        mz(g(t),6)=m(g(t),6)-mean(m(g(t-30:t-1),6));
        mz(g(t),7)=m(g(t),7)-mean(m(g(t-30:t-1),7));
    end;
end;  
m=mz(10959:end,:);  %Start December 1 1989
%-------------------------------------%
if spec==1; theta=xlsread('midasparams.xls',1,'B2:B3'); end; %theta is from MIDAS
if spec==2; theta=xlsread('midasparams.xls',1,'C2:C3'); end; 
if spec==3; theta=xlsread('midasparams.xls',1,'D2:D3'); end; 
if spec==4; theta=xlsread('midasparams.xls',1,'E2:E3'); end;
if spec==5; theta=xlsread('midasparams.xls',1,'F2:F3'); end;
if spec==6; theta=xlsread('midasparams.xls',1,'G2:G3'); end;
if spec==7; theta=xlsread('midasparams.xls',1,'H2:H5'); end;
if spec==8; theta=xlsread('midasparams.xls',1,'I2:I4'); end;
gmax=30;
g=[0:1:gmax]';
g=g/gmax;
g=exp((theta(1)*g)+(theta(2)*(g.^2))); g=g/sum(g);


d=datenum(m(:,1),floor(m(:,2)/100),m(:,2)-(100*floor(m(:,2)/100)));
V=[kron([1990:1:2015]',ones(12,1)) kron(ones(26,1),[1:1:12]')];
V=V(1:305,:);
for i=1:305;
    dow=weekday(datenum(V(i,1),V(i,2),12));
    g0=find(d==datenum(V(i,1),V(i,2),12));
    V(i,3)=sum(flipud(g).*m(g0-gmax:g0,3));
    V(i,4)=sum(flipud(g).*m(g0-gmax:g0,4));
    V(i,5)=sum(flipud(g).*m(g0-gmax:g0,5));
    V(i,6)=sum(flipud(g).*m(g0-gmax:g0,6));
    V(i,7)=sum(flipud(g).*m(g0-gmax:g0,7));
end;
if spec==7;
    for i=1:305;
        dow=weekday(datenum(V(i,1),V(i,2),12));
    	g0=find(d==datenum(V(i,1),V(i,2),12));
    	V(i,3)=V(i,3)+(theta(3)*sum(m(g0-(2*gmax):g0-gmax-1,3)))+(theta(4)*sum(m(g0-(3*gmax):g0-(2*gmax)-1,3)));
    	V(i,4)=V(i,4)+(theta(3)*sum(m(g0-(2*gmax):g0-gmax-1,4)))+(theta(4)*sum(m(g0-(3*gmax):g0-(2*gmax)-1,4)));
    	V(i,5)=V(i,5)+(theta(3)*sum(m(g0-(2*gmax):g0-gmax-1,5)))+(theta(4)*sum(m(g0-(3*gmax):g0-(2*gmax)-1,5)));
    	V(i,6)=V(i,6)+(theta(3)*sum(m(g0-(2*gmax):g0-gmax-1,6)))+(theta(4)*sum(m(g0-(3*gmax):g0-(2*gmax)-1,6)));
    	V(i,7)=V(i,7)+(theta(3)*sum(m(g0-(2*gmax):g0-gmax-1,7)))+(theta(4)*sum(m(g0-(3*gmax):g0-(2*gmax)-1,7)));
    end;
end;
if spec==8;
    for i=1:305;
        dow=weekday(datenum(V(i,1),V(i,2),12));
    	g0=find(d==datenum(V(i,1),V(i,2),12));
    	V(i,3)=V(i,3)+(theta(3)*sum(m(g0+1:g0+2,3)));
        V(i,4)=V(i,4)+(theta(3)*sum(m(g0+1:g0+2,4)));
        V(i,5)=V(i,5)+(theta(3)*sum(m(g0+1:g0+2,5)));
        V(i,6)=V(i,6)+(theta(3)*sum(m(g0+1:g0+2,6)));
        V(i,7)=V(i,7)+(theta(3)*sum(m(g0+1:g0+2,7)));
    end;
end;
save weather V  %Saves the output to the Weather file
