*************************************************************************************
*   Replicate Table 2                                                               *
*************************************************************************************

capture log close
log using "$folder/Output/table2.log", replace

use     "$folder/birthweight", clear

gen     allprov2=allprov*allprov
gen     allprov3=allprov*allprov2
gen     allprov4=allprov2*allprov2

gen     logLBW=log(_share)

egen    _year=cut(year), at(1954, 1958, 1966, 1977)

gen     nosales = 1 - sales

local X "i._reg*i.year allprov* i.Repeal*i._year i._Phys*i._year i.nosales*i._year i.any*i._year D*"

xi: areg logLBW `X' [pw=bwtot] if race==0, cluster(statef) level(95) a(statef)
    sum share [aw=bwtot]       if race==0
    outreg2 _Inos* using "$folder/Output/table2.xls", replace br noaster dec(3) addstat("Mean DV", r(mean))

xi: areg logLBW `X' [pw=bwtot] if race==1, cluster(statef) level(95) a(statef)
    sum share [aw=bwtot]       if race==1
    outreg2 _Inos* using "$folder/Output/table2.xls", append  br noaster dec(3) addstat("Mean DV", r(mean))

xi: areg logLBW `X' [pw=bwtot] if race==2, cluster(statef) level(95) a(statef)
    sum share [aw=bwtot]       if race==2
    outreg2 _Inos* using "$folder/Output/table2.xls", append  br noaster dec(3) addstat("Mean DV", r(mean))

xi: areg logLBW `X' [pw=bwtot] if race==2 & _region==3, cluster(statef) level(95) a(statef)
    sum share [aw=bwtot]       if race==2 & _region==3
    outreg2 _Inos* using "$folder/Output/table2.xls", append  br noaster dec(3) addstat("Mean DV", r(mean))

log close
