*************************************************************************************
*   Replicate Figure 9                                                              *
*************************************************************************************

capture log close
log using "$folder/Output/figure9.log", replace

use     "$folder/county_vital_stats", clear

local X1 "_Iyear* _Texp* "      /*This includes county (in reg command) and year f.e.*/
local X2 " _ISTX* _Texp* "      /*This adds stateXyear f.e. to X1*/
local X3 "R_* D* allprov `X2' " /*This adds REIS, Demographic, and abortion provider controls*/

local r replace

tokenize `"mmr imr nnmr pnmr"'
    while "`1'"!="" {

            xtreg `1' `X3', cluster(fips) fe
                sum `1' if e(sample) & year==70
                outreg2 _Texp* using "$folder/Output/figure9uw.xls", `r' bracket noaster title(`e(depvar)') ctitle(`e(cmdline)')

            xtreg `1' `X3' [pw= pop1544_70], cluster(fips) fe
                sum `1' [aw= pop1544_70] if e(sample) & year==70
                outreg2 _Texp* using "$folder/Output/figure9w.xls", `r' bracket noaster title(`e(depvar)') ctitle(`e(cmdline)')

            local r append

    macro shift
    }


*************************************************************************************
*   Difference-in-difference versions of Figure 9                                   *
*************************************************************************************

local X1 "_Iyear* fp_on* "      /*This includes county (in reg command) and year f.e.*/
local X2 " _ISTX* `X1' "        /*This adds stateXyear f.e. to X1*/
local X3 "R_* D* `X2' "

local r replace
tokenize `"mmr imr nnmr pnmr"'
    while "`1'"!="" {
    local i = 1
        while `i'<=3 {

            xtreg `1' `X`i'', cluster(fips) fe
                sum `1' if e(sample) & year==70
                outreg2 fp_on* using "$folder/Output/figure9dduw.xls", `r' bracket noaster title(`e(depvar)') ctitle(`e(cmdline)')

            xtreg `1' `X`i'' [pw= pop1544_70], cluster(fips) fe
                sum `1' [aw= pop1544_70] if e(sample) & year==70
                outreg2 fp_on* using "$folder/Output/figure9ddw.xls", `r' bracket noaster title(`e(depvar)') ctitle(`e(cmdline)')

            local r append
    local i = `i'+1
    }
    macro shift
    }


log close
