*************************************************************************************
*   Replicate Figure 5                                                              *
*************************************************************************************

capture log close
log using "$folder/Output/figure5.log", replace

use     "$folder/birthweight", clear

gen     nosales = 1 - sales

local X "i._reg*i.year i._Phys*i.year i.nosales*i.year i.Repeal*D70 i.Repeal*D73 i.Repeal*D76 i.any*i.year D*"

local r replace
tokenize `"GFR TFR"'
while "`1'"!="" {
    xi: areg `1' `X' [pw=pop] if race==0, cluster(statef) level(95) a(statef)
    sum `1' [aw=pop] if year==1957 & race==0
    sca def mean_dv=r(mean)
    testparm _InosXyea_1_1958-_InosXyea_1_1964
    sca def F5865=r(F)
    outreg2 _Inos* using "$folder/Output/figure5.xls", `r' sideway noparen noaster addstat(F5865, `r(F)')
    local r append
    macro shift
    }

log close
