*************************************************************************************
*   Replicate Table 1                                                               *
*************************************************************************************

capture log close
log using "$folder/Output/table1.log", replace

use     "$folder/ifss", clear

gen     allprov2=allprov *allprov
gen     allprov3=allprov2*allprov
gen     allprov4=allprov2*allprov2

gen     abortion=(stabb=="NY" | stabb=="CA" | stabb=="WA")
replace abortion=. if stabb==""

egen    c_bc=cut(c_birth_year), at(1950,1958,1966, 1977)
char    c_bc[omit] 1950

gen     nosales=(1-sales)

set     emptycells drop, perm

local X1 "D_CST* i.region*i.c_birth_year i.m_wave allprov* i.abortion*i.c_bc i._Phys*i.c_bc i.nosales*i.c_bc"

xi: areg c_unwanted_illtimed `X1' [pw=m_weight_recalc_m] , cluster(statef) a(statef)
    sum  c_unwanted_illtimed      [aw=m_weight_recalc_m] if e(sample)
    local rmean = r(mean)
    outreg2 _Ino* using "$folder/Output/table1.xls", replace se br ctitle(c_unwanted_illtimed) auto(2) addstat("Mean", `rmean')

xi: areg c_unwanted_illtimed `X1' [pw=m_weight_recalc_m] if m_obs!=1, cluster(statef) a(statef)
    sum  c_unwanted_illtimed      [aw=m_weight_recalc_m] if e(sample)
    local rmean = r(mean)
    outreg2 _Ino* using "$folder/Output/table1.xls", append  se br ctitle(c_unwanted_illtimed) auto(2) addstat("Mean", `rmean')

xi: areg c_unwanted `X1' [pw=m_weight_recalc_m] if m_obs!=1, cluster(statef) a(statef)
    sum  c_unwanted      [aw=m_weight_recalc_m] if e(sample)
    local rmean = r(mean)
    outreg2 _Ino* using "$folder/Output/table1.xls", append  se br ctitle(c_unwanted) auto(2) addstat("Mean", `rmean')

xi: areg c_illtimed `X1' [pw=m_weight_recalc_m] if m_obs!=1, cluster(statef) a(statef)
    sum  c_illtimed      [aw=m_weight_recalc_m] if e(sample)
    local rmean = r(mean)
    outreg2 _Ino* using "$folder/Output/table1.xls", append  se br ctitle(c_illtimed) auto(2) addstat("Mean", `rmean')

xi: areg c_unwanted_illtimed `X1' [pw=m_weight_recalc_m] if m_obs!=1 & m_white==1, cluster(statef) a(statef)
    sum  c_unwanted_illtimed      [aw=m_weight_recalc_m] if e(sample)
    local rmean = r(mean)
    outreg2 _Ino* using "$folder/Output/table1.xls", append  se br ctitle(c_unwanted_illtimed) auto(2) addstat("Mean", `rmean')

xi: areg c_unwanted_illtimed  `X1' [pw=m_weight_recalc_m] if m_obs!=1 & m_educ_lths==1, cluster(statef) a(statef)
    sum  c_unwanted_illtimed       [aw=m_weight_recalc_m] if e(sample)
    local rmean = r(mean)
    outreg2 _Ino* using "$folder/Output/table1.xls", append  se br ctitle(c_unwanted_illtimed) auto(2) addstat("Mean", `rmean')

xi: areg c_unwanted_illtimed `X1' [pw=m_weight_recalc_m] if m_obs!=1 & m_educ_scg==1, cluster(statef) a(statef)
    sum  c_unwanted_illtimed      [aw=m_weight_recalc_m] if e(sample)
    local rmean = r(mean)
    outreg2 _Ino* using "$folder/Output/table1.xls", append  se br ctitle(c_unwanted_illtimed) auto(2) addstat("Mean", `rmean')

xi: areg c_unwanted_illtimed `X1' [pw=m_weight_recalc_m] if m_obs!=1 & m_educ_cg==1, cluster(statef) a(statef)
    sum  c_unwanted_illtimed      [aw=m_weight_recalc_m] if e(sample)
    local rmean = r(mean)
    outreg2 _Ino* using "$folder/Output/table1.xls", append  se br ctitle(c_unwanted_illtimed) auto(2) addstat("Mean", `rmean')

log close
