*************************************************************************************
*   This Stata do file executes accompanying do files that replicate                *
*   Tables 1 and 2 and Figures 2 & 5-11 (excluding 8) in:                           *
*       Bailey, Martha.  2013.  "Fifty Years of Family Planning: New Evidence on    *
*           the Long-Run, Labor Market Effects of Increasing Access to              *
*           Contraception."  Brookings Papers on Economic Activity.                 *
*   See publised sources for Figures 1, 3, 4, and 8                                 *
*************************************************************************************

version 12
clear all
set more off
set linesize 255
set mat 10000
capture ssc install outreg
capture ssc install outreg2

*************************************************************************************
*   Set global macro for folder in which all do and data files are stored           *
*************************************************************************************

global folder "filepath"

*************************************************************************************
*   Execute accompanying do files                                                   *
*************************************************************************************

do "$folder/table1"
do "$folder/table2"
* Figure 1 is google n-grams
do "$folder/figure2"
* Figure 3 is taken from published sources
* Figure 4 is taken from published sources
do "$folder/figure5"
do "$folder/figure6_7"
* Figure 8 is taken from published sources
do "$folder/figure9"
do "$folder/figure10_11"
