*************************************************************************************
*   Replicate Figures 6 and 7                                                       *
*************************************************************************************


capture log close
log using "$folder/Output/figure6_7.log", replace


*************************************************************************************
*   Restrict to individuals born 1940-1980                                          *
*************************************************************************************


use     "$folder/census_acs", clear

keep if birthyr>=1946 & birthyr<=1980 & age>=20 & age<=59


*************************************************************************************
*   Clean variables and generate some new variables                                 *
*     - Convert monetary varibles to real 2012 USD                                  *
*         - Use CPI in year previous to survey year                                 *
*         - Source: ftp://ftp.bls.gov/pub/special.requests/cpi/cpiai.txt            *
*************************************************************************************


replace ftotinc  = . if ftotinc  == 9999999
replace incwage  = . if incwage  ==  999999
foreach j of varlist ftotinc incwage {
    replace `j' = `j'*229.594/166.6   if year==2000
    replace `j' = `j'*229.594/188.9   if year==2005
    replace `j' = `j'*229.594/195.3   if year==2006
    replace `j' = `j'*229.594/201.6   if year==2007
    replace `j' = `j'*229.594/207.342 if year==2008
    replace `j' = `j'*229.594/215.303 if year==2009
    replace `j' = `j'*229.594/214.537 if year==2010
    replace `j' = `j'*229.594/218.056 if year==2011
    gen     `j'_zero = `j'
    replace `j'_zero = 0 if `j'==.
    }
lab var ftotinc "Total family income (real 2012 USD)"
lab var incwage "Wage and salary income (real 2012 USD)"
lab var ftotinc_zero  "Total family income (real 2012 USD) (missing values set to 0)"
lab var incwage_zero  "Wage and salary income (real 2012 USD) (missing values set to 0)"

gen     male = 2 - sex
lab var male "Male"

gen     yrs = 0 if educd==11
replace yrs = 0 if educd==12
replace yrs = 1 if educd==14
replace yrs = 2 if educd==15
replace yrs = 3 if educd==16
replace yrs = 4 if educd==17
egen    avg = mean(yrs)
scalar  grp10 = avg[1]
global  grp10 = grp10
drop    yrs avg
gen     yrs = educd-17 if educd==22 | educd==23
egen    avg = mean(yrs)
scalar  grp21 = avg[1]
global  grp21 = grp21
drop    yrs avg
gen     yrs = educd-18 if educd==25 | educd==26
egen    avg = mean(yrs)
scalar  grp24 = avg[1]
global  grp24 = grp24
drop    yrs avg
gen     educ_years = 0      if educd==0
replace educ_years = 0      if educd==1
replace educ_years = 0      if educd==2
replace educ_years = $grp10 if educd==10
replace educ_years = 0      if educd==11
replace educ_years = 0      if educd==12
replace educ_years = 2.5    if educd==13
replace educ_years = 1      if educd==14
replace educ_years = 2      if educd==15
replace educ_years = 3      if educd==16
replace educ_years = 4      if educd==17
replace educ_years = 6.5    if educd==20
replace educ_years = $grp21 if educd==21
replace educ_years = 5      if educd==22
replace educ_years = 6      if educd==23
replace educ_years = $grp24 if educd==24
replace educ_years = 7      if educd==25
replace educ_years = 8      if educd==26
replace educ_years = 9      if educd==30
replace educ_years = 10     if educd==40
replace educ_years = 11     if educd==50
replace educ_years = 12     if educd==60
replace educ_years = 12     if educd==61
replace educ_years = 12     if educd==62
replace educ_years = 12     if educd==63
replace educ_years = 12     if educd==64
replace educ_years = 12     if educd==65
replace educ_years = 13     if educd==70
replace educ_years = 13     if educd==71
replace educ_years = 14     if educd==80
replace educ_years = 14     if educd==81
replace educ_years = 14     if educd==82
replace educ_years = 14     if educd==83
replace educ_years = 15     if educd==90
replace educ_years = 16     if educd==100
replace educ_years = 16     if educd==101
replace educ_years = 17     if educd==110
replace educ_years = 18     if educd==111
replace educ_years = 19     if educd==112
replace educ_years = 20     if educd==113
replace educ_years = 18     if educd==114
replace educ_years = 18     if educd==115
replace educ_years = 20     if educd==116
lab var educ_years "Completed years of education"
assert  educ_years!=2.5 & educ_years!=6.5

gen     educ_lesshs =      educd<=61
replace educ_lesshs = . if educd==.
lab var educ_lesshs "Education: Did not complete high school/GED"

gen     educ_hs =      educd>=62
replace educ_hs = . if educd==.
lab var educ_hs "Education: Completed at least high school/GED"

gen     educ_somecoll =      educd>=65
replace educ_somecoll = . if educd==.
lab var educ_somecoll "Education: Attended at least some collage"

gen     educ_bachelor =      educd>=101
replace educ_bachelor = . if educd==.
lab var educ_bachelor "Education: Bachelor's degree or higher"

gen     hours = uhrswork
lab var hours "Hours work per week (zero if did not work)"

xi:     areg WKSWORK1 i.WKSWORK2*i.male i.age if year<=2007, a(statef)
predict avg2
sum     avg2 if year<=2007
sum     avg2 if year> 2007
gen     weeks = WKSWORK1 if year>=2000 & year<=2007
replace weeks = avg2     if year>=2008 & year<=2011
lab var weeks "Weeks worked in past year"

gen     hoursempl = hours if hours!=0
lab var hoursempl "Hours work per week if >0"

gen     weeksempl = weeks if weeks!=0
lab var weeksempl "Weeks worked in pat year if >0"


*************************************************************************************
*   Collapse data to generate one observation for each unique combination of        *
*     - Year of birth                                                               *
*     - Year of survey                                                              *
*     - Place of birth                                                              *
*   Do overall and by sex                                                           *
*************************************************************************************


keep if bpl>=1 & bpl<=56

preserve
keep     age ftotinc_z          perwt                birthyr year bpl
collapse age ftotinc_z (rawsum) perwt [aw=perwt], by(birthyr year bpl)
tempfile  overall
save    "`overall'"
restore

keep     age incwage hours weeks hoursempl weeksempl educ_somecoll educ_bachelor          perwt                birthyr year bpl male
collapse age incwage hours weeks hoursempl weeksempl educ_somecoll educ_bachelor (rawsum) perwt [aw=perwt], by(birthyr year bpl male)
tempfile  bysex
save    "`bysex'"


*************************************************************************************
*   Add Comstock laws and Census region                                             *
*************************************************************************************


foreach file in overall bysex {
    use     "``file''"
    rename  bpl statefip
    merge   m:1 statefip using "$folder/griswoldlaws5.dta"
    rename  statefip bpl
    ta      bpl _merge, missing
    drop if _merge==2
    drop    _merge
    rename  bpl statefip
    merge   m:1 statefip using "$folder/region"
    rename  statefip bpl
    ta      bpl _merge, missing
    drop if _merge==2
    drop    _merge
    tempfile  `file'
    save    "``file''"
    }


*************************************************************************************
*   Generate additional covariates from supplementary file                          *
*************************************************************************************


use     "$folder/census_acs_supplement", clear

gen     _farm=(farm==2)
tab     farm year
tab     year, sum(_farm)

gen     _curmar=(marst==1 | marst==2)
tab     year marst
tab     year, sum(_curm)

gen     _Nonwhite=(race!=1)
tab     race year
tab     year, sum(_Nonwhite)

egen     _bplcat=cut(bpl), at(1,100,150,200,300,400,420,430,450,460,500,520,530,600,700,900,1000)
lab def _bplcat 1 "US" 100 "US Territories" 150 "Other NA" 200 "Central Am & Carib" 300 "South Am" ///
                  400 "N Europe" 420 "W Europe" 430 "S Europe" 450 "C/E Europe" 460 "Russian Emp" 500 "E/SE Asia" ///
                  520 "SW Asia" 530 "ME/Asia Minor" 600 "Africa" 700 "Oceania" 900 "Unknown", add
lab val _bplc _bplc

gen     _fb=(_bplcat!=1 & _bplc!=. & bpl<900)
lab var _fb "Foreign born"
tab     year, sum(_fb)

gen     _higrade=0 if higrade<4
replace _hi=. if higrade==0
replace _hi=higrade-3 if higrade>=4
sum     _higrade higrade if higrade!=0
tab     year, sum(_higrade)

gen     _inctot=. if year==1940 | age<16
replace _inctot=inctot*7 if year==1950 & inct!=999999 & age>=16
replace _inctot=inctot*5.725 if year==1960 & inct!=999999 & age>=16
replace _inctot=inctot*4.540 if year==1970 & inct!=999999 & age>=16
replace _inctot=inctot*2.314 if year==1980 & inct!=999999 & age>=16
lab var _inctot "Real income in 1999$"

gen     _poverty=(poverty<=100)
replace _poverty=. if year==1940 | year==1950

keep if age>=15 | age<=44
gen     wgt=slwt if year==1950 | year==1940
replace wgt=perwt if year!=1950 & year!=1940
sum     _* [w=wgt]
drop if statef==15 | statef==2 | statef==99 | statef==11

collapse (rawsum) wgt (mean) _farm _curmar _Nonwhite _fb _higrade _inctot _poverty [w=wgt], by(statef year)

rename wgt pop

xtset   statef year

tsfill

tokenize `"_farm _curmar _Nonwhite _fb _higrade _inctot _poverty pop"'
    while "`1'"!="" {
    by statef: ipolate `1' year, gen(_`1')
    drop `1'
    rename _`1' `1'
    macro shift
    }

rename  year birthyear

rename  statefip bpl

for var _farm _curmar _Nonwhite _fb _higrade  _inctot _poverty: rename X D_CST_X
drop if birthyear>1980
isid    birthyear bpl
sort    bpl birthyear
keep if birthyear>=1946 & birthyear<=1980
tempfile  temp4_all
save    "`temp4_all'"

gen     male=1
tempfile  temp5
save    "`temp5'"

use     "`temp4_all'", clear
append using "`temp5'"
replace male=0 if male==.
drop if bpl==2 | bpl==15 | bpl==11
sort    bpl birthyear male
keep if birthyear>=1946 & birthyear<=1980
tempfile  temp4_sex
save    "`temp4_sex'"

use     "`overall'", clear
rename birthyr birthyear
drop if bpl==2 | bpl==15 | bpl==11
sort    bpl birthyear
merge   m:m bpl birthyear using "`temp4_all'"
tab     birthyear _merge
assert  _merge==3
drop    _merge
tempfile  overall
save    "`overall'"

use     "`bysex'", clear
rename birthyr birthyear
drop if bpl==2 | bpl==15 | bpl==11
sort    bpl birthyear male
merge   m:m bpl birthyear male using "`temp4_sex'"
tab     birthyear _merge
assert  _merge==3
drop    _merge
tempfile  bysex
save    "`bysex'"


*************************************************************************************
*   Restrict the sample and construct additional variables                          *
*************************************************************************************


foreach file in overall bysex {
    use     "``file''"
    keep if age<=64
    tempfile  `file'
    save    "``file''"
    }

foreach file in overall bysex {
    use     "``file''"
    gen     stfips=bpl
    gen     abortion=(stfips==6 | stfips==36 | stfips==53 | stfips==2 | stfips==15)
    replace abortion=. if stfips==.
    gen     D70=(birthyear>1970)
    gen     D73=(birthyear>1973)
    gen     D76=(birthyear>1976)
    egen    _birthyear=cut(birthyear), at(1940,1946,1950,1954,1958,1962,1966,1970,1974,1981)
    char    _birthyear[omit] 1950
    char    birthyear[omit] 1958
    gen     age2 = age *age
    gen     age3 = age *age2
    gen     age4 = age2*age2
    tempfile  `file'
    save    "``file''"
    }

use     "`overall'", clear
gen     log_ftotinc_z=log(ftotinc_z)
replace sales = 1-sales
tempfile  overall
save    "`overall'"

use     "`bysex'", clear
gen     log_incwag    =log(incwage)
gen     log_SCG       =log(educ_somecoll)
gen     log_BA        =log(educ_bachelor)
gen     log_weeks     =log(weeks)
gen     log_hours     =log(hours)
gen     log_weeksempl =log(weeksempl)
gen     log_hoursempl =log(hoursempl)
replace sales = 1-sales
tempfile  bysex
save    "`bysex'"


*************************************************************************************
*   Figures 6 and 7                                                                 *
*************************************************************************************

local X1 "i.reg*i.birthyear i.any*i._birthyear i._Phys*i._birthyear i.abortion*i._birthyear i.sales*i._birthyear age age2"
local X2 "D_CST__farm D_CST__curmar D_CST__Nonwhite D_CST__fb D_CST__higrade `X1'"


use     "`overall'", clear
local r replace
tokenize `"log_ftotinc_z"'
while "`1'"!="" {
    xi: areg `1' `X2' [pw=perwt] , cluster(stfips) level(95) a(stfips)
    sum `1' [aw=perwt] if e(sample) & birthyear<=1957 & birthyear>=1950
    local rmean = r(mean)
    testparm _IsalX_bi_1_1958 _IsalX_bi_1_1962
    outreg2 _Isal* using "$folder/Output/figure6_7.xls", `r' br addstat("Mean DV 5057", `rmean', "P 58,62", `r(p)') bdec(6)
    local r append
    macro shift
    }

use     "`bysex'", clear
tokenize `"log_incwag log_hours log_hoursempl log_weeks log_weeksempl log_BA log_SCG"'
while "`1'"!="" {
    xi: areg `1' `X2' [pw=perwt] if male==1, cluster(stfips) level(95) a(stfips)
    sum `1' [aw=perwt] if e(sample) & birthyear<=1957 & birthyear>=1950
    local rmean = r(mean)
    testparm _IsalX_bi_1_1958 _IsalX_bi_1_1962
    outreg2 _Isal* using "$folder/Output/figure6_7.xls", append br addstat("Mean DV 5057", `rmean', "P 58,62", `r(p)') bdec(6)
    macro shift
    }

use     "`bysex'", clear
tokenize `"log_BA log_SCG"'
while "`1'"!="" {
    xi: areg `1' `X2' [pw=perwt] if male==0, cluster(stfips) level(95) a(stfips)
    sum `1' [aw=perwt] if e(sample) & birthyear<=1957 & birthyear>=1950
    local rmean = r(mean)
    testparm _IsalX_bi_1_1958 _IsalX_bi_1_1962
    outreg2 _Isal* using "$folder/Output/figure6_7.xls", append br addstat("Mean DV 5057", `rmean', "P 58,62", `r(p)') bdec(6)
    macro shift
    }


log close