
***************************
*Create UK Graphs         *
***************************


clear all
set more off

use ".../bsa_4vars_allyrs.dta"


*Generate two categories of age*
gen     age_65=age>=65
replace age_65=. if age==99 | age==17
gen age_18_64=age>=18 & age<65
replace age_18_64=. if age==99 | age==17

*Label categories of age*
label var age_65 "Ages 65 and older"
label var age_18_64 "Ages 18-64" 


*Drop observations of "incdiff"  for years 2006 & 2012 because they don't include middle category *
foreach i of varlist incdiff{
replace `i'=. if year==2006 | year==2012
}

*Create "incdiff" & "incomgap" mean per year for age 65 and older and the rest*
foreach i of varlist incdiff incomgap redistrb{
egen `i'_65=wtmean(`i') if age_65==1, by(year) weight(wtfactor)
egen `i'_18_64=wtmean(`i') if age_18_64==1, by(year) weight(wtfactor)
}

*[ Graph: Appendix Figure 1: Agreement that government should reduce income differences, elderly versus others, British Social Attitudes survey ]*
graph twoway  (scatter incdiff_18_64 year, m(Sh) mlw(medium) msize(medium) mlc(blue)  ) (scatter incdiff_65 year,  m(Oh) mlw(medium) msize(medium) mlc(green)  )  (lfit incdiff_65 year if year<2005, lc(green)) (lfit incdiff_65 year, lc(green)) (lfit incdiff_18_64 year if year<2005, lc(blue)) (lfit incdiff_18_64 year, lc(blue)) if year>=1985, scheme(aspen) legend(on) xlabel(1985(5)2010) ylabel(3.25(.25)3.75 ,nogrid) legend(off) xtitle("")  graphregion(color(white)) legend(on) legend(label(1 "Under age 65") label(2 "Age 65 and older") order(1 2))
graph export .../fig_a1.eps, replace  




