
***************************
* ANES Analysis           *
***************************


clear all
set more off
*set maxvar 10000
graph set eps fontface "Times"

use ".../anes_cdf.dta"


*Generate weight variable*
rename VCF0009a weight

*Generate age variable and missing values*
gen age=VCF0101 if VCF0101!=0 & VCF0101!=. 

*Generate age groups variables*
gen age18_29=age<30 if age!=.
gen age30_39=age>29 & age<40 if age!=.
gen age40_49=age>39 & age<50 if age!=.
gen age50_59=age>49 & age<65 if age!=.
gen age65=age>64 if age!=.

*Generate variable year*
rename VCF0004 year

*Generate variable gender*
gen gender=VCF0104 if VCF0104!=0
gen male=gender==1 if gender!=.
gen female=gender==2 if gender!=.

*Generate variable race*
gen race=VCF0106a if VCF0106a!=0 & VCF0106a!=.
gen white=race==1 if race!=.
gen black=race==2 if race!=.

*Generate variable of interest Gov should guaranteed jobs and income scale* 
gen govjobinc_temp=VCF0809 if VCF0809!=0  & VCF0809!=.
*Fliping variable govjobinc, increasing for redistribution*
gen govjobinc=8-govjobinc_temp if VCF0809<9
drop govjobinc_temp

*Generate variable Gov should provide health insurance*
gen govhealth_temp=VCF0806 if VCF0806>0 & VCF0806<9
*Flipping variable govhealth_temp, increasing for redistribution*
gen govhealth=8-govhealth_temp

*Generate variable help blacks"
gen helpblacks_temp=VCF0830 if VCF0830>0 & VCF0830<9
*Flipping variable helpblacks_temp, increasing for redistribution*
gen helpblacks=8-helpblacks_temp

*Generate variable Republican support*
gen repubsup=VCF0301 if VCF0301>0 & VCF0301<=7



***GRAPHS with ANES***

gen wgt=weight

*[ FIGURE 2: Trends in redistributive support ]*

* (d) Govt should guaranteed work, st. living (17) *

preserve
sum govjobinc if repubsup<4 [aw=weight] 
local dem_mean=`r(mean)' 
sum govjobinc if repubsup>4 & repubsup<=7 [aw=weight] 
local rep_mean=`r(mean)' 
sum govjobinc if repubsup<=7 [aw=weight] 
local avg=`r(mean)' 
gen govjobinc_scaled=(govjobinc - `avg')/(`dem_mean' - `rep_mean') 
sum govjobinc govjobinc_scaled
reg govjobinc_scaled year [pw=weight], cluster(year)
local beta1=round(_b[year], .0001) 
local se1=round(_se[year], .0001) 
collapse (mean) govjobinc govjobinc_scaled [aw=weight], by(year)


#delimit ;

graph twoway (scatter govjobinc year)  (scatter govjobinc_scaled year, m(none) yaxis(2)) (lfit govjobinc year)  if year>=1971, 
scheme(aspen) legend(on) xlabel(1970(10)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") 
 text(3.8 2000 "{&beta}=`beta1' [`se1']",  size(*1.2)) legend(off)   ;

#delimit cr 
 
 graph export .../fig_2d.eps, replace
restore


*[ FIGURE 3: Trends in redistributive support, by age and race ]*

* (b) Govt sd. guaranteed work, st. living (ANES), age
preserve
sum govjobinc if repubsup<4 [aw=weight] 
local dem_mean=`r(mean)' 
sum govjobinc if repubsup>4 & repubsup<=7 [aw=weight] 
local rep_mean=`r(mean)' 
sum govjobinc if repubsup<=7 [aw=weight] 
local avg=`r(mean)' 
gen govjobinc_scaled=(govjobinc - `avg')/(`dem_mean' - `rep_mean') 
sum govjobinc govjobinc_scaled
reg govjobinc_scaled year if age65==1 [pw=weight], cluster(year)
local beta1=round(_b[year], .0001) 
local se1=round(_se[year], .0001) 
reg govjobinc_scaled year if age65==0 [pw=weight], cluster(year)
local beta2=round(_b[year], .0001) 
local se2=round(_se[year], .0001) 
collapse (mean) govjobinc govjobinc_scaled [aw=weight], by(age65 year)
#delimit ;
graph twoway (scatter govjobinc year if age65==0, m(Sh) mlw(medium) msize(medium) mlc(blue)) 
 (scatter govjobinc_scaled year if age65==0, m(none) yaxis(2)) (scatter govjobinc year if age65==1, m(Oh) mlw(medium) msize(medium) mlc(green) )  
 (scatter govjobinc_scaled year if age65==1, m(none) yaxis(2))  (lfit govjobinc year if age65==1) 
 (lfit govjobinc year if age65==0) if year>=1971, 
 scheme(aspen) legend(on) xlabel(1970(10)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) 
 ytitle(Raw Variable Values, axis(1)) xtitle("")  
 text(3.8 2000 "{&beta}=`beta2' [`se2']", size(*1.2)) text(3.4 2000 "{&beta}=`beta1' [`se1']", size(*1.2)) 
 legend(label(1 "Under age 65") label(2 "Age 65 and older") order(1 2))   ;
 
#delimit cr 
 
graph export .../fig_3b.eps, replace
restore


* (d) Govt sd. guaranteed work, st. living (ANES), race *
preserve 
drop if race==3 | race==4 | race==5 | race==7
tab race, nolab miss
sum govjobinc if repubsup<4 [aw=weight] 
local dem_mean=`r(mean)' 
sum govjobinc if repubsup>4 & repubsup<=7 [aw=weight] 
local rep_mean=`r(mean)' 
sum govjobinc if repubsup<=7 [aw=weight]
local avg=`r(mean)' 
gen govjobinc_scaled=(govjobinc - `avg')/(`dem_mean' - `rep_mean') 
sum govjobinc govjobinc_scaled
reg govjobinc_scaled year if white==1 [pw=weight], cluster(year)
local beta1=round(_b[year], .0001) 
local se1=round(_se[year], .0001) 
reg govjobinc_scaled year if white==0 [pw=weight], cluster(year)
local beta2=round(_b[year], .0001) 
local se2=round(_se[year], .0001) 
collapse (mean) govjobinc govjobinc_scaled [aw=weight], by(white year)

#delimit ;
graph twoway (scatter govjobinc year if white==1, m(Sh) mlw(medium) msize(medium) mlc(blue))  
(scatter govjobinc_scaled year if white==1, m(none) yaxis(2)) (scatter govjobinc year if white==0, m(Oh) mlw(medium) msize(medium) mlc(green)) 
 (scatter govjobinc_scaled year if white==0, m(none) yaxis(2))  (lfit govjobinc year if white==1) 
 (lfit govjobinc year if white==0) if year>=1971, 
 scheme(aspen) legend(on) xlabel(1970(10)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) 
 xtitle("")  text(4.3 2000 "{&beta}=`beta2' [`se2']", size(*1.2)) text(3.25 2000 "{&beta}=`beta1' [`se1']", size(*1.2)) 
 legend(label(1 "Whites") label(2 "Blacks") order(1 2))   ;
#delimit cr
graph export .../fig_3d.eps, replace
restore

*[ FIGURE 4: Trends in redistributive support, by gender ]*

* (b) Govt sd. guaranteed work, st. living (ANES), gender *
preserve
sum govjobinc if repubsup<4 [aw=weight] 
local dem_mean=`r(mean)' 
sum govjobinc if repubsup>4 & repubsup<=7 [aw=weight] 
local rep_mean=`r(mean)' 
sum govjobinc if repubsup<=7 [aw=weight] 
local avg=`r(mean)' 
gen govjobinc_scaled=(govjobinc - `avg')/(`dem_mean' - `rep_mean') 
sum govjobinc govjobinc_scaled
reg govjobinc_scaled year if male==1 [pw=weight], cluster(year)
local beta1=round(_b[year], .0001) 
local se1=round(_se[year], .0001) 
reg govjobinc_scaled year if male==0 [pw=weight], cluster(year)
local beta2=round(_b[year], .0001) 
local se2=round(_se[year], .0001) 
collapse (mean) govjobinc govjobinc_scaled [aw=weight], by(male year)
#delimit ;
graph twoway (scatter govjobinc year if male==1, m(Sh) mlc(blue) mlw(medium) msize(medium)) 
 (scatter govjobinc_scaled year if male==1, m(none) yaxis(2)) 
 (scatter govjobinc year if male==0, m(Oh) mlc(green) mlw(medium) msize(medium))  
 (scatter govjobinc_scaled year if male==0, m(none) yaxis(2))  (lfit govjobinc year if male==1) 
 (lfit govjobinc year if male==0) if year>=1971, 
 scheme(aspen) legend(on) xlabel(1970(10)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) 
 ytitle(Raw Variable Values, axis(1)) xtitle("")  
 text(3.8 2001 "{&beta}=`beta2' [`se2']", size(*1.2)) text(3.4 2000 "{&beta}=`beta1' [`se1']", size(*1.2)) 
 legend(label(1 "Men") label(2 "Women") order(1 2))   ;
 
#delimit cr
 
graph export .../fig_4b.eps, replace
restore

*[ FIGURE 6: Trends in support for government health insurance, by age ]*

* (b) Govt sd. provide health ins. for all, ANES, age *
preserve
sum govhealth if repubsup<4 [aw=weight] 
local dem_mean=`r(mean)' 
sum govhealth if repubsup>4 & repubsup<=7 [aw=weight] 
local rep_mean=`r(mean)' 
sum govhealth if repubsup<=7 [aw=weight] 
local avg=`r(mean)' 
gen govhealth_scaled=(govhealth - `avg')/(`dem_mean' - `rep_mean') 
sum govhealth_scaled
reg govhealth_scaled year if age65==1 [pw=weight], cluster(year)
local beta1=round(_b[year], .0001) 
local se1=round(_se[year], .0001) 
reg govhealth_scaled year if age65==0 [pw=weight], cluster(year)
local beta2=round(_b[year], .0001) 
local se2=round(_se[year], .0001) 
collapse (mean) govhealth govhealth_scaled [aw=weight], by(age65 year)

#delimit ;
graph twoway  (scatter govhealth year if age65==0, m(Sh) mlc(blue) mlw(medium) msize(medium))  
(scatter govhealth_scaled year if age65==0, m(none) yaxis(2)) 
(scatter govhealth year if age65==1, m(Oh) mlc(green) mlw(medium) msize(medium)) 
 (scatter govhealth_scaled year if age65==1, m(none) yaxis(2)) 
 (lfit govhealth year if age65==1) (lfit govhealth year if age65==0) if year>=1969, 
 scheme(aspen) legend(on) xlabel(1970(10)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) 
 ytitle(Raw Variable Values, axis(1)) xtitle("")  text(3.9 2000 "{&beta}=`beta1' [`se1']", size(*1.2)) 
 text(4.4 2000 "{&beta}=`beta2' [`se2']", size(*1.2)) 
 legend(label(1 "Under age 65") label(2 "Age 65 and older") order(1 2))  ;
 #delimit cr
 
graph export .../fig_6b.eps, replace
restore

*[ FIGURE 8: Trends in redistributive support ]*

* (b) Govt sd. help blacks, ANES, race *
preserve
drop if race==3 | race==4 | race==5 | race==7
sum helpblacks if repubsup<4 [aw=weight] 
local dem_mean=`r(mean)' 
sum helpblacks if repubsup>4 & repubsup<=7 [aw=weight] 
local rep_mean=`r(mean)' 
sum helpblacks if repubsup<=7 [aw=weight] 
local avg=`r(mean)' 
gen helpblacks_scaled=(helpblacks - `avg')/(`dem_mean' - `rep_mean') 
sum helpblacks helpblacks_scaled
reg helpblacks_scaled year if white==1 [pw=weight], cluster(year)
local beta1=round(_b[year], .0001) 
local se1=round(_se[year], .0001) 
reg helpblacks_scaled year if white==0 [pw=weight], cluster(year)
local beta2=round(_b[year], .0001) 
local se2=round(_se[year], .0001) 
collapse (mean) helpblacks helpblacks_scaled [aw=weight], by(white year)

#delimit ;
graph twoway (scatter helpblacks year if white==1, m(Sh) mlc(blue) mlw(medium) msize(medium))  
(scatter helpblacks_scaled year if white==1, m(none) yaxis(2)) 
(scatter helpblacks year if white==0, m(Oh) mlc(green) mlw(medium) msize(medium))
  (scatter helpblacks_scaled year if white==0, m(none) yaxis(2))  (lfit helpblacks year if white==1)
  (lfit helpblacks year if white==0) if year>=1969, 
  scheme(aspen) legend(on) xlabel(1970(10)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) 
  ytitle(Raw Variable Values, axis(1)) xtitle("")  
  text(5.3 2000 "{&beta}=`beta2' [`se2']", size(*1.2)) 
  text(3.4 2000 "{&beta}=`beta1' [`se1']", size(*1.2)) 
  legend(label(1 "Whites") label(2 "Blacks") order(1 2))  ;
#delimit cr
graph export .../fig_8b.eps, replace
restore


