*German GSS (Allbus)
*Prepare cumulative datafile for analysis

*cd "/dir"
use13 "ZA4580_v1-0-0.dta"

generate year = V2

generate age = V651

generate agegroup = .
replace agegroup = 1 if (age >= 18) & (age <= 29)
replace agegroup = 2 if (age >= 30) & (age <= 39)
replace agegroup = 3 if (age >= 40) & (age <= 49)
replace agegroup = 4 if (age >= 50) & (age <= 64)
replace agegroup = 5 if (age >= 65) & (age < 997)

label define agegroupl 1 "18-29" 2 "30-39" 3 "40-49" 4 "50-64" 5 "65 and older"
label values agegroup agegroupl
tab agegroup

generate age65 = .
replace age65 = 0 if age >= 18 & age < 65
replace age65 = 1 if age >= 65 & age < 997

generate age40 = .
replace age40 = 0 if age >= 18 & age < 40
replace age40 = 1 if age >= 40 & age < 997

generate region = V5

generate socclass = .
replace socclass = 1 if V155 == 1 | V155 == 2
replace socclass = 2 if V155 == 3
replace socclass = 3 if V155 == 4 | V155 == 5

generate secinc = .
replace secinc = 5-V183 if V183 >= 1 & V183 <= 4

generate decinc = .
replace decinc = 5-V205 if V205 >= 1 & V205 <= 4

generate motiv = .
replace motiv = V206 if V206 >= 1 & V206 <= 4

generate wtfactor = V1741
generate wtewind = V1739

keep year age agegroup age65 age40 region socclass secinc decinc motiv wtfactor wtewind

save allbus_allyrs.dta, replace






