* Swedish National Election Study
* Subset and append multiple cross-sections


clear
cd "/dir"

* 1988
use "0227us.dta"

tab v5
tab v368
tab v121

labelbook v5
labelbook v368
codebook v121

generate year = 1988
generate weight = v5
generate agegroup = v368
generate incdiff = v121

keep year weight agegroup incdiff

save d1
clear

* 1991
use "0391us.dta"

tab v5
tab v439
tab v130

labelbook v5
labelbook v439
codebook v130

generate year = 1991
generate weight = v5
generate agegroup = v439
generate incdiff = v130

keep year weight agegroup incdiff

save d2
clear

* 1994
use "0570us.dta"

tab v481
tab v131

labelbook v481
codebook v131

generate year = 1994
generate agegroup = v481
generate incdiff = v131

keep year agegroup incdiff

save d3
clear

* 1998
use "0750us.dta"

tab v464
tab v142

labelbook v464
codebook v142

generate year = 1998
generate agegroup = v464
generate incdiff = v142

keep year agegroup incdiff

save d4
clear

*2002
use "0812us.dta"

tab v585
tab v153

labelbook v585
codebook v153

generate year = 2002
generate agegroup = v585
generate incdiff = v153

keep year agegroup incdiff

save d5
clear

*2006
use "0861us.dta" 

tab age7
tab v406

codebook age7
codebook v406

generate year = 2006
generate agegroup = age7
generate incdiff = v406

keep year agegroup incdiff

save d6
clear


* Apend datasets

use d1, clear
append using d2 d3 d4 d5 d6 

codebook incdiff
replace incdiff = 6 - incdiff
label define incdiffl 5 "Very good proposal" 4 "Fairly good proposal" 3 "Neither" 2 "Fairly bad proposal" ///
1 "Very bad proposal"
label values incdiff incdiffl

replace incdiff = . if incdiff < 1 | incdiff > 5
tab incdiff

generate age60 = .
replace age60 = 0 if agegroup < 6
replace age60 = 1 if agegroup >= 6

replace weight = 1 if weight == .

save snes_allyrs.dta, replace
