
*Sweden SNES 

***************************
*Create Sweden Graphs     * 
***************************

clear all
set more off

use ".../snes_allyrs.dta"

*Create "incdiff" mean per year for age 65 and older and the rest*
foreach i of varlist incdiff{
egen `i'_60=wtmean(`i') if age60==1, by(year) weight(weight)
egen `i'_18_59=wtmean(`i') if age60==0, by(year) weight(weight)
}

*[ Graph: Appendix Figure 3: Agreement with proposal to reduce income differences in society, elderly versus others, Swedish National Election Studies (SNES) Program ]*
graph twoway  (scatter incdiff_18_59 year, m(Sh) mlw(medium) msize(medium) mlc(blue)  )  (scatter incdiff_60 year,  m(Oh) mlw(medium) msize(medium) mlc(green)  )  (lfit incdiff_18_59 year, lc(blue))   (lfit incdiff_60 year, lc(green))  if year>=1987, scheme(aspen) xlabel(1990(5)2005) ylabel(,nogrid) legend(off) xtitle("")  graphregion(color(white)) legend(on) legend(label(1 "Under age 61") label(2 "Age 61 and older") order(1 2)) 
graph export .../fig_a3.eps, replace  



