***************************
* GSS Analysis            *
***************************


clear all
set maxvar 10000
set more off
use ".../GSS7212_R2.DTA"

                           ***CLEANING DATA***

*Drop those who would not have been included in previous interviews BC, only speaks spanish*
drop if spanint==2 

*Generate weights (oversamp*wtssall)*
gen wgt=wtssall*oversamp 

*Capturing missed observations as "." for programming*
foreach i of varlist age race sex homosex gunlaw abany degree realinc happy health kidssol parsol partyid polviews attend helpsick eqwlth helppoor helpnot helpsick natfare getahead tax helpblk{
replace `i'=. if `i'==.i | `i'==.d | `i'==.n
}

* Generate year dummies*
xi i.year, noomit

*************************** 1.TRENDS IN REDISTRIBUTIVE DEMAND ***************************************************************

**Question 1 on redistribution: "Gov should reduce diferences" Flipping variable, increasing in support for redistribution**

gen reducedif = 8-eqwlth

**Question 2 on redistribution: "Gov should improve living of poor Americans" Flipping variable, increasing in support for redistribution**

gen imppoor=6-helppoor

**Question 3 on redistribution: "Gov should do more to solve country's problems" Flipping variable, increasing in support for redistribution**

gen govrole=6-helpnot 

**Other question of interes: "Gov should pay for medical bills" Flipping variable, increasing in support for redistribution**

gen hsick=6-helpsick

**Other question of interes: "Are we spending too much, about righ or too little on welfare"**

gen welfare= 4-natfare 

**Other question of interes: "How people get ahead"**

gen luck=getahead if getahead<4
gen luck_help=getahead==1
gen both_eq=getahead==2
gen hard_work=getahead==3


***Other question of interes: "Opinion about federal income tax"**

gen tax_low=tax==3
gen tax_right=tax==2
gen tax_high=tax==1

**Other question of interes: "Gov should make every possible effort to help blacks even it means preferential treatment"**
gen helpblack=6-helpblk


*Other question of interes: Political party affiliation Flipping values, increasing in support for democrats(redistribution)*
gen demosupport=7-partyid if partyid!=7 

*Generate Political Party "independents" and "other party" are dropped*
gen democrat=demosupport>4 & demosupport!=.
gen republican=demosupport<4 & demosupport>0

gen repsupport=partyid if partyid!=7

*Other question of interest: Abortion if woman wants for any reason*
gen abortionyes=abany==1 

*Other question of interest: Favor gun permits*
gen gunsyes=gunlaw==1 

*Other question of interest: Homosexual sex relations*
gen homosexno=5-homosex
replace homosexno=. if homosexno==0 

*Other question of interest: Attends religious services*
gen attendyes=attend>5 if attend!=. 

*Other question of interest: Region of interview
gen south=region>4 & region<8 if region!=.

*Other question of interes: General Happiness, Flipping values, increasing in Happiness*
gen happyi=4-happy

*Other question of interest: Condition of Health*
gen healthi=5-health


						  ***CREATE SUBGROUPS OF COMPARISON***
						
**AGE** 
*Generate age dummies*
*Generate AGE dummies*
gen age_1=age<30 if age!=.
gen age_2=age>=30 & age<=39 if age!=.
gen age_3=age>=40 & age<=49 if age!=.
gen age_4=age>=50 & age<=64 if age!=.
gen age_5=age>=65 if age!=.
gen young=age<=64 if age!=.
gen old=age_5 


**BIRTH COHORTS** 
*Generate cohort dummies by decades*
gen born_1902_1911=cohort>=1902 & cohort<1912
gen born_1912_1921=cohort>=1912 & cohort<1922
gen born_1922_1931=cohort>=1922 & cohort<1932
gen born_1932_1941=cohort>=1932 & cohort<1942
gen born_1942_1951=cohort>=1942 & cohort<1952
gen born_1952_1961=cohort>=1952 & cohort<1962
gen born_1962_1971=cohort>=1962 & cohort<1972
*Create cohort Support mean by year*
foreach i of varlist born_1902_1911 born_1912_1921 born_1922_1931 born_1932_1941 born_1942_1951 born_1952_1961 born_1962_1971{
egen `i'_reduceif=wtmean(reducedif) if `i'==1, by(year) weight(wgt)
}

**RACE** 
*Generate race dummies*
gen white=race==1
gen black=race==2


**GENDER** 
*Generate gender dummies*
gen male=sex==1
gen fem=sex==2

**Interactions**
gen bl_fem=black*fem
gen wt_fem=white*fem
gen bl_male=black*male
gen wt_male=white*male
gen bl_old=black*age_5
gen wt_old=white*age_5
gen bl_young=black*young
gen wt_young=white*young


**INCOME** 
*With income adjusted to 2014 dollars, adjust for household size*
gen homepop_adj=1 + .5*(adults-1) + .3*(babies+preteen+teens) 
gen realinc_hp_adj=realinc/homepop_adj
replace realinc_hp_adj=0 if realinc==. 
*Generate income quintiles per year*
gen quin5=.
*Generate missed obs for income*
gen missob_inc=realinc_hp_adj==0

*Generate a list of years in the GSS*
local yearlist=" " 
qui tab year, matrow(yearlist) 
local lis=rowsof(yearlist)
forval x=1/`lis' { 
local alt=yearlist[`x', 1] 
local yearlist="`yearlist' `alt'" 
} 
di "`yearlist'"


*Generate income quintiles*
foreach y in `yearlist' { 
xtile quintile = realinc_hp_adj if year==`y' & realinc_hp_adj!=0 [aw=wgt], n(5) 
*Drop missing obs*
replace quin5=quintile if year==`y' 
drop quintile 
} 
replace quin5=0 if quin5==. 
*Generate Top quintile and The rest dummies*
gen topq=quin5==5
gen rest=quin5<5

**EDUCATIONAL ATTAINMENT** 
*Generate degree dummies for highschool and college*
gen high=degree>0 & degree!=. 
gen coll=degree>2 & degree!=. 
gen nohigh=1-high 
*Generate missing dummy
gen     degree_miss=degree==.
*Adapt original degree
gen     degree2=degree
replace degree2=0 if degree_miss==1

**MARITAL SITUATION** 
gen married=marital==1
						  ***VARIABLES OF INTERES (NORMAL AND SCALED)***


**Generate Scaled Partisan values**
foreach i of varlist reducedif imppoor govrole hsick welfare luck_help both_eq hard_work tax_low tax_right tax_high helpblack luck{
*Generate Democrat Avarage*
egen `i'_dem_prev=mean(`i') if democrat==1
egen `i'_dem=max(`i'_dem_prev)
drop `i'_dem_prev
*Generate Republican Avarage*
egen `i'_rep_prev=mean(`i') if republican==1
egen `i'_rep=max(`i'_rep_prev)
drop `i'_rep_prev
gen `i'_dif_dem_rep=`i'_dem-`i'_rep
*Generate all respondents Avarage*
egen `i'_mean=mean(`i')
egen `i'_mean_g=wtmean(`i'), by(year) weight(wgt)
*Generate Scaled values*
gen `i'_scaled=(`i'-`i'_mean)/`i'_dif_dem_rep
egen `i'_scaled_mean=wtmean(`i'_scaled), by(year) weight(wgt)
}

*Tables by year with Native Units for questions 1, 2, 3*
foreach i of varlist reducedif imppoor govrole{
tabstat `i' [w=wgt], by(year) s(mean)
*Tables by year with Linear Transformation (Partisan Gap) for questions 1, 2,3*
tabstat `i'_scaled_mean, by(year) s(mean)
}


				  ***VARIABLES OF INTERES BY SUBGROUPS OF COMPARISON (NORMAL AND SCALED)***

*Generate Scaled Partisan values*
foreach i of varlist reducedif imppoor govrole hsick welfare luck_help both_eq hard_work tax_low tax_right tax_high helpblack luck{
*Group Decomposition
foreach j of varlist age_1 age_2 age_3 age_4 age_5 young old white black male fem topq rest coll high married nohigh attendyes south{
*Generate Democrat Avarage*
egen `i'_dem_`j'_p=mean(`i') if democrat==1 & `j'==1
egen `i'_dem_`j'=max(`i'_dem_`j'_p)
drop `i'_dem_`j'_p
*Generate Republican Avarage*
egen `i'_rep_`j'_p=mean(`i') if republican==1 & `j'==1
egen `i'_rep_`j'=max(`i'_rep_`j'_p)
drop `i'_rep_`j'_p
*Generate Dif Democrats-Republican Avarage*
gen `i'_dif_dr_`j'=`i'_dem_`j'-`i'_rep_`j'
*Generate all respondents Avarage*
egen `i'_mean_`j'=mean(`i') if `j'==1
egen `i'_mean_g_`j'_p=mean(`i') if `j'==1, by(year)
egen `i'_mean_g_`j'=max(`i'_mean_g_`j'_p), by(year)
drop `i'_mean_g_`j'_p
*Generate Scaled values*
gen `i'_scaled_`j'_p=(`i'-`i'_mean_`j')/`i'_dif_dr_`j' if `j'==1
egen `i'_scaled_`j'=wtmean(`i'_scaled_`j'_p), by(year) weight(wgt)
drop `i'_scaled_`j'_p
}
}


				  ***GRAPHS with GSS***

*[ FIGURE 1: other data set ]*

*(We use two best fit lines: a longer one (1978-2012) for all years we have data and a shorter one (1978-2006) for the perios before the great depression and before Obama's administration)*


*[ FIGURE 2: Trends in redistributive support ]*

* (a) Govt should reduce income differences (17)(GSS) *
reg reducedif_scaled_mean year if year<2007 [aw=wgt], cl(year)
local beta=round(_b[year], .0001) 
local se=round(_se[year], .0001)
graph twoway (scatter reducedif_mean_g year) (scatter reducedif_scaled_mean year, m(none) yaxis(2)) (lfit reducedif_scaled_mean year, yaxis(2)) (lfit reducedif_scaled_mean year if year<=2006, yaxis(2)) if year>=1978, legend(off) xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title((a) Govt should reduce income differences (17) (GSS)) graphregion(color(white)) text(4.4 2000 "{&beta}=`beta' [`se']", size(*0.5))  
graph export fig_2a.eps, replace

* (b) Govt should help poor (15)(GSS) *
reg imppoor_scaled_mean year if year<2007 [aw=wgt], cl(year)
local beta=round(_b[year], .0001) 
local se=round(_se[year], .0001)
graph twoway (scatter imppoor_mean_g year) (scatter imppoor_scaled_mean year, m(none) yaxis(2)) (lfit imppoor_scaled_mean year, yaxis(2)) (lfit imppoor_scaled_mean year if year<=2006, yaxis(2)) if year>=1975, legend(off) xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title((b) Govt should help poor (15) (GSS)) graphregion(color(white)) text(3.2 2000 "{&beta}=`beta' [`se']", size(*0.5))  
graph export fig_2b.eps, replace

* (c) Govt should do more (15)(GSS) * 
*[There is an inconsistensy in (c), figure 2. the lfit of the lines are done with other variables (not scaled ones)]*
reg govrole_scaled_mean year if year<2007 [aw=wgt], cl(year)
local beta=round(_b[year], .0001) 
local se=round(_se[year], .0001)
graph twoway (scatter govrole_mean_g year) (scatter govrole_scaled_mean year, m(none) yaxis(2)) (lfit govrole_scaled_mean year, yaxis(2)) (lfit govrole_scaled_mean year if year<=2006, yaxis(2)) if year>=1975, legend(off) xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title((c) Govt should do more (15) (GSS)) graphregion(color(white)) text(3 2000 "{&beta}=`beta' [`se']", size(*0.5))  
graph export fig_2c.eps, replace


*[ FIGURE 3: Trends in redistributive support, by age and race (GSS) ]*

* (a) Govt should reduce income differences (17), by Age (GSS) *
reg reducedif_scaled_age_5 year if year<2007 [aw=wgt], cl(year)
local beta_1=round(_b[year], .0001) 
local se_1=round(_se[year], .0001)
reg reducedif_scaled_young year if year<2007 [aw=wgt], cl(year)
local beta_2=round(_b[year], .0001) 
local se_2=round(_se[year], .0001)
graph twoway (scatter reducedif_mean_g_young year)  (scatter reducedif_scaled_young year, m(none) yaxis(2)) (scatter reducedif_mean_g_age_5 year)  (scatter reducedif_scaled_age_5 year, m(none) yaxis(2)) (lfit reducedif_mean_g_age_5 year) (lfit reducedif_mean_g_young year) (lfit reducedif_mean_g_young year if year<=2006) if year>=1978, xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title((a) Govt should reduce income differences (17) Age (GSS)) graphregion(color(white)) text(3.8 2000 "{&beta}=`beta_1' [`se_1']", size(*0.5)) text(4.4 2000 "{&beta}=`beta_2' [`se_2']", size(*0.5)) legend(label(1 "young") label(2 "old") order(1 2))  
graph export fig_3a.eps, replace

* (c) Govt should reduce income differences (17), by Race (GSS) *
reg reducedif_scaled_white year if year<2007 [aw=wgt], cl(year)
local beta_1=round(_b[year], .0001) 
local se_1=round(_se[year], .0001)
reg reducedif_scaled_black year if year<2007 [aw=wgt], cl(year)
local beta_2=round(_b[year], .0001) 
local se_2=round(_se[year], .0001)
graph twoway (scatter reducedif_mean_g_white year)  (scatter reducedif_scaled_white year, m(none) yaxis(2)) (scatter reducedif_mean_g_black year)  (scatter reducedif_scaled_black year, m(none) yaxis(2)) (lfit reducedif_mean_g_black year) (lfit reducedif_mean_g_white year) (lfit reducedif_mean_g_white year if year<=2006) (lfit reducedif_mean_g_black year if year<=2006) if year>=1978, xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title((c) Govt should reduce income differences (17) Race (GSS)) graphregion(color(white)) text(3.8 2000 "{&beta}=`beta_1' [`se_1']", size(*1)) text(4.4 2000 "{&beta}=`beta_2' [`se_2']", size(*1)) legend(label(1 "white") label(2 "black") order(1 2))
graph export fig_3c.eps, replace


*[ FIGURE 4: Trends in redistributive support, by gender]*

* (a) Govt should reduce income differences (17), by Gender *
reg reducedif_scaled_male year if year<2007 [aw=wgt], cl(year)
local beta_1=round(_b[year], .0001) 
local se_1=round(_se[year], .0001)
reg reducedif_scaled_fem year if year<2007 [aw=wgt], cl(year)
local beta_2=round(_b[year], .0001) 
local se_2=round(_se[year], .0001)
graph twoway (scatter reducedif_mean_g_male year)  (scatter reducedif_scaled_male year, m(none) yaxis(2)) (scatter reducedif_mean_g_fem year)  (scatter reducedif_scaled_fem year, m(none) yaxis(2)) (lfit reducedif_mean_g_fem year) (lfit reducedif_mean_g_male year) (lfit reducedif_mean_g_male year if year<=2006) (lfit reducedif_mean_g_fem year if year<=2006) if year>=1978, xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title((a) Govt should reduce income differences (17) Gender (GSS)) graphregion(color(white)) text(3.8 2000 "{&beta}=`beta_1' [`se_1']", size(*0.5)) text(4.4 2000 "{&beta}=`beta_2' [`se_2']", size(*0.5)) legend(label(1 "male") label(2 "female") order(1 2))
graph export fig_4a.eps, replace



*[ FIGURE 5: other data set ]*



*[ FIGURE 6: Trends in support for government health insurance, by age (GSS) ]*

* (a) The government should cover medical bills, by age (GSS) *
reg hsick_scaled_age_5 year if year<2007 [aw=wgt], cl(year)
local beta_1=round(_b[year], .0001) 
local se_1=round(_se[year], .0001)
reg hsick_scaled_young year if year<2007 [aw=wgt], cl(year)
local beta_2=round(_b[year], .0001) 
local se_2=round(_se[year], .0001)
graph twoway (scatter hsick_mean_g_young year)  (scatter hsick_scaled_young year, m(none) yaxis(2)) (scatter hsick_mean_g_age_5 year)  (scatter hsick_scaled_age_5 year, m(none) yaxis(2)) (lfit hsick_mean_g_age_5 year) (lfit hsick_mean_g_young year) (lfit hsick_mean_g_age_5 year if year<=2006) (lfit hsick_mean_g_young year if year<=2006) if year>=1975, xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title((a) The government should cover medical bills Age (GSS)) graphregion(color(white)) text(3.4 2000 "{&beta}=`beta_1' [`se_1']", size(*0.5)) text(3.8 2000 "{&beta}=`beta_2' [`se_2']", size(*0.5)) legend(label(1 "young") label(2 "old") order(1 2))  
graph export fig_6a.eps, replace



*[ FIGURE 7: Luck and help key to success, by race (GSS) ]*

* Luck and help key to success, by race (GSS) *
reg luck_scaled_white year if year<2007 [aw=wgt], cl(year)
local beta_1=round(_b[year], .0001) 
local se_1=round(_se[year], .0001)
reg luck_scaled_black year if year<2007 [aw=wgt], cl(year)
local beta_2=round(_b[year], .0001) 
local se_2=round(_se[year], .0001)
graph twoway (scatter luck_mean_g_white year)  (scatter luck_scaled_white year, m(none) yaxis(2)) (scatter luck_mean_g_black year)  (scatter luck_scaled_black year, m(none) yaxis(2)) (lfit luck_mean_g_black year) (lfit luck_mean_g_white year) (lfit luck_mean_g_white year if year<=2006) (lfit luck_mean_g_black year if year<=2006) if year>=1975, xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title(Luck and help key to success Race (GSS)) graphregion(color(white)) text(1.4 2000 "{&beta}=`beta_1' [`se_1']", size(*0.5)) text(1.6 2000 "{&beta}=`beta_2' [`se_2']", size(*0.5)) legend(label(1 "white") label(2 "black") order(1 2))
graph export fig_7.eps, replace


*[ FIGURE 8: Trends in support for government aid to blacks, by race (GSS) ]*
* (a) The government should treat blacks specially, by race (GSS)  *
reg helpblack_scaled_white year if year<2007 [aw=wgt], cl(year)
local beta_1=round(_b[year], .0001) 
local se_1=round(_se[year], .0001)
reg helpblack_scaled_black year if year<2007 [aw=wgt], cl(year)
local beta_2=round(_b[year], .0001) 
local se_2=round(_se[year], .0001)
graph twoway (scatter helpblack_mean_g_white year)  (scatter helpblack_scaled_white year, m(none) yaxis(2)) (scatter helpblack_mean_g_black year)  (scatter helpblack_scaled_black year, m(none) yaxis(2)) (lfit helpblack_mean_g_black year) (lfit helpblack_mean_g_white year) (lfit helpblack_mean_g_white year if year<=2006) (lfit helpblack_mean_g_black year if year<=2006) if year>=1975, xlabel(1980(5)2010) ylabel(,nogrid) ytitle(Scaled Values, axis(2)) ytitle(Raw Variable Values, axis(1)) xtitle("") title((a) The government should treat blacks specially Race (GSS) ) graphregion(color(white)) text(2.5 2000 "{&beta}=`beta_1' [`se_1']", size(*0.5)) text(3.5 1990 "{&beta}=`beta_2' [`se_2']", size(*0.5)) legend(label(1 "black") label(2 "white") order(1 2))
graph export fig_8a.eps, replace


**************** 2.CAN STANDAR MODELS OF REDISTRIBUTIVE PREFERENCES EXPLAIN SUB-GROUP TRENDS ***************************************************************

*********** 2.1 ECONOMIC SELF-INTEREST ************

**Generate category dummies for sociodemographic variables**
gen ager=round(age, 10)
tab ager, gen(age_d) miss 
tab race, gen(race_d) miss 
tab sex, gen(gender_d) miss
tab year, gen(year_d) miss
tab degree, gen(degree_d) miss 

**Generate category dummies for wellbeing variables**
tab finrela, gen(opincome_d) miss
tab happy, gen(happy_d) miss
tab class, gen(class_d) miss
tab marital, gen(marital_d) missing 
qui tab region, gen(region_d) missing 
qui tab relig16, gen(relig_d) missing
tab wrkstat, gen(work_d) miss

**Set interaction controls**
local sociod "gender_d* age_d* race_d* degree_d* work_d* marital_d* region_d* relig_d*" 
local wellbeing "happy_d* opincome_d* class_d* " 
local happy "happy_d*" 
local politicalview "abortionyes gunsno polviews homosexno demosupport" 

**Label variables**
label var homosexno "Homo. sex wrong" 
label var abortionyes "Support abortion rights" 
label var gunsyes "Support gun ownership rights" 
label var happyi "Happiness (1-3)"
label var healthi "Health (1-4)"
label var kidssol "Kids will do worse"
label var parsol "Doing worse than parents"
label var polviews "Lib to cons (1-7)" 
label var repsupport "Identify Republ. (1-7)" 
label var attend "Relig. attendence (1-9)"
label var hsick "Gov't medical care"  



**Create variables with years adjusted**
foreach v of varlist  black fem married old attendyes south coll nohigh topq{ 
gen `v'_year=`v'*(year-1975)/100
}

**Label variables with years adjusted**
label var black_year "Black x (Year-1975)/100"
label var fem_year "Female x (Year-1975)/100"
label var married_year "Married x (Year-1975)/100"
label var old_year "Elderly x (Year-1975)/100"
label var attendyes_year "Attends regularly x (Year-1975)/100"
label var south_year "South x (Year-1975)/100"
label var coll_year "College x (Year-1975)/100"
label var nohigh_year "No HS degree x (Year-1975)/100"
label var topq_year "Top inc. quintile x (Year-1975)/100"


** Scaled Values for tables **
foreach i of varlist reducedif imppoor govrole hsick welfare luck_help both_eq hard_work tax_low tax_right tax_high helpblack luck{
sum `e(depvar)' if democrat==1 
local demo_mean=`r(mean)' 
sum `e(depvar)' if republican==1 
local rep__mean=`r(mean)'
sum `e(depvar)'  
local all_mean=`r(mean)' 
di `all_mean' 
di `demo_mean' - `rep__mean' 
}

** Saving "Mean, dept. var." outputs for tables **
capture program drop meandvar
program meandvar
sum `e(depvar)' if e(sample)==1 [aw `e(wexp)']
estadd scalar dvar= `r(mean)'
end 

** Saving "Scaled effect (party)" outputs for tables **
capture program drop scaled_effect
program scaled_effect
sum `e(depvar)' if e(sample)==1 & democrat==1 [aw `e(wexp)']
local d_mean= `r(mean)'
sum `e(depvar)' if e(sample)==1 & republican==1  [aw `e(wexp)']
local r_mean= `r(mean)'
matrix alt=e(b)
estadd scalar beta=alt[1,1]/(`d_mean'-`r_mean')
matrix drop alt
end

** Saving "Scaled effect (SD)" outputs for tables **
capture program drop scaled_effect_sd 
program scaled_effect_sd
sum `e(depvar)' if e(sample)==1 [aw `e(wexp)']
local sd=`r(sd)'
matrix alt=e(b)
estadd scalar betasd=alt[1,1]/`sd'
matrix drop alt
end



**************	TABLES with GSS	**************


*[ TABLE 1: Do income measures explain redistribution trends? ]*

*Cols 1 & 5*
foreach var of varlist reducedif {
eststo clear
foreach cat in old black{
eststo: reg `var' `cat'_year year_d* `cat' if year<=2006 [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect
estadd local Income "No" 
estadd local Educ "Yes"
estadd local Relative "No"
local base = _b[`cat'_year]
estadd scalar N2=e(N)
*Cols 2 & 6*
eststo: reg `var' `cat'_year year_d* `cat' realinc_hp_adj missob_inc if year<=2006 [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect
estadd local Income "Yes"
estadd local Educ "No"
estadd local Relative "No"
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)
*Cols 3 & 7* 
eststo: reg `var' `cat'_year year_d* `cat' degree_d* if year<=2006 [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect
estadd local Income "No"
estadd local Educ "No"
estadd local Relative "No"
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)
*Cols 4 & 8*
eststo: reg `var' `cat'_year year_d* `cat' class_d* opincome_d* if year<=2006 [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect
estadd local Income "No"
estadd local Edu "No"
estadd local Relative "No"
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)
}
esttab using ".../table1.csv" , replace fragment booktabs keep(old_year black_year) star(* .1 ** .05 *** .01) se brackets /*
*/ mgroups("Reduce inc. diffs (1-7)"  ,/* 
*/ pattern(1 0 0 0    0 0 0 0     ) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) /*
*/ nomtitles stats(dvar beta betasd Income Educ Relative share N2, label("Mean, dept. var." "Scaled effect (SD)" "Scaled effect (party)" "Income covar?" "Educ. covars?" "Relative covars?" "Share explained" "Observations")) label varwidth(22) wrap 
} 


*[ TABLE 2: Do broader measures of well-being explain redistribution trends? ]*

	
*Cols 1 & 7*
foreach var of varlist reducedif {
eststo clear
foreach cat in old black{
eststo: reg `var' `cat'_year year_d* `cat' if year<=2006 & happyi!=. [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local base = _b[`cat'_year]
estadd scalar N2=e(N)

*Cols 2 & 8*
eststo: reg `var' `cat'_year year_d* `cat' happyi if year<=2006 [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)

*Cols 3 & 9* 
eststo: reg `var' `cat'_year year_d* `cat' if year<=2006 & healthi!=. [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local base = _b[`cat'_year]
estadd scalar N2=e(N)

*Cols 4 & 10*
eststo: reg `var' `cat'_year year_d* `cat' healthi if year<=2006 [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)

*Cols 5 & 11*
eststo: reg `var' `cat'_year year_d* `cat' if year<=2006 & parsol!=. & kidssol=. [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local base = _b[`cat'_year]
estadd scalar N2=e(N)

*Cols 6 & 12*
eststo: reg `var' `cat'_year year_d* `cat' kidssol parsol if year<=2006 [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)
}
esttab using ".../table2.csv" , replace fragment booktabs keep(old_yr black_yr happyi healthi kidssol parsol) order(old_yr black_yr happyi healthi kidssol parsol) star(* .1 ** .05 *** .01) se brackets /*
*/ mgroups("Reduce inc. diffs (1-7)"  ,/* 
*/ pattern(1 0 0   0 0 0   0 0 0   0 0 0   ) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) /*
*/ nomtitles stats(dvar beta betasd share N2, label("Mean, dept. var." "Scaled effect (SD)" "Scaled effect (party)""Share explained" "Observations"))  label varwidth(22) wrap 
} 

 
 *********** 2.2 INCREASED CONSERVATISM AND COGNITIVE DISSONANCE ************


*[ TABLE 3: Does general conservatism explain redistribution trends?]*
	
*Cols 1 & 5*
foreach var of varlist reducedif {
eststo clear
foreach cat in old black{
eststo: reg `var' `cat'_year year_d* `cat' if year<=2006 & repsupport!=. & polviews!=. & attend!=. [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local base = _b[`cat'_year]
estadd scalar N2=e(N)

*Cols 2 & 6*
eststo: reg `var' `cat'_year year_d* `cat' repsupport if year<=2006 & repsupport!=. & polviews!=. & attend!=. [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)

*Cols 3 & 7* 
eststo: reg `var' `cat'_year year_d* `cat' polviews if year<=2006 & repsupport!=. & polviews!=. & attend!=.  [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local base = _b[`cat'_year]
estadd scalar N2=e(N)

*Cols 4 & 8*
eststo: reg `var' `cat'_year year_d* `cat' attend if year<=2006 & repsupport!=. & polviews!=. & attend!=.  [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)
}
esttab using ".../table3.csv" , replace fragment booktabs keep(old_year black_year repsupport polviews attend) order(old_year black_year repsupport polviews attend) star(* .1 ** .05 *** .01) se brackets /*
*/ mgroups("Reduce inc. diffs (1-7)"  ,/* 
*/ pattern(1 0 0 0   0 0 0 0   ) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) /*
*/ nomtitles stats(dvar beta betasd share N2, label("Mean, dept. var." "Scaled effect (SD)" "Scaled effect (party)""Share explained" "Observations"))  label varwidth(22) wrap 
} 



*[ TABLE 4: Do views on public health insurance explain redistributive trends?]*
	
*Cols 1 & 3*
foreach var of varlist reducedif {
eststo clear
foreach cat in old black{
eststo: reg `var' `cat'_year year_d* `cat' if year<=2006 & hsick!=. [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local base = _b[`cat'_year]
estadd scalar N2=e(N)

*Cols 2 & 4*
eststo: reg `var' `cat'_year year_d* `cat' hsick if year<=2006 & hsick!=. [w=wgt], cl(year)
meandvar
scaled_effect_sd
scaled_effect  
local pct=1-(_b[`cat'_year] / `base') 
estadd scalar share=`pct'
estadd scalar N2=e(N)
}

esttab using ".../table4.csv" , replace fragment booktabs keep(old_year black_year hsick) order(old_year black_year hsick) star(* .1 ** .05 *** .01) se brackets /*
*/ mgroups("Reduce inc. diffs (1-7)"  ,/* 
*/ pattern(1 0   0 0 ) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) /*
*/ nomtitles stats(dvar beta betasd share N2, label("Mean, dept. var." "Scaled effect (SD)" "Scaled effect (party)""Share explained" "Observations"))  label varwidth(22) wrap 
} 

*[ TABLE 5: Do views on income merit and aid to blacks explain redistributive trends?]*

label var domore_bl "Gov't sd spend more helping blacks" ;
label var mostly_luck "Success mostly luck" ;

eststo clear ;

foreach cat in black old { ;
foreach var of varlist mostly_luck special_treat { ;

	eststo: reg redistr `cat'_yr `cat'  yyy* if year<2008 & `var'<10 [aw=wgt], cl(year) ;
	scaled_effect ;
	scaled_effect_sd ;
	meanvar ;
	estadd local income "No" ;
	estadd local socio "No" ;
	estadd local relative "No" ;
	estadd local political "No" ;
	estadd local share "--" ;
	local base = _b[`cat'_yr] ;
	
********Now, include as a control ;

	eststo: reg redistr `cat'_yr `cat' `var'  yyy* if year<2008 & `var'<10 [aw=wgt], cl(year) ;
	scaled_effect ;
	scaled_effect_sd ;
	meanvar ;
	estadd local income "No" ;
	estadd local socio "No" ;
	estadd local relative "No" ;
	estadd local political "No" ;
	local pct=1-(_b[`cat'_yr] / `base') ;
	estadd local share=string(`pct') ;
} ;
} ;

esttab using ".../table5.csv", replace fragment booktabs keep(black_yr old_yr mostly_luck special_treat) 
order(black_yr old_yr mostly_luck special_treat ) 
star(* .1 ** .05 *** .01) se brackets 
mgroups("Reduce inc. diffs"  , 
pattern(1 0 0 0   0 0 0 0   ) prefix(\multicolumn{@span}{c}{) suffix(}) span erepeat(\cmidrule(lr){@span})) 
nomtitles  stats(dvar beta_sd beta_pol  share  N, label("Mean, dept. var." "Scaled effect (SD)" "Scaled effect (party)" 
 "Share explained" "Observations")) label varwidth(22) wrap  ;



