* British Social Attitudes Survey
* Subset and append multiple cross-sections


clear
*cd "/dir"

* 1983-91
* For 1985-1987, 1990  incdiff measured on 5 pt. scale; for 1991 variable is incdiff2.

use "2955.dta"

tab incdiff year
tab incdiff2 year
tab gvincdif year
tab govresp7 year

tab redistrb year
tab incomgap year
tab taxhi year
tab taxlow year
tab taxmid year
tab wealth year
tab ethnicgp year
tab year

labelbook incdiff
labelbook incdiff2
labelbook incomgap
labelbook redistrb
labelbook wealth
labelbook srinc

replace incdiff = incdiff2 if year == 1991
replace redistrb = redworkg if year == 1985
generate age = rage

keep year age ethnicgp incdiff incomgap redistrb wealth srinc wtfactor

save d1
clear

* 1993
use "bsa93.dta"

tab incdiff
labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb
labelbook redistrb

tab wealth
labelbook wealth

tab srinc
labelbook srinc
 
tab raceorig

replace year = 1993
generate age = rage

keep year age raceorig incdiff incomgap redistrb wealth srinc wtfactor

save d2
clear

* 1994
use "bsa94.dta"

* tab incdiff 		/* NA */
* labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc
labelbook srinc
 
tab raceorig

generate year = 1994
generate age = rage

keep year age raceorig incomgap redistrb srinc wtfactor

save d3
clear

* 1995
use "bsa95.dta"

* tab incdiff 		/* NA */
* labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc
labelbook srinc
 
tab raceorig

generate year = 1995
generate age = rage

keep year age raceorig incomgap redistrb srinc wtfactor

save d4
clear

* 1996
use "g921au.dta"

tab incdiff
labelbook incdiff

* tab incomgap		/* NA */
* labelbook incomgap

tab redistrb
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

* tab srinc			/* NA */
* labelbook srinc
 
tab raceori2

generate year = 1996
generate age = rage

keep year age raceori2 incdiff redistrb wtfactor

save d5
clear

* 1997
use "bsa97a.dta"

* tab incdiff			/* NA */
* labelbook incdiff

tab incomgap
labelbook incomgap

* tab redistrb		/* NA */
* labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

* tab srinc			/* NA */
* labelbook srinc
 
tab raceori2

generate year = 1997
generate age = rage

keep year age raceori2 incomgap wtfactor

save d6
clear

* 1998
use "bsa98a.dta"

* tab incdiff			/* NA */
* labelbook incdiff

tab govresp7
tab incomgap
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 1998
generate age = rage

keep year age raceori2 incomgap redistrb srinc wtfactor

save d7
clear

* 1999
use "bsa99a.dta"

tab incdiff			
labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 1999
generate age = rage

keep year age raceori2 incdiff incomgap redistrb srinc wtfactor

save d8
clear

* 2000
use "bsa00.dta"

tab incdiff			
labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 2000
generate age = rage

keep year age raceori2 incdiff incomgap redistrb srinc wtfactor

save d9
clear

* 2001
use "bsa01.dta"

* tab incdiff			/* NA */
* labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 2001
generate age = rage

keep year age raceori2 incomgap redistrb srinc wtfactor

save d10
clear

* 2002
use "bsa02.dta"

* tab incdiff			/* NA */
* labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 2002
generate age = rage

keep year age raceori2 incomgap redistrb srinc wtfactor

save d11
clear

* 2003
use "bsa03.dta"

* tab incdiff			/* NA */
* labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 2003
generate age = rage

keep year age raceori2 incomgap redistrb srinc wtfactor

save d12
clear

* 2004
use "bsa04.dta"

tab incdiff			
labelbook incdiff

tab incomgap
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 2004
generate age = rage

keep year age raceori2 incdiff incomgap redistrb srinc wtfactor

save d13
clear

* 2005
use "bsa05.dta"

* tab incdiff			/* NA */
* labelbook incdiff

* tab incomgap		/* NA */
* labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

* tab srinc			/* NA */
* labelbook srinc
 
tab raceori2

generate year = 2005
generate age = rage

keep year age raceori2 redistrb wtfactor

save d14
clear

* 2006
use "bsa06.dta"

tab govresp7
labelbook govresp7

generate incdiff = .
replace incdiff = 1 if govresp7 == 4
replace incdiff = 2 if govresp7 == 3
replace incdiff = 4 if govresp7 == 2
replace incdiff = 5 if govresp7 == 1
tab incdiff

tab incomgap		
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc

tab raceori2

generate year = 2006
generate age = rage

keep year age raceori2 incdiff incomgap redistrb srinc wtfactor

save d15
clear

* 2007
use "bsa07.dta"

* tab incdiff			/* NA */
* labelbook incdiff

tab incomgap		
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 2007
generate age = rage

keep year age raceori2 incomgap redistrb srinc wtfactor

save d16
clear

* 2008
use "bsa08.dta"

* tab incdiff			/* NA */
* labelbook incdiff

tab incomgap		
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 2008
generate age = rage

keep year age raceori2 incomgap redistrb srinc wtfactor

save d17
clear

* 2009

use "bsa09.dta"

tab incdiff			
labelbook incdiff

tab incomgap		
labelbook incomgap

tab redistrb		
labelbook redistrb

* tab wealth			/* NA */
* labelbook wealth

tab srinc			
labelbook srinc
 
tab raceori2

generate year = 2009
generate age = rage

keep year age raceori2 incdiff incomgap redistrb srinc wtfactor

save d18
clear

* 2010

use "bsa10.dta"

tab INCDIFF
labelbook INCDIFF
generate incdiff = INCDIFF

tab IncomGap
labelbook INCOMGAP		
generate incomgap = IncomGap

tab Redistrb		
labelbook REDISTRB
generate redistrb = Redistrb

* tab Wealth			/* NA */
* labelbook WEALTH

*tab srinc			/* NA */
*labelbook srinc
 
tab RaceOri3

generate year = 2010
generate age = RAge
generate wtfactor = WtFactor

keep year age RaceOri3 incdiff incomgap redistrb wtfactor

save d19
clear

* 2011

use "bsa11.dta"

tab Redistrb		
labelbook Redistrb
generate redistrb = Redistrb

tab RaceOri3

generate year = 2011
generate age = RAge
generate wtfactor = WtFactor

keep year age RaceOri3 redistrb wtfactor

save d20
clear

* 2012

use "bsa12.dta"

tab GovResp7
labelbook GovResp7

generate incdiff = .
replace incdiff = 1 if GovResp7 == 4
replace incdiff = 2 if GovResp7 == 3
replace incdiff = 4 if GovResp7 == 2
replace incdiff = 5 if GovResp7 == 1
tab incdiff

tab IncomGap		
labelbook IncomGap
generate incomgap = IncomGap

tab Redistrb		
labelbook Redistrb
generate redistrb = Redistrb

* tab wealth			/* NA */
* labelbook wealth

tab SRInc		
labelbook SRInc
generate srinc = SRInc

tab RaceOri3

generate year = 2012
generate age = RAge
generate wtfactor = WtFactor

keep year age RaceOri3 incdiff incomgap redistrb srinc wtfactor

save d21
clear

* 2013

use "bsa13ukds.dta"

tab IncomGap		
labelbook IncomGap
generate incomgap = IncomGap

tab Redistrb		
labelbook Redistrb
generate redistrb = Redistrb

* tab wealth			/* NA */
* labelbook wealth

tab SRInc		
labelbook SRInc
generate srinc = SRInc

tab RaceOri3

generate year = 2013
generate age = RAge
generate wtfactor = WtFactor

keep year age RaceOri3 incomgap redistrb srinc wtfactor

save d22
clear

* Apend datasets

use d1, clear
append using d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 ///
d19 d20 d21 d22
drop wealth

labelbook incdiff
replace incdiff = 6 - incdiff if year != 2006 & year != 2012
label define incdiffl 1 "Disagree Strongly" 2 "Disagree" 3 "Neither" 4 "Agree" ///
5 "Agree Strongly"
label values incdiff incdiffl

replace incdiff = . if incdiff < 1 | incdiff > 5
tab incdiff

labelbook incomgap
replace incomgap = 4 - incomgap
label define incomgapl 1 "Too Small" 2 "About right" 3 "Too Large"
label values incomgap incomgapl

replace incomgap = . if incomgap < 1 | incomgap > 3
tab incomgap

labelbook redistrb
replace redistrb = 6 - redistrb 
label define redistrbl 1 "Disagree Strongly" 2 "Disagree" 3 "Neither" 4 "Agree" ///
5 "Agree Strongly"
label values redistrb redistrbl

replace redistrb = . if redistrb < 1 | redistrb > 5
tab redistrb

labelbook srinc
replace srinc = 4 - srinc
label define srincl 1 "Low income" 2 "Middle income" 3 "High income"
label values srinc srincl

replace srinc = . if srinc < 1 | srinc > 3
tab srinc

generate agegroup = .
replace agegroup = 1 if (age >= 18) & (age <= 29)
replace agegroup = 2 if (age >= 30) & (age <= 39)
replace agegroup = 3 if (age >= 40) & (age <= 49)
replace agegroup = 4 if (age >= 50) & (age <= 64)
replace agegroup = 5 if (age >= 65) & (age < 99)

label define agegroupl 1 "18-29" 2 "30-39" 3 "40-49" 4 "50-64" 5 "65 and older"
label values agegroup agegroupl
tab agegroup

generate age65 = .
replace age65 = 0 if age >= 18 & age < 65
replace age65 = 1 if age >= 65 & age < 99

generate age40 = .
replace age40 = 0 if age >= 18 & age < 40
replace age40 = 1 if age >= 40 & age < 99

tab ethnicgp year
tab raceorig year
tab raceori2 year
tab RaceOri3 year

labelbook ethnicgp
labelbook raceorig
labelbook raceori2
labelbook RACEORI3

generate white = .
replace white = 1 if ethnicgp == 1 | raceorig == 7 | raceorig == 9 | ///
raceori2 == 9 | raceori2 == 10 | RaceOri3 == 9

replace white = 0 if white == .

replace white = . if ethnicgp == 9 | raceorig == 97 | raceorig == 99 | ///
raceori2 == 98 | raceori2 == 99 |  RaceOri3 == 98 | RaceOri3 == 99 | ///
year == 1990 | year == 1991

drop ethnicgp raceorig raceori2 RaceOri3

save bsa_4vars_allyrs.dta, replace
