

*German GSS (Allbus)

***************************
*Create Germany Graphs    *
***************************

clear all
set more off

use ".../allbus_allyrs.dta"

*replace missing vals by "." for age*
replace age=. if age==997 | age==999
*Generate two categories of age*
gen age_65=age>=65 if age!=. 
gen age_18_64=age>=18 & age<65 if age!=.


*Label categories of age*
label var age_65 "Ages 65 and older"
label var age_18_64 "Ages 18?64" 


*Create "secinc" "decinc" "motiv" mean per year for age 65 and older and the rest*
foreach i of varlist secinc decinc motiv{
egen `i'_65=wtmean(`i') if age_65==1, by(year) weight(wtfactor)
egen `i'_18_64=wtmean(`i') if age_18_64==1, by(year) weight(wtfactor)
}

*[ Graph: Appendix Figure 2: Agreement that state should ensure decent income, elderly versus others, German General Social Survey (ALLBUS) ]*
graph twoway  (scatter secinc_18_64 year, m(Sh) mlw(medium) msize(medium) mlc(blue) ) (scatter secinc_65 year,   m(Oh) mlw(medium) msize(medium) mlc(green) )  (lfit secinc_65 year if year<2005, lc(green)) (lfit secinc_65 year, lc(green)) (lfit secinc_18_64 year if year<2005, lc(blue)) (lfit secinc_18_64 year, lc(blue))  if year>=1983, scheme(aspen) legend(on) xlabel(1983(5)2010) ylabel(,nogrid) legend(off) xtitle("")  graphregion(color(white)) legend(on) legend(label(1 "Under age 65") label(2 "Age 65 and older") order(1 2))  
graph export .../fig_a2.eps, replace




