
***************************
*Create All Country Graph *
***************************

*UK*
clear all
set more off

use ".../bsa_4vars_allyrs.dta"


*replace missing vals by "." for age*
replace age=. if age==99 | age==17 
*Generate two categories of age*
gen old=age>=65 if age~=. 
gen young=age>=18 & age<65 if age!=. 

*Drop observations of "incdiff"  for years 2006 & 2012 because they don't include middle category *
drop if year==2006 & year==2012 

sort year

*Rename dep variable*
rename incdiff depUK

*Generate standarized dep variable*
sum depUK [aw=wtfactor] 
gen depUK_st = (depUK - `r(mean)')/`r(sd)'

*Generate interaction for graph*
gen oldyear=old*year

keep year age old young depUK wtfactor depUK_st oldyear
save ".../bsa2.dta", replace


*Germany*
clear all
set more off

use ".../allbus_allyrs.dta"

*replace missing vals by "." for age*
replace age=. if age==997 | age==999
*Generate two categories of age*
gen old=age>=65 if age!=. 
gen young=age>=18 & age<65 if age!=.
sort year

*Rename dep variable*
rename secinc depGER

*Generate standarized dep variable*
sum depGER [aw=wtfactor] 
gen depGER_st = (depGER - `r(mean)')/`r(sd)'

*Generate interaction for graph*
gen oldyear=old*year

keep year age old young depGER wtfactor depGER_st oldyear
save .../all2.dta, replace


*Sweden*
clear all
set more off 

use ".../snes_allyrs.dta"
rename weight wtfactor
rename age60 old
sort year

*Rename dep variable*
rename incdiff depSWE

*Generate standarized dep variable*
sum depSWE [aw=wtfactor] 
gen depSWE_st = (depSWE - `r(mean)')/`r(sd)'

*Generate interaction for graph*
gen oldyear=old*year

keep year old wtfactor depSWE depSWE_st oldyear
save .../snes2.dta, replace


*US(ANES)*
clear all
set more off 

use ".../anes_cdf.dta"

*Generate weight variable*
rename VCF0009a wtfactor

*Generate age variable*
gen age=VCF0101 if VCF0101!=0 & VCF0101!=.
*Generate age groups variables*
gen old=age>64 if age!=.
gen young=age<65 if age!=.
*Generate variable year*
rename VCF0004 year

*Generate variable of interest Gov should guaranteed jobs and income scale* 
gen govjobinc_temp=VCF0809 if VCF0809!=. & VCF0809!=0 & VCF0809!=9
*Fliping variable govjobinc, increasing for redistribution*
gen govjobinc=8-govjobinc_temp
drop govjobinc_temp

*Rename dep variable*
rename govjobinc depANES

*Generate standarized dep variable*
sum depANES [aw=wtfactor] 
gen depANES_st = (depANES - `r(mean)')/`r(sd)'

*Generate interaction for graph*
gen oldyear=old*year

sort year
keep wtfactor year depANES age old young depANES_st oldyear
save .../anes2.dta, replace


*US(GSS)*
clear all
set more off 

use ".../GSS7212_R2.DTA"
*Drop those who would not have been included in previous interviews BC, only speaks spanish*
drop if spanint==2 
*Generate weights (oversamp*wtssall)*
gen wgt=wtssall*oversamp 
rename wgt wtfactor
*Capturing missed observations as "." for programming*
foreach i of varlist age eqwlth {
replace `i'=. if `i'==.i | `i'==.d | `i'==.n
}
**Question 1 on redistribution: "Gov should reduce diferences" Flipping variable, increasing in support for redistribution**
gen reducedif = 8-eqwlth
*Generate AGE dummies*
gen young=age<=64 if age!=.
gen old=age>=65 if age!=.

*Rename dep variable*
rename reducedif depGSS

*Generate standarized dep variable*
sum depGSS [aw=wtfactor] 
gen depGSS_st = (depGSS - `r(mean)')/`r(sd)'

*Generate interaction for graph*
gen oldyear=old*year

sort year
keep young old age depGSS wtfactor year depGSS_st oldyear
save .../gss2.dta, replace
 

************************** Appending data sets **************************************



* Append datasets for Figure 5: Relative elderly trend on redistributive issues, by country"* 

use ".../bsa2.dta", clear

append using ".../all2.dta" ".../snes2.dta" ".../anes2.dta" ".../gss2.dta"
save .../all_countries.dta, replace


*Use all the data for graph*
clear all
set more off
use13 ".../all_countries.dta"

* Generate year dummies*
xi i.year, noomit


* Generating data for graphs*

*UK*
reg depUK_st oldyear old i.year if year>1984 & year<2005 [aw=wtfactor], cl(year)
*Saving intercept to calculate the diff between old and young, considering changes in time and age*
local UKintertept = _b[old]
*Saving slope to calculate the diff between old and young, considering changes in time and age*
local UKslope = _b[oldyear]
*Saving beta and standard error to report in graph*
local beta1=round(_b[oldyear], .0001) 
local se1=round(_se[oldyear], .0001) 
*Calculate the diff between old and young, considering changes in time and age*
gen diff_oldyoung = `UKintertept' + `UKslope'*year if year>1984 & year<2005 & depUK!=. 

*GERMANY*
reg depGER_st oldyear old i.year if year>1983 & year<2005 [aw=wtfactor], cl(year)
*Saving intercept to calculate the diff between old and young, considering changes in time and age*
local GERintertept = _b[old]
*Saving slope to calculate the diff between old and young, considering changes in time and age*
local GERslope = _b[oldyear]
*Saving beta and standard error to report in graph*
local beta2=round(_b[oldyear], .0001) 
local se2=round(_se[oldyear], .0001) 
*Calculate the diff between old and young, considering changes in time and age*
replace diff_oldyoung = `GERintertept' + `GERslope'*year if year>1983 & year<2005 & depGER!=. 

*Sweden*
reg depSWE_st oldyear old i.year if year>1987 & year<2007 [aw=wtfactor], cl(year)
*Saving intercept to calculate the diff between old and young, considering changes in time and age*
local SWEintertept = _b[old]
*Saving slope to calculate the diff between old and young, considering changes in time and age*
local SWEslope = _b[oldyear]
*Saving beta and standard error to report in graph*
local beta3=round(_b[oldyear], .0001) 
local se3=round(_se[oldyear], .0001) 
*Calculate the diff between old and young, considering changes in time and age*
replace diff_oldyoung = `SWEintertept' + `SWEslope'*year if year>1987 & year<2007 & depSWE!=.

*ANES*
reg depANES_st oldyear old i.year if year>1971 & year<2009 [aw=wtfactor], cl(year)
*Saving intercept to calculate the diff between old and young, considering changes in time and age*
local ANESintertept = _b[old]
*Saving slope to calculate the diff between old and young, considering changes in time and age*
local ANESslope = _b[oldyear]
*Saving beta and standard error to report in graph*
local beta4=round(_b[oldyear], .0001) 
local se4=round(_se[oldyear], .0001) 
*Calculate the diff between old and young, considering changes in time and age*
replace diff_oldyoung = `ANESintertept' + `ANESslope'*year if year>1971 & year<2009 & depANES!=.

*GSS*
reg depGSS_st oldyear old i.year if year>1977 & year<2007 [aw=wtfactor], cl(year)
*Saving intercept to calculate the diff between old and young, considering changes in time and age*
local GSSintertept = _b[old]
*Saving slope to calculate the diff between old and young, considering changes in time and age*
local GSSslope = _b[oldyear]
*Saving beta and standard error to report in graph*
local beta5=round(_b[oldyear], .0001) 
local se5=round(_se[oldyear], .0001) 
*Calculate the diff between old and young, considering changes in time and age*
replace diff_oldyoung = `GSSintertept' + `GSSslope'*year if year>1977 & year<2007 & depGSS!=.

*Generate graph*


#delimit ;

twoway (lfit diff_oldyoung year if depUK!=.) (lfit diff_oldyoung year if depGER!=.) (lfit diff_oldyoung year if depSWE!=.) 
(lfit diff_oldyoung year if depANES!=.) (lfit diff_oldyoung year if depGSS!=.), scheme(aspen) legend(on)
legend(label (1 "UK") label(2 "Germany") label(3 "Sweden") label(4 "US(ANES)") label(5 "US(GSS)")) xlabel(1975(5)2005) 
xtitle("Year of Interview") ytitle("Elderly vs. Non-eld. diffs. (standardized units)") 
text(0.1 1988 "{&beta}=`beta1' [`se1']", size(*1.0)) text(0.18 2000 "{&beta}=`beta2' [`se2']", size(*1.0)) text(0.03 2000 "{&beta}=`beta3' [`se3']", size(*1.0)) text(-0.01 1975 "{&beta}=`beta4' [`se4']", size(*1.0)) text(-0.08 2003 "{&beta}=`beta5' [`se5']", size(*1.0)) ;
graph export .../fig5.eps, replace ;













