/*BEGINCCC
This program combines the yearly files from the 01 program
with the concatenated quarterly files from the 02 program
into a single file.

CCCEND*/


%include "config.sas"  / source2;

option ls=80;
options macrogen symbolgen mprint mlogic;

%macro state_year;


  
%do year=&bls_start_year %to &bls_end_year;

proc append base=bls_us_state data=QCEW.bls_us_state_&year.;
run;

%end; /*year*/

/* apply all recodings */

data bls_us_state;
   set bls_us_state;
   length  all_sic $4 sic $4 
           sic3 $3 sic2 $2 sic_division $1 
	   all_naics $6 
	   NAICS2 $2 NAICS_SECTOR $2 NAICS3 $3 NAICS4 $4
	   naicssec_mod naicssec $ 5;
   drop industry_code;
/*BEGINCCC
Initialize the SIC variables at missing,
final data in bls_us_county are SIC based before 2000 (included) and NAICS based in 2001 and beyond
CCCEND*/

 sic='';
 sic3='';
 sic2='';
 sic_division='';
 all_sic = '';
     
      all_naics = industry_code;
      NAICS2 = substr(industry_code,1,2);
      NAICS3 = substr(industry_code,1,3);
      NAICS4 = substr(industry_code,1,4);
                  
      *NAICS_SECTOR = put(NAICS2,$naisect.);

      **************************************************;
      *** substitute for use of non-standard sas format ;
      **************************************************;
/*
  Z - All Industries
  A - Agriculture, Forestry,Fishing and Hunting
  B - Mining
  C - Utilities
  D - Construction
  E - Manufacturing
  F - Wholesale Trade
  G - Retail Trade
  H - Transportation and Warehousing
  I - Information
  J - Finance and Insurance
  K - Real Estate and Rental and Leasing
  L - Professional, Scientific, and Technical Services
  M - Management of Companies and Enterprises
  N - Administrative and Support and Waste Management and Remediation Services
  O - Eduational Services
  P - Health Care and Social Assistance
  Q - Arts, Entertainment, and Recreation
  R - Accommodation and Food Services
  S - Other Services (except Public Administraton)
  T - Public Administration
  Y - Non Classifiable  
 

*/


select(NAICS2);
           when ('10') naics_sector =     "Z";  
	   when ('11') naics_sector =     "A";
	   when ('21') naics_sector =     "B";
	   when ('22') naics_sector =     "C";
	   when ('23') naics_sector =     "D";
	   when ('31') naics_sector =     "E";
	   when ('32') naics_sector =     "E";
	   when ('33') naics_sector =     "E";
	   when ('42') naics_sector =     "F";

	   when ('44') naics_sector =     "G";
	   when ('45') naics_sector =     "G";
	   when ('48') naics_sector =     "H";
	   when ('49')  naics_sector =     "H";

	   when ('51') naics_sector =     "I";
	   when ('52') naics_sector =     "J";
	   when ('53') naics_sector =     "K";
	   when ('54') naics_sector =     "L";
	   when ('55') naics_sector =     "M";
	   when ('56') naics_sector =     "N";
	   when ('61') naics_sector =     "O";
	   when ('62') naics_sector =     "P";
	   when ('71') naics_sector =     "Q";
	   when ('72') naics_sector =     "R";
	   when ('81') naics_sector =     "S";
	   when ('92') naics_sector =     "T";
	   when ('99') naics_sector =     "Y";
otherwise;
end;
if NAICS_SECTOR eq "Z"  then NAICS_SECTOR=" ";
      else if NAICS_SECTOR eq "Y" then NAICS_SECTOR ="Z";
 
/* this to fit with QWI/NAICS standard */

if naics2= industry_code then naicssec = naics2;
if naicssec='10' then naicssec='00' ;
if industry_code in ('31-33') then naicssec='31-33';
if industry_code in ('44-45') then naicssec='44-45';
if industry_code in ('48-49') then naicssec='48-49';


/* this to fit with BED */
/* note that some of the 10xx codes overlap with
   two-digit NAICS sectors. */

select(industry_code);
           when ('1010') naicssec_mod =     "00";  
           when ('10') naicssec_mod =     "00";  

	   when ('1011') naicssec_mod =     "11-21";
	   when ('11') naicssec_mod =     "11-21";
	   when ('21') naicssec_mod =     "11-21";

	   when ('1012') naicssec_mod =     "23";
	   when ('23') naicssec_mod =     "23";

	   when ('1013') naicssec_mod =     "31-33";
	   when ('31-33') naicssec_mod =     "31-33";

/*	   when ('1021') naicssec_mod =     "42-49,22" ; */ 
	   when ('42')   naicssec_mod =     "42";
	   when ('44-45') naicssec_mod =     "44-45";
	   when ('48-49') naicssec_mod =     "48-49";
	   when ('22')    naicssec_mod =     "22";

	   when ('1022')  naicssec_mod =     "51";
	   when ('51')  naicssec_mod =     "51";

	   when ('1023')  naicssec_mod =     "52-53";
	   when ('52')  naicssec_mod =     "52-53";
	   when ('53')  naicssec_mod =     "52-53";

	   when ('1024')  naicssec_mod =     "54-56";
	   when ('54')  naicssec_mod =     "54-56";
	   when ('55')  naicssec_mod =     "54-56";
	   when ('56')  naicssec_mod =     "54-56";

	   when ('1025')  naicssec_mod =     "61-62";
	   when ('61')  naicssec_mod =     "61-62";
	   when ('62')  naicssec_mod =     "61-62";

	   when ('1026')  naicssec_mod =     "71-72";
	   when ('71')  naicssec_mod =     "71-72";
	   when ('72')  naicssec_mod =     "71-72";

	   when ('1027')  naicssec_mod =     "81";
	   when ('81')  naicssec_mod =     "81";

	   when ('1028')  naicssec_mod =     "92";
	   when ('92')  naicssec_mod =     "92";

	   when ('1029')  naicssec_mod =     "99";
	   when ('99')  naicssec_mod =     "99";

otherwise naicssec_mod='';
end; /* select statement */
 label  sic_division       = "SIC Major division  Code           ";
 label  all_sic            = "SIC Code                           ";
 label  sic                = "SIC 4-digit Code                   ";
 label  sic3               = "SIC 3-digit Code                   ";
 label  sic2               = "SIC 2-digit Code                   ";
 label  all_naics          = "NAICS Code                         ";
 label  aggregation_level  = "Level of aggregation               ";
 label  NAICS2             = "Industry Sector                    ";
 label  NAICS3             = "Industry Sub-Sector                ";
 label  NAICS4             = "Industry Group                     ";      
 
run;

/*BEGINCCC
Sort the data.
CCCEND*/

proc sort data= bls_us_state out=OUTPUTS.bls_us_state;
    by year quarter state size aggregation_level ownership_code ;
run;





%mend;

%state_year;

proc contents data=OUTPUTS.bls_us_state;
run;

proc freq data=OUTPUTS.bls_us_state;
table year state county aggregation_level all_naics naicssec naicssec_mod
      quarter datatype ownership_code;
table aggregation_level * state * naicssec;
table datatype * aggregation_level;
;
run;

/* do some aggregation for agg=54 */
/* we need some variables */

%let vars=n emp_month1 emp_month3 total_wage tx_total_wage;

data OUTPUTS.bls_us_state_naicssec_pri
     (label="Agg=54+51 size=0 owner=5 state*yr*qtr*naicssec");
     set OUTPUTS.bls_us_state
     (where=(aggregation_level in ('54','51') and size='0' and ownership_code='5'));
     keep state year quarter all_naics naicssec naicssec_mod
	  aggregation_level ownership_code status_disclosure 
	  &vars.;
     rename ownership_code =owner;
run;

proc freq data=OUTPUTS.bls_us_state_naicssec_pri;
title "OUTPUTS state NAICS sectors private only";
table naicssec_mod naicssec all_naics /missing;
run;

proc print data=OUTPUTS.bls_us_state_naicssec_pri(obs=50);
run;

/* checking for unique sort key */
proc sort data=OUTPUTS.bls_us_state_naicssec_pri nodupkey;
by state year quarter all_naics;
run;

proc univariate data=OUTPUTS.bls_us_state_naicssec_pri
     (where=(naicssec_mod ne'')) noprint;
by state year quarter naicssec_mod;
var &vars.;
output out=OUTPUTS.bls_us_state_naicssec_mod_pri
           (label="Agg=54+51 size=0 owner=5 state*yr*qtr*naicssec_mod like BED")
        sum=&vars.;
run;

proc print data=OUTPUTS.bls_us_state_naicssec_mod_pri(obs=50);
title "OUTPUTS state NAICS collapsed sectors private only";
run;


     
