/*BEGINCCC
$Id$
$URL$

This program reads in  
the last year's quarterly files.

This program, instead of downloading the individual files from the BLS website,
refers to an archive location where the ENB ZIP files (whole-year-archive) have been 
downloaded. This is due to a change to the BLS FTP server. ENB archives need to be downloaded
separately, prior to running this program.

CCCEND*/


%include "config.sas"  / source2;

/*========================================================================*/
/*  Original Date: <02/11/04 14:00:50 bjell001>                           */
/*  Time-stamp: <03/06/19 15:18:16 bjell001>                              */
/*  Author:  Melissa Bjelland                                             */
/*  Title:  01_bls.sas                                                    */
/*  Location:  .../QA_sequence/qa_files/es202/County                      */
/*                                                                        */
/*  DESCRIPTION:                                                          */
/*  Reads in and stacks the most recent annual state data from           */
/*  zipped files obtained from the BLS (CEW).                             */
/*                                                                        */
/*  PROVIDES-DATA:  bls_us_state_&yr.sas7bdat                            */
/*========================================================================*/


option ls=80;
options macrogen symbolgen mprint mlogic;


%let workpath=%sysfunc(pathname(work));

/***********************************************************************************************/

/*BEGINCCC
The following macro state_year reads in the BLS website the county data for years which need to be updated,   
except the most recent year whose data are read in the next program 
(so this program handles years from end_year to end_year_new-1)         
CCCEND*/


/*BEGINCCC
The macro state_year reads in the BLS data for all   
states, Puerto Rico, and the Virgin Islands.         
CCCEND*/

%macro state_year;



/*BEGINCCC
Only process the most recent year).
CCCEND*/

%let year=&bls_end_year.;


/*BEGINCCC
The files are zip files, they are first downloaded from the bls ftp site to the ARCHIVE location, 
and then unzipped through the filename below. Because of the archival format, all states are in the same
file, and are extracted prior to creating the read-in loop by state.
These files give NAICS based data.

The files within each zip file have the special .ENB extension 
CCCEND*/

%let yr=%substr(&year,3,2);

%let zipfile=curr_yr_all_enb.zip;
%let enbfile=allsta%substr(&year,3,2).enb;
filename cewzip pipe "unzip -pC &archive./&zipfile. state/&enbfile.";


data QCEW.bls_us_state_&year
     (drop=employ_: total_wage_q: tx_total_wage_q: n_q:)
     ;
   
    length state $2  year 4 quarter 3 datatype $1
	    emp_month1 emp_month3 8 total_wage 8 
           aggregation_level $2 ownership_code $1
           status_disclosure $ 1 ;

 
  infile cewzip lrecl=449;

input 
        state                $ 4-5 
        county		     $ 6-8
	datatype             $ 9-9
	size                 $ 10-10
        ownership_code       $ 11-11 
        industry_code        $ 12-17 
        year                   18-21 
        aggregation_level    $ 22-23 
        status_disclosure    $ 24-24 
        n_q1                   25-32
        employ_jan             33-41
        employ_mar             51-59
        total_wage_q1          60-74
	tx_total_wage_q1       75-89

        n_q2                   112-119
        employ_apr             120-128
        employ_jun             138-146
        total_wage_q2          147-161
	tx_total_wage_q2       162-176

        n_q3                   199-206
        employ_jul             207-215
        employ_sep             225-233 
        total_wage_q3          234-248
	tx_total_wage_q3       249-263

        n_q4                   286-293
        employ_oct             294-302
        employ_dec             312-320
        total_wage_q4          321-335
	tx_total_wage_q4       336-350
	;

/*BEGINCCC
Label the variables- even those not retained in the data set- for purposes
of documentation.
CCCEND*/

 label  state              = "State FIPS Code                    ";
 label  county             = "County FIPS Code                   ";
 label  size               = "Size Code                          ";
 label  ownership_code     = "Ownership Code                     ";
 label  industry_code      = "Industry Code                      ";
 label  quarter            = "Quarter                            ";
 label  year               = "Year                               ";
 label  aggregation_level  = "Aggregation Level                  ";
 label  employ_jan         = "January Employment                 ";
 label  employ_mar         = "March Employment                 ";
 label  total_wage_q1      = "Total Quarterly Wages              ";
 label  tx_total_wage_q1      = "Taxable Total Quarterly Wages   ";
 label  employ_apr         = "April Employment                   ";
 label  employ_jun         = "June Employment                   ";
 label  total_wage_q2      = "Total Quarterly Wages              ";
 label  tx_total_wage_q2   = "Taxable Total Quarterly Wages      ";
 label  employ_jul         = "July Employment                    ";
 label  employ_sep         = "Sept Employment                    ";
 label  total_wage_q3      = "Total Quarterly Wages              ";
 label  tx_total_wage_q3   = "Taxable Total Quarterly Wages      ";
 label  employ_oct         = "October Employment                 ";
 label  employ_dec         = "December Employment                ";
 label  total_wage_q4      = "Total Quarterly Wages              ";
 label  tx_total_wage_q4   = "Taxable Total Quarterly Wages      ";
 label  emp_month1         = "Employment, Month 1                ";
 label  emp_month3         = "Employment, Month 3                ";
 label  total_wage         = "Total Quarterly Wages              ";
 label  tx_total_wage      = "Taxable Total Quarterly Wages      ";
 label  n_q1               = "Quarterly Number of Establishments";
 label  n_q2               = "Quarterly Number of Establishments";
 label  n_q3               = "Quarterly Number of Establishments";
 label  n_q4               = "Quarterly Number of Establishments";
 label  n               = "Quarterly Number of Establishments";
  
 label  status_disclosure  = "Status/Disclosure Code"; 

/*BEGINCCC
Only retain observations for  ownership
codes 0 and 5. Only all industry aggregates are available in the 2001 
data and beyond for our purposes.  In the future, a SIC-NAICS 
crosswalk may be implemented, but in the meantime, we only strip
off the aggregation level for all industries.
CCCEND*/

* if  ownership_code in ("0","1", "5");

/*BEGINCCC
Now, select out month 1 employment and total wage for each quarter.
CCCEND*/
 if year=&year.;
 %do q=1 %to 4;
     quarter=&q;
     if quarter=1 then do;
         n=n_q1;
	 emp_month1=employ_jan;
	 emp_month3=employ_mar;
	 total_wage=total_wage_q1;
	 tx_total_wage=tx_total_wage_q1;
	 output;
     end;
     else if quarter=2 then do;
         n=n_q2;
         emp_month1=employ_apr;
         emp_month3=employ_jun;
	 total_wage=total_wage_q2;
	 tx_total_wage=tx_total_wage_q2;
	 output;
     end;
     else if quarter=3 then do;
         n=n_q3;
         emp_month1=employ_jul;
         emp_month3=employ_sep;
	 total_wage=total_wage_q3;
	 tx_total_wage=tx_total_wage_q3;
	 output;
     end;
     else if quarter=4 then do;
         n=n_q4;
         emp_month1=employ_oct;
         emp_month3=employ_dec;
	 total_wage=total_wage_q4;
	 tx_total_wage=tx_total_wage_q4;
	 output;
     end;
 %end;
 
run;

proc sort data=QCEW.bls_us_state_&year.;
    by year quarter state county aggregation_level ownership_code;
run;


proc freq data=QCEW.bls_us_state_&year.;
table year quarter county aggregation_level ownership_code;
run;

proc means data=QCEW.bls_us_state_&year.;
run;


%mend;

%state_year;

