# delimit ;
capture log close;
log using d:\statprog\dropout\inphsb1.log, replace;

clear;
infix hsid 1-4 studentid 5-6 bypart 8 sex 30 raceeth 31 mtreduc 475-476 
     comphs 3232 livwftr 454 livwmtr 456 FU2WT 4293-4300
	 using d:\data\nces\hsb\hsb_soph_f2.dat;

* drop students who didn't participate in the base year survey;

drop if bypart == 0;

rename FU2WT weight;
gen female = sex == 2;
gen whitenh = raceeth == 5;
gen hispanic = raceeth == 1;
gen blacknh = raceeth == 4;
gen othernh = whitenh == 0 & blacknh == 0 & hispanic == 0;

replace livwftr = . if livwftr > 1;
replace livwmtr = . if livwmtr > 1;
gen bothpar = livwmtr == 1 & livwftr == 1;

replace mtreduc = . if mtreduc == 1 | mtreduc >= 11;
gen mtrhsdrop = mtreduc == 2;
     replace mtrhsdrop = . if mtreduc == .;
gen mtrhsgrad = mtreduc == 3;
     replace mtrhsgrad = . if mtreduc == .;
gen mtranycol = mtreduc >= 4 & mtreduc <= 10;

gen nodegreeby20 = comphs == 2 | comphs == 3;
     replace nodegreeby20 = . if comphs > 5;
gen gedby20 = comphs == 4;
     replace gedby20 = . if comphs > 5;
gen diplomaby20 = comphs == 1;
     replace diplomaby20 = . if comphs > 5;
	 
gen  educoutby20 = "hsdrop" if nodegreeby20 == 1;
     replace educoutby20 = "ged" if gedby20 == 1;
	 replace educoutby20 = "hsgrad" if diplomaby20 == 1;


sort hsid;
save d:\data\nces\hsb\dropout\temp1.dta, replace;

use d:\data\nces\hsb\HS_stateid_grogger.dta;
rename hsstate stfips;
sort hsid;

merge hsid using d:\data\nces\hsb\dropout\temp1.dta;
tab _merge;
drop if _merge ~= 3;
drop _merge;

sort stfips;
save d:\data\nces\hsb\dropout\temp1.dta, replace;

clear;
use d:\data\nces\nels\convstate.dta;
rename statefips stfips;
keep stfips stname;
sort stfips;
merge stfips using d:\data\nces\hsb\dropout\temp1.dta;
tab _merge;
drop if _merge == 1;
drop _merge;

save d:\data\nces\hsb\dropout\hsball.dta, replace;
erase d:\data\nces\hsb\dropout\temp1.dta;

log close;
