# delimit ;
capture log close;
log using d:\statprog\dropout\reghorserace.log, replace;

/* 
****************

REGHORSERACE

****************

This program estimates horserace models comparing the impact of inequality 
to that of other economic variables in attempting to explain dropout status;
*/

set more 1;
clear;
use d:\data\nces\alldata.dta;
sort stfips;
merge m:1 stfips using d:\data\nces\stfixedvars.dta;
drop rathsgraddrop ratcolhsgrad;
tab _merge;
drop _merge;
sort stfips;
merge m:1 stfips using d:\data\nces\wagestats.dta;
tab _merge;
drop _merge;

keep if female == 0;
drop if nodegreeby20 == . | gedby20 == . | diplomaby20 == .;

gen pctminority = 1 - pctwhitenh;
replace expperst = expperst/1000;

replace p50 = p50/1000;
replace p10 = p10/1000;
gen mtrdrop5010 = mtrhsdrop*rat5010;
gen mtrgrad5010 = mtrhsgrad*rat5010;
gen mtrdrop9050 = mtrhsdrop*rat9050;
gen mtrgrad9050 = mtrhsgrad*rat9050;
gen mtrdropp10 = mtrhsdrop*p10;
gen mtrgradp10 = mtrhsgrad*p10;
gen mtrdropp50 = mtrhsdrop*p50;
gen mtrgradp50 = mtrhsgrad*p50;
gen mtrdroprhsd = mtrhsdrop*rathsgraddrop;
gen mtrgradrhsd = mtrhsgrad*rathsgraddrop;
gen mtrdroprcolhs = mtrhsdrop*ratcolhsgrad;
gen mtrgradrcolhs = mtrhsgrad*ratcolhsgrad;
gen mtrdroprseg = mtrhsdrop*racesegindex;
gen mtrgradrseg = mtrhsgrad*racesegindex;
gen mtrdropincrate = mtrhsdrop*incarcrate;
gen mtrgradincrate = mtrhsgrad*incarcrate;
gen mtrdroppov = mtrhsdrop*povrate;
gen mtrgradpov = mtrhsgrad*povrate;
gen mtrdroppctmin = mtrhsdrop*pctminority;
gen mtrgradpctmin = mtrhsgrad*pctminority;
gen mtrdropexpst = mtrhsdrop*expperst;
gen mtrgradexpst = mtrhsgrad*expperst;
gen mtrdropptr = mtrhsdrop*pupteachrat;
gen mtrgradptr = mtrhsgrad*pupteachrat;
gen mtrdropincseg = mtrhsdrop*incseg;
gen mtrgradincseg = mtrhsgrad*incseg;
gen mtrdroppovseg = mtrhsdrop*segpovind;
gen mtrgradpovseg = mtrhsgrad*segpovind;
gen mtrdropmanuf = mtrhsdrop*fracmanuf;
gen mtrgradmanuf = mtrhsgrad*fracmanuf;
gen mtrdropsingpar = mtrhsdrop*fracsingpar;
gen mtrgradsingpar = mtrhsgrad*fracsingpar;
gen mtrdrop1pct = mtrhsdrop*incshare1pct;
gen mtrgrad1pct = mtrhsgrad*incshare1pct;
gen mtrdropmidcls = mtrhsdrop*fracmidcls;
gen mtrgradmidcls = mtrhsgrad*fracmidcls;
gen mtrdropscap = mtrhsdrop*soccapind;
gen mtrgradscap = mtrhsgrad*soccapind;
 

gen nels = source == "nels";
gen els = source == "els";
gen nlsy = source == "nlsy";
gen hsb = source == "hsb";


corr rat5010 relmob rat9050 p10 p50 rathsgraddrop ratcolhsgrad pctminority
     racesegindex povrate incarcrate expperst pupteachrat incseg segpovind
	 fracmanuf fracsingpar incshare1pct fracmidcls soccapind;

* first replicate main regressions;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
 

* Horse race #1: 90/50 ratio;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdrop9050 mtrgrad9050
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdrop9050 mtrgrad9050
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdrop9050 mtrgrad9050
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

* Horse race #2: 10th percentile of income distribution;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

* Horse race #3: 50th percentile of income distribution;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropp50 mtrgradp50
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropp50 mtrgradp50
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropp50 mtrgradp50
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

* Horse race #4: wage ratio, HS grad to HS drop;

* first include wage ratio on its own and then do the horse race;

areg nodegreeby20 mtrdroprhsd mtrgradrhsd 
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdroprhsd mtrgradrhsd
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

* Horse race #5: wage ratio, College grad to HS grad;

* first include wage ratio on its own and then do the horse race;
areg nodegreeby20 mtrdroprhsd mtrgradrhsd mtrdroprcolhs mtrgradrcolhs
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* now try both wage ratios together;

areg nodegreeby20 mtrdroprcolhs mtrgradrcolhs
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

* now do the horse race the same way as the others;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdroprcolhs mtrgradrcolhs
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #6: percent minority;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdroppctmin mtrgradpctmin
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdroppctmin mtrgradpctmin
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdroppctmin mtrgradpctmin
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #7: racial segregation index;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdroprseg mtrgradrseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdroprseg mtrgradrseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdroprseg mtrgradrseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #8: poverty rate;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdroppov mtrgradpov
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdroppov mtrgradpov
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdroppov mtrgradpov
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #9: incarceration rate;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropincrate mtrgradincrate
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropincrate mtrgradincrate
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropincrate mtrgradincrate
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #10: expenditures per student;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropexpst mtrgradexpst
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropexpst mtrgradexpst
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropexpst mtrgradexpst
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #11: pupil teacher ratio;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropptr mtrgradptr
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropptr mtrgradptr
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropptr mtrgradptr
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #12: income segregation;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropincseg mtrgradincseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropincseg mtrgradincseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropincseg mtrgradincseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #13: poverty segregation;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdroppovseg mtrgradpovseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdroppovseg mtrgradpovseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdroppovseg mtrgradpovseg
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #14: share of workers in manufacturing;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropmanuf mtrgradmanuf
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropmanuf mtrgradmanuf
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropmanuf mtrgradmanuf
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #15: fraction single parents;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropsingpar mtrgradsingpar
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropsingpar mtrgradsingpar
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropsingpar mtrgradsingpar
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

* Horse race #16: income share top 1%;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

* Horse race #17: share of population middle class;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropmidcls mtrgradmidcls
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropmidcls mtrgradmidcls
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropmidcls mtrgradmidcls
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
	 
* Horse race #18: social capital index;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropscap mtrgradscap
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropscap mtrgradscap
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropscap mtrgradscap
     mtrhsdrop mtrhsgrad exitexam1 exitexam2
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage minwage
     nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

	 log close;
