# delimit ;
capture log close;
log using d:\statprog\dropout\reg1-msa.log, replace;

/* 
****************

REG1

****************

This program estimates regression models relating the interaction between
mother's SES (captured by her educational attainment) and level of income
inequality in a respondent's state on the likelihood of dropping out of 
high school;
*/

clear;
use d:\data\nces\alldata-msa.dta;

drop if source == "nels" | source == "hsb";
drop if nodegreeby20 == . | gedby20 == . | diplomaby20 == .;

tab female [weight=smpwgt2], sum(nodegreeby20);
tab female [weight=smpwgt2], sum(gedby20);
tab female [weight=smpwgt2], sum(diplomaby20);

gen mtrdrop5010 = mtrhsdrop*rat5010;
gen mtrgrad5010 = mtrhsgrad*rat5010;

gen els = source == "els";
gen nlsy = source == "nlsy";

* base models with sample weights (note: no policy vars at MSA level);

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els [weight=smpwgt2], 
	 absorb(msa) robust cluster(msa);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els [weight=smpwgt2], 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els [weight=smpwgt2], 
	 absorb(msa) robust cluster(msa);
est store ediploma;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els [weight=smpwgt2], 
	 absorb(msa) robust cluster(msa);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);
estimates drop e*;
	 
* repeat these regressions omitting the sample weights;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els, 
	 absorb(msa) robust cluster(msa);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els, 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els, 
	 absorb(msa) robust cluster(msa);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els, 
	 absorb(msa) robust cluster(msa);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);
estimates drop e*;

* Repeat these regressions (without sampling weights) by gender;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 0, 
	 absorb(msa) robust cluster(msa);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 0, 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 0, 
	 absorb(msa) robust cluster(msa);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 0, 
	 absorb(msa) robust cluster(msa);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;


areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 1, 
	 absorb(msa) robust cluster(msa);
est store ehsdrop;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 1, 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 1, 
	 absorb(msa) robust cluster(msa);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 1, 
	 absorb(msa) robust cluster(msa);
est store ecolgrad;
	 
estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;


* Repeat these regressions (without sampling weights) by race;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if whitenh == 1, 
	 absorb(msa) robust cluster(msa);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if whitenh == 1, 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if whitenh == 1, 
	 absorb(msa) robust cluster(msa);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if whitenh == 1, 
	 absorb(msa) robust cluster(msa);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;



areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if blacknh == 1, 
	 absorb(msa) robust cluster(msa);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if blacknh == 1, 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if blacknh == 1, 
	 absorb(msa) robust cluster(msa);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if blacknh == 1, 
	 absorb(msa) robust cluster(msa);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;



areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if hispanic == 1, 
	 absorb(msa) robust cluster(msa);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if hispanic == 1, 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if hispanic == 1, 
	 absorb(msa) robust cluster(msa);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if hispanic == 1, 
	 absorb(msa) robust cluster(msa);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;

* Repeat these regressions (without sampling weights) by time period;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if yrsoph <= 1990, 
	 absorb(msa) robust cluster(msa);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if yrsoph <= 1990, 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if yrsoph <= 1990, 
	 absorb(msa) robust cluster(msa);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if yrsoph <= 1990, 
	 absorb(msa) robust cluster(msa);
est store ecolgrad; 

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;


areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if yrsoph > 1990, 
	 absorb(msa) robust cluster(msa);
est store ehsdrop;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if yrsoph > 1990, 
	 absorb(msa) robust cluster(msa);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if yrsoph > 1990, 
	 absorb(msa) robust cluster(msa);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy els if yrsoph > 1990, 
	 absorb(msa) robust cluster(msa);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;


log close;
