# delimit ;
capture log close;
log using d:\statprog\dropout\inpels1.log, replace;

clear;
use D:\Data\nces\els\ELS_02_06_BYF2STU_v1_0.dta ;

keep
   BYSEX BYRACE BYDOB_P BYFCOMP BYMOTHED BYFATHED BYINCOME BYSES1
   F2HSSTAT F2EDLEVL F2QXDATP STU_ID SCH_ID STRAT_ID PSU F1SCH_ID
   F1UNIV1 F1UNIV2A F1UNIV2B F2UNIV_P BYSTUWT F1QWT F1PNLWT F1TRSCWT
   F2QTSCWT F2QWT F2F1WT F2BYWT F2EVRGED BYTXMSTD BYTXRSTD  
   ;

rename BYSEX sex;
rename BYRACE raceeth;
rename BYDOB_P dob;
rename BYFCOMP famcomp;
rename BYMOTHED mtreduc;
rename BYFATHED ftreduc;
rename BYINCOME faminc;
rename BYSES1 famses;
rename F2HSSTAT hscomp06;
rename F2EDLEVL higradat;
rename F2QXDATP datint;
rename STU_ID studentid;
rename SCH_ID schoolid;
rename F2BYWT smpwgt;
rename BYTXMSTD mathstdsc;
rename BYTXRSTD readstdsc;

tab sex;
drop if sex < 0;
gen female = sex == 2;
gen whitenh = raceeth == 7;
gen hispanic = raceeth == 4 | raceeth == 5;
gen blacknh = raceeth == 3;
gen othernh = whitenh == 0 & blacknh == 0 & hispanic == 0;

gen birthyr = round(dob/100);
gen birthmo = dob-(birthyr*100);
replace datint = . if datint < 0;
gen intyr = round(datint/100);
gen intmo = dob-(birthyr*100);
gen age = int((mdy(intmo,15,intyr) - mdy(birthmo,15,birthyr))/365.25);

gen bothpar = famcomp == 1;
     replace bothpar = . if famcomp < 0;
gen mtrhsdrop = mtreduc == 1;
     replace mtrhsdrop = . if mtreduc < 0;
gen mtrhsgrad = mtreduc == 2;
     replace mtrhsgrad = . if mtreduc < 0;
gen mtranycol = mtreduc >= 3;
     replace mtranycol = . if mtreduc < 0;
gen ftrhsdrop = ftreduc == 1;
     replace ftrhsdrop = . if ftreduc < 0;
gen ftrhsgrad = ftreduc == 2;
     replace ftrhsgrad = . if ftreduc < 0;
gen ftranycol = ftreduc >= 3;
     replace ftranycol = . if ftreduc < 0;

gen diplomaby20 = hscomp06 <= 4;
     replace diplomaby20 = . if hscomp06 == 10;
gen gedby20 = hscomp06 == 5 | hscomp06 == 6;
     replace gedby20 = . if hscomp06 == 10;
gen nodegreeby20 = hscomp06 >= 7 & hscomp06 <= 9;
     replace nodegreeby20 = . if hscomp06 == 10;
gen  educoutby20 = "hsdrop" if nodegreeby20 == 1;
     replace educoutby20 = "ged" if gedby20 == 1;
	 replace educoutby20 = "hsgrad" if diplomaby20 == 1;
gen dipgedby20 = 0;
     replace dipgedby20 = 1 if diplomaby20 == 1 | gedby20 == 1;
     replace dipgedby20 = . if diplomaby20 == . | gedby20 == .;	 
	 
replace mathstdsc = . if mathstdsc < 0;
replace readstdsc = . if readstdsc < 0;
	 
sort studentid;
save d:\data\nces\els\temp1.dta, replace;

clear;
infix studentid 1-6 zip 7-11 stfips 12-13 cntyfips 14-16 using 
     d:\data\nces\els\geocodes.dat;
sort studentid;
merge studentid using d:\data\nces\els\temp1.dta;
tab _merge;
drop _merge;

sort stfips;
save d:\data\nces\els\temp1.dta, replace;

clear;
use d:\data\nces\nels\convstate.dta;
rename statefips stfips;
keep stfips stname;
sort stfips;
merge stfips using d:\data\nces\els\temp1.dta;
tab _merge;
drop if _merge == 1;
drop _merge;

*drop if smpwgt == 0;

sort stfips cntyfips;
save d:\data\nces\els\temp1.dta, replace;

clear;
use d:\data\nces\crosswalk-county-msa;

destring msa, replace;
keep stfips cntyfips msa;
replace msa = . if msa == 0;

sort stfips cntyfips;
merge stfips cntyfips using d:\data\nces\els\temp1.dta;
tab _merge;
drop if _merge == 1;
drop _merge;

sort studentid;
save d:\data\nces\els\dropout\elsdata.dta, replace;
erase d:\data\nces\els\temp1.dta;
log close;
