# delimit ;
capture log close;
log using d:\statprog\dropout\reghorserace-msa.log, replace;

/* 
****************

REGHORSERACE-MSA

****************

This program estimates horserace models comparing the impact of inequality 
to that of other economic variables in attempting to explain dropout status.

This version estimates these models at the MSA level;
*/

set more 1;
clear;
use d:\data\nces\alldata-msa.dta;

drop if source == "nels" | source == "hsb";
drop if nodegreeby20 == . | gedby20 == . | diplomaby20 == .;
keep if female == 0;

gen els = source == "els";
gen nlsy = source == "nlsy";

replace p50 = p50/1000;
replace p10 = p10/1000;
gen mtrdrop5010 = mtrhsdrop*rat5010;
gen mtrgrad5010 = mtrhsgrad*rat5010;
gen mtrdrop9050 = mtrhsdrop*rat9050;
gen mtrgrad9050 = mtrhsgrad*rat9050;
gen mtrdropp10 = mtrhsdrop*p10;
gen mtrgradp10 = mtrhsgrad*p10;
gen mtrdropp50 = mtrhsdrop*p50;
gen mtrgradp50 = mtrhsgrad*p50;
*gen mtrdroprhsd = mtrhsdrop*rathsgraddrop;
*gen mtrgradrhsd = mtrhsgrad*rathsgraddrop;
*gen mtrdroprcolhs = mtrhsdrop*ratcolhsgrad;
*gen mtrgradrcolhs = mtrhsgrad*ratcolhsgrad;
gen mtrdroprseg = mtrhsdrop*racesegind;
gen mtrgradrseg = mtrhsgrad*racesegind;
*gen mtrdropincrate = mtrhsdrop*incarcrate;
*gen mtrgradincrate = mtrhsgrad*incarcrate;
*gen mtrdroppov = mtrhsdrop*povrate;
*gen mtrgradpov = mtrhsgrad*povrate;
*gen mtrdroppctmin = mtrhsdrop*pctminority;
*gen mtrgradpctmin = mtrhsgrad*pctminority;
*gen mtrdropexpst = mtrhsdrop*expperst;
*gen mtrgradexpst = mtrhsgrad*expperst;
*gen mtrdropptr = mtrhsdrop*pupteachrat;
*gen mtrgradptr = mtrhsgrad*pupteachrat;
gen mtrdropincseg = mtrhsdrop*incseg;
gen mtrgradincseg = mtrhsgrad*incseg;
gen mtrdroppovseg = mtrhsdrop*segpovind;
gen mtrgradpovseg = mtrhsgrad*segpovind;
gen mtrdropmanuf = mtrhsdrop*fracmanuf;
gen mtrgradmanuf = mtrhsgrad*fracmanuf;
gen mtrdropsingpar = mtrhsdrop*fracsingpar;
gen mtrgradsingpar = mtrhsgrad*fracsingpar;
gen mtrdrop1pct = mtrhsdrop*incshare1pct;
gen mtrgrad1pct = mtrhsgrad*incshare1pct;
gen mtrdropmidcls = mtrhsdrop*fracmidcls;
gen mtrgradmidcls = mtrhsgrad*fracmidcls;
gen mtrdropscap = mtrhsdrop*soccapind;
gen mtrgradscap = mtrhsgrad*soccapind;

corr rat5010 relmob rat9050 p10 p50 racesegind incseg segpovind
	 fracmanuf fracsingpar incshare1pct fracmidcls soccapind;

* first replicate main regressions;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     hispanic blacknh bothpar nlsy els if female == 0, 
	 absorb(msa) robust cluster(msa);

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad hispanic blacknh
     bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad hispanic blacknh
     bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad hispanic blacknh
     bothpar nlsy els, absorb(msa) robust cluster(msa);


* Horse race #1: 90/50 ratio;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdrop9050 mtrgrad9050
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdrop9050 mtrgrad9050
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdrop9050 mtrgrad9050
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
	 

* Horse race #2: 10th percentile of income distribution;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropp10 mtrgradp10
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);

* Horse race #3: 50th percentile of income distribution;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropp50 mtrgradp50
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropp50 mtrgradp50
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropp50 mtrgradp50
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);

* Horse race #4: 50th percentile of income distribution;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
	 
* Horse race #7: racial segregation index;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdroprseg mtrgradrseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdroprseg mtrgradrseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdroprseg mtrgradrseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
	 
* Horse race #12: income segregation;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropincseg mtrgradincseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropincseg mtrgradincseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropincseg mtrgradincseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
	 
* Horse race #13: poverty segregation;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdroppovseg mtrgradpovseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdroppovseg mtrgradpovseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdroppovseg mtrgradpovseg
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
	 
* Horse race #14: share of workers in manufacturing;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropmanuf mtrgradmanuf
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropmanuf mtrgradmanuf
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropmanuf mtrgradmanuf
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
	 
* Horse race #15: fraction single parents;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropsingpar mtrgradsingpar
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropsingpar mtrgradsingpar
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropsingpar mtrgradsingpar
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);

* Horse race #16: income share top 1%;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdrop1pct mtrgrad1pct
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);

* Horse race #17: share of population middle class;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropmidcls mtrgradmidcls
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropmidcls mtrgradmidcls
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropmidcls mtrgradmidcls
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
	 
* Horse race #18: social capital index;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropscap mtrgradscap
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrdropscap mtrgradscap
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrdropscap mtrgradscap
     mtrhsdrop mtrhsgrad hispanic 
	 blacknh bothpar nlsy els, absorb(msa) robust cluster(msa);
	 
log close;
