# delimit ;
capture log close;
log using d:\statprog\dropout\regafqt.log, replace;

/*
****************
 
REGAFQT

****************

This program estimates regression models of the same format as REG1.do, but
changes the dependent variable so that it is AFQT rather than educational
attainment;

*/

clear;
use d:\data\nces\alldata.dta;

gen mtrdrop5010 = mtrhsdrop*rat5010;
gen mtrgrad5010 = mtrhsgrad*rat5010;
gen mtrdroprmob = mtrhsdrop*relmobility;
gen mtrgradrmob = mtrhsgrad*relmobility;

gen nels = source == "nels";
gen els = source == "els";
gen nlsy = source == "nlsy";
gen hsb = source == "hsb";
 
keep if female == 0;

sum nodegreeby20 afqt [weight=smpwgt];

* First replicate earlier regression results but without policy variables. 
It doesn't make sense to include them just with the two NLSY datasets, so let's
drop them here also;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad
     female hispanic blacknh bothpar nlsy nels els hsb, 
	 absorb(stfips) robust cluster(stfips);
areg nodegreeby20 mtrdroprmob mtrgradrmob mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy nels els hsb,
	 absorb(stfips) robust cluster(stfips);

* Now replicate these regressions just for NLSY surveys without policy variation
and just those observations with AFQT scores;

drop if afqtadj == .;
keep if source == "nlsy" | source == "nlsy97";

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy, absorb(stfips) robust cluster(stfips);
areg nodegreeby20 mtrdroprmob mtrgradrmob mtrhsdrop mtrhsgrad
     female hispanic blacknh bothpar nlsy, absorb(stfips) robust cluster(stfips);

* confirm that AFQT scores are lower for low SES kids;
	 
areg afqtadj mtrhsdrop mtrhsgrad
     female hispanic blacknh bothpar nlsy, absorb(stfips) robust cluster(stfips);
	 
* examine whether AFQT scores are lower for low SES kids in high inequality/
low mobility states;

areg afqtadj mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad
     female hispanic blacknh bothpar nlsy, absorb(stfips) robust cluster(stfips);
areg afqtadj mtrdroprmob mtrgradrmob mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar nlsy, absorb(stfips) robust cluster(stfips);

* add afqt into baseline regressions;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad afqtadj
     female hispanic blacknh bothpar nlsy, absorb(stfips) robust cluster(stfips);
areg nodegreeby20 mtrdroprmob mtrgradrmob mtrhsdrop mtrhsgrad afqtadj
     female hispanic blacknh bothpar nlsy, absorb(stfips) robust cluster(stfips);

* determine whether AFQT distributions are more disperse in higher inequality states;

sort stfips nlsy;
collapse (sd) sdafqt=afqtadj (p10) afqt10=afqtadj (p50) afqt50=afqtadj 
     (mean) rat5010 absmob relmob mnafqt=afqtadj (count) numobs=afqt, by(stfips nlsy);

gen afqt5010 = afqt50/afqt10;
regress sdafqt rat5010 nlsy [weight=numobs];
regress afqt5010 rat5010 nlsy [weight=numobs];
regress sdafqt absmob nlsy [weight=numobs]; 
regress sdafqt relmob nlsy [weight=numobs]; 

corr sdafqt afqt5010 rat5010 absmob relmob [weight=numobs];





log close;
