# delimit ;
capture log close;
log using d:\statprog\dropout\reg1.log, replace;

/*
****************
 
REG1

****************

This program estimates regression models relating the interaction between
mother's SES (captured by her educational attainment) and level of income
inequality in a respondent's state on the likelihood of dropping out of 
high school;

Note: models for college graduates do not include ELS data (not old enough yet);
*/

clear;
use d:\data\nces\alldata.dta;

drop if nodegreeby20 == . | gedby20 == . | diplomaby20 == .;

gen ineqcat = 1 if lowineq == 1;
replace ineqcat = 2 if midineq == 1;
replace ineqcat = 3 if highineq == 1;
label defin ineqlbl 1 "low" 2 "mid" 3 "high";
label values ineqcat ineqlbl;

gen mtrsescat = 1 if mtrhsdrop == 1;
replace mtrsescat = 2 if mtrhsgrad == 1;
replace mtrsescat = 3 if mtranycol == 1;
label defin mtrseslbl 1 "hsdrop" 2 "hsgrad" 3 "anycol";
label values mtrsescat mtrseslbl;

tab ineqcat mtrsescat [weight=smpwgt2], sum(nodegreeby20);
tab ineqcat mtrsescat [weight=smpwgt2], sum(gedby20);
tab ineqcat mtrsescat [weight=smpwgt2], sum(diplomaby20);

tab ineqcat mtrsescat [weight=smpwgt2], sum(nodegreeby20) nofr nost noobs;
tab ineqcat mtrsescat [weight=smpwgt2], sum(gedby20) nofr nost noobs;
tab ineqcat mtrsescat [weight=smpwgt2], sum(diplomaby20) nofr nost noobs;

gen mtrdrop5010 = mtrhsdrop*rat5010;
gen mtrgrad5010 = mtrhsgrad*rat5010;

* generate interactions between level of inequality and SES;

gen mtrdrophi = mtrhsdrop == 1 & highineq == 1;
gen mtrdropmid = mtrhsdrop == 1 & midineq == 1;
gen mtrgradhi = mtrhsgrad == 1 & highineq == 1;
gen mtrgradmid = mtrhsgrad == 1 & midineq == 1;

gen nels = source == "nels";
gen els = source == "els";
gen nlsy = source == "nlsy";
gen hsb = source == "hsb";

/* first estimate regression models designed to replicate the figures,
comparing different SES children and high, medium, and low inequality;*/

regress nodegreeby20 mtrdrophi mtrdropmid mtrgradhi mtrgradmid
     mtrhsdrop mtrhsgrad midineq highineq nlsy nels els hsb [weight=smpwgt2];
regress gedby20 mtrdrophi mtrdropmid mtrgradhi mtrgradmid
     mtrhsdrop mtrhsgrad midineq highineq nlsy nels els hsb [weight=smpwgt2];
regress diplomaby20 mtrdrophi mtrdropmid mtrgradhi mtrgradmid
     mtrhsdrop mtrhsgrad midineq highineq nlsy nels els hsb [weight=smpwgt2];


* now use continuous measures of inequality;

regress nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     midineq highineq nlsy nels els hsb [weight=smpwgt2];
regress gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     midineq highineq nlsy nels els hsb [weight=smpwgt2];
regress diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     midineq highineq nlsy nels els hsb [weight=smpwgt2];


* now add state fixed effects and fix standard errors;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     nlsy nels els hsb [weight=smpwgt2], absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     nlsy nels els hsb [weight=smpwgt2], absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     nlsy nels els hsb [weight=smpwgt2], absorb(stfips) robust cluster(stfips);


* now add additional explanatory variables;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb [weight=smpwgt2], 
	 absorb(stfips) robust cluster(stfips);
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb [weight=smpwgt2], 
	 absorb(stfips) robust cluster(stfips);
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb [weight=smpwgt2], 
	 absorb(stfips) robust cluster(stfips);

	 
* repeat these regressions omitting the sample weights;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb, absorb(stfips) robust cluster(stfips);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;

* Repeat these regressions (without sampling weights) by gender;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if female == 0, 
	 absorb(stfips) robust cluster(stfips);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if female == 0, 
	 absorb(stfips) robust cluster(stfips);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if female == 0, 
	 absorb(stfips) robust cluster(stfips);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if female == 0, 
	 absorb(stfips) robust cluster(stfips);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;


areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if female == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ehsdrop;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 exitexam2
	 minwage nlsy nels els hsb if female == 1, 
	 absorb(stfips) robust cluster(stfips);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 exitexam2
	 minwage nlsy nels els hsb if female == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 exitexam2
	 minwage nlsy nels els hsb if female == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ecolgrad;
	 
estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;


* Repeat these regressions (without sampling weights) by race;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if whitenh == 1, 
	 absorb(stfips) robust cluster(stfips);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if whitenh == 1, 
	 absorb(stfips) robust cluster(stfips);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if whitenh == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if whitenh == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;



areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if blacknh == 1, 
	 absorb(stfips) robust cluster(stfips);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if blacknh == 1, 
	 absorb(stfips) robust cluster(stfips);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if blacknh == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if blacknh == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;



areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if hispanic == 1, 
	 absorb(stfips) robust cluster(stfips);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if hispanic == 1, 
	 absorb(stfips) robust cluster(stfips);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if hispanic == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if hispanic == 1, 
	 absorb(stfips) robust cluster(stfips);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;

* Repeat these regressions (without sampling weights) by time period;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if yrsoph <= 1990, 
	 absorb(stfips) robust cluster(stfips);
est store edropout;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if yrsoph <= 1990, 
	 absorb(stfips) robust cluster(stfips);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if yrsoph <= 1990, 
	 absorb(stfips) robust cluster(stfips);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if yrsoph <= 1990, 
	 absorb(stfips) robust cluster(stfips);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;


areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if yrsoph > 1990, 
	 absorb(stfips) robust cluster(stfips);
est store ehsdrop;
areg gedby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if yrsoph > 1990, 
	 absorb(stfips) robust cluster(stfips);
est store eged;
areg diplomaby20 mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if yrsoph > 1990, 
	 absorb(stfips) robust cluster(stfips);
est store ehsgrad;
areg colgrad mtrdrop5010 mtrgrad5010 mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar unemrate tanfwaiv famcap schip medfunding 
	 parental delay rmaxben3 maxbenmis waivpov waivdur mindropage exitexam1 
	 exitexam2 minwage nlsy nels els hsb if yrsoph > 1990, 
	 absorb(stfips) robust cluster(stfips);
est store ecolgrad;

estout e*, cells(b(fmt(%9.3f)) se(par fmt(%9.3f)))
stats(ar2 N, fmt(%9.3f %9.0g) labels(R^2))
legend label collabels(, none)
prefoot("") postfoot("") varwidth(16) modelwidth(8)
keep(mtrdrop5010 mtrgrad5010)
order(mtrdrop5010 mtrgrad5010);

estimates drop e*;


*explore whether interactions of included policy vars with SES matter;

gen mtrdropunem = mtrhsdrop*unemrate;
gen mtrgradunem = mtrhsgrad*unemrate;
gen mtrdropexam1 = mtrhsdrop*exitexam1;
gen mtrgradexam1 = mtrhsgrad*exitexam1;
gen mtrdropexam2 = mtrhsdrop*exitexam2;
gen mtrgradexam2 = mtrhsgrad*exitexam2;
gen mtrdropage = mtrhsdrop*mindropage;
gen mtrgradage = mtrhsgrad*mindropage;
gen mtrdropmwage = mtrhsdrop*minwage;
gen mtrgradmwage = mtrhsgrad*minwage;
gen mtrdropben3 = mtrhsdrop*rmaxben3;
gen mtrgradben3 = mtrhsgrad*rmaxben3;

areg nodegreeby20 mtrdrop5010 mtrgrad5010 mtrdropunem mtrgradunem unemrate
     mtrdropexam1 mtrgradexam1 exitexam1 mtrdropexam2 mtrgradexam2 exitexam2
	 mtrdropage mtrgradage mindropage mtrdropmwage mtrgradmwage minwage
	 mtrdropben3 mtrgradben3 rmaxben3 maxbenmis mtrhsdrop mtrhsgrad 
     female hispanic blacknh bothpar tanfwaiv famcap schip medfunding 
	 parental delay waivpov waivdur
	 nlsy nels els hsb, absorb(stfips) robust cluster(stfips);

log close;
