# delimit ;
capture log close;
log using d:\statprog\dropout\inphisted.log, replace;

*****************

INPHISTED

*****************

This program reads in historical education data provided by Nora Gordon that
originally came from Liz Cascio. It includes educational expenditures per
student as well as student-teacher ratios. For this project, we need state
averages of these outcomes, not state by year. This program collapses those
data;

clear;
use d:\data\nces\historical-education-data.dta;

keep stfip year expperada ptratio_enr;
rename stfip stfips;
rename expperada expperst;
rename ptratio_enr pupteachrat;

keep if year >= 1970;

replace expperst = 5.12*expperst if year == 1971;
replace expperst = 4.67*expperst if year == 1973;
replace expperst = 3.85*expperst if year == 1975;
replace expperst = 3.42*expperst if year == 1977;
replace expperst = 2.86*expperst if year == 1979;
replace expperst = 2.52*expperst if year == 1980;
replace expperst = 2.28*expperst if year == 1981;
replace expperst = 2.15*expperst if year == 1982;
replace expperst = 2.08*expperst if year == 1983;
replace expperst = 2.00*expperst if year == 1984;
replace expperst = 1.93*expperst if year == 1985;
replace expperst = 1.89*expperst if year == 1986;
replace expperst = 1.83*expperst if year == 1987;
replace expperst = 1.75*expperst if year == 1988;
replace expperst = 1.67*expperst if year == 1989;
replace expperst = 1.59*expperst if year == 1990;
replace expperst = 1.52*expperst if year == 1991;
replace expperst = 1.48*expperst if year == 1992;
replace expperst = 1.43*expperst if year == 1993;
replace expperst = 1.40*expperst if year == 1994;
replace expperst = 1.36*expperst if year == 1995;
replace expperst = 1.32*expperst if year == 1996;
replace expperst = 1.29*expperst if year == 1997;
replace expperst = 1.27*expperst if year == 1998;
replace expperst = 1.24*expperst if year == 1999;
replace expperst = 1.20*expperst if year == 2000;
replace expperst = 1.17*expperst if year == 2001;
replace expperst = 1.15*expperst if year == 2002;
replace expperst = 1.13*expperst if year == 2003;
replace expperst = 1.10*expperst if year == 2004;
replace expperst = 1.06*expperst if year == 2005;
replace expperst = 1.03*expperst if year == 2006;

sort stfips;
collapse expperst pupteachrat, by(stfips);

list, noobs clean;

log close;

