***************************************************************
*BPEA 2016 public do file
*Cavallo, Cruces and Perez-Truglia
*"Learning from potentially biased statistics
*Household Inflation Perceptions and Expectations in Argentina"
*Do file for tables 1 and 2 and all figures except 2 and 3
*Figures 2 and 3 in separate do and data files
***************************************************************

*Check if these programs are installed:
/*
ssc install dsconcat
ssc install egenmore
ssc install coefplot
ssc install estout
ssc install outreg2
ssc install sxpose
ssc install dataout
ssc install listtex

*escftest
net install http://www.stata-journal.com/software/sj9-3/st0174.pkg
*/

version 13
*SET DIRECTORY:

cd "G:\MyDocuments\Trabajo\AA_Ongoing\Indec\Data\Public"


********************************
*PROGRAMS FOR PVALUES OF ES TEST
*For histograms
********************************

capture program drop myks2
program define myks2
	escftest `3' if `2'|`1',group(`1')
	local kk=int(r(p_val)*100)
	if `kk'<10{
		if `kk'==0{
		global ks="<0.01"
		}
		else{
		global ks="0.0`kk'"
		}
	}
	else	{
		global ks="0.`kk'"
	}
end

set more off


******************
*Globals for Figures
******************

global PI0_X_AXIS "Inflation Perceptions, Previous 12 Months (%)"
global PI1_X_AXIS "Inflation Expectations, Next 12 Months (%)"

global PI0_PI1_X_AXIS "Inflation Perceptions/Expectations, Previous/Next 12 Months (%)"

global CONTROLS ""

****************
****************
*Tables 
*descriptive 
*and balance
****************
****************

use "BPEA_Cavallo_Cruces_Perez-Truglia_2016.dta", clear

****************
*Table 1
****************

sum female age gba coll_ter_complete voted_cristina

*Note: second row of table from 
*INDEC - Instituto Nacional de Estadstica y Censo, Argentina 
*ENCUESTA ANUAL DE HOGARES URBANOS.
*www.indec.gob.ar/redatam/eahu/

****************
*Table 2
****************

*Non standardized confidence: 
drop confidencepi0
gen confidencepi0=old_confidencepi0
label var confidencepi0 "confidencepi0"

*Descriptive statistics
reg pi0 control i10-p30,noc
		
reg confidencepi0 control i10-p30,noc
		
reg pi1 control i10-p30,noc

reg female control i10-p30,noc

reg age control i10-p30,noc

reg coll_ter_complete control i10-p30,noc

reg ownpresentbetter  control i10-p30,noc

*P-values

tokenize pi0 confidencepi0 pi1 female age coll_ter_complete ownpresentbetter 

while "`1'"!="" {
qui reg `1' control i10-p30,noc 
qui test control==i10==i20==i30==p10==p20==p30
di "`1'   " in yellow r(p)
qui mvtest means `1',by(treatcat) het
di "`1'   " in yellow r(p_chi2)
local `1'_pv=round(r(p_chi2)*100,01)/100
mac shift
}

************************
*Figure 4
*HISTOGRAMS 
*Treatments vs controls: 
*Inflation perceptions pi0
************************
use "BPEA_Cavallo_Cruces_Perez-Truglia_2016.dta", clear

preserve
gen pi0_orig=pi0
gen pi1_orig=pi1

replace pi0=60 if pi0>=61&pi0!=.
replace pi0=1 if pi0==0
replace pi1=60 if pi1>=61&pi1!=.
replace pi1=1 if pi1==0

set more off

	myks2 control i10 pi0_orig
	two histogram pi0 if control, fcolor(gs8) lcolor(white) legend(region(lcolor(white)) size(*.8) cols(1) ring(0) position(1) label(1 "Control")) percent /*
	*/ yscale(range(0 35)) ylabel(0(5)36)  /*
	*/ xscale(range(0 60)) xlabel(3.5 "{&le}5" 8.5 "6-10" 13.5 "11-15" 18.5 "16-20" 23.5 "21-25" 28.5 "26-30" 33.5 "31-35" /*
	*/ 38.5 "36-40" 43.5 "41-45" 48.5 "46-50" 53.5 "51-55" 58.5 "{&ge}56",labsize(small) angle(45)) /* 
	*/ xtitle("$PI0_X_AXIS",height(7)) start(1) width(5) /*
	*/|| histogram pi0 if i10, start(1) width(5) percent fcolor(none) lcolor(black) scheme(s1mono) legend(label(2 "Official 10%")) /*
	*/ note("Note: ES test p-value: $ks N control $NCONTROL, N treated $NI10")

	graph export "figure_INDEC_hist_treatment_effects_pi0_i10.eps", replace
	graph export "figure_INDEC_hist_treatment_effects_pi0_i10.png", replace


	myks2 control i20 pi0_orig
	two histogram pi0 if control, fcolor(gs8) lcolor(white) legend(region(lcolor(white)) size(*.8) cols(1) ring(0) position(1) label(1 "Control")) percent /*
	*/ yscale(range(0 35)) ylabel(0(5)36)  /*
	*/ xscale(range(0 60)) xlabel(3.5 "{&le}5" 8.5 "6-10" 13.5 "11-15" 18.5 "16-20" 23.5 "21-25" 28.5 "26-30" 33.5 "31-35" /*
	*/ 38.5 "36-40" 43.5 "41-45" 48.5 "46-50" 53.5 "51-55" 58.5 "{&ge}56",labsize(small) angle(45)) /* 
	*/ xtitle("$PI0_X_AXIS",height(7)) start(1) width(5) /*
	*/|| histogram pi0 if i20, start(1) width(5) percent fcolor(none) lcolor(black) scheme(s1mono) legend(label(2 "Official 20%")) /*
	*/ note("Note: ES test p-value: $ks N control $NCONTROL, N treated $NI20")

	graph export "figure_INDEC_hist_treatment_effects_pi0_i20.eps", replace
	graph export "figure_INDEC_hist_treatment_effects_pi0_i20.png", replace
	

	myks2 control i30 pi0_orig
	two histogram pi0 if control, fcolor(gs8) lcolor(white) legend(region(lcolor(white)) size(*.8) cols(1) ring(0) position(1) label(1 "Control")) percent /*
	*/ yscale(range(0 35)) ylabel(0(5)36)  /*
	*/ xscale(range(0 60)) xlabel(3.5 "{&le}5" 8.5 "6-10" 13.5 "11-15" 18.5 "16-20" 23.5 "21-25" 28.5 "26-30" 33.5 "31-35" /*
	*/ 38.5 "36-40" 43.5 "41-45" 48.5 "46-50" 53.5 "51-55" 58.5 "{&ge}56",labsize(small) angle(45)) /* 
	*/ xtitle("$PI0_X_AXIS",height(7)) start(1) width(5) /*
	*/|| histogram pi0 if i30, start(1) width(5) percent fcolor(none) lcolor(black) scheme(s1mono) legend(label(2 "Official 30%")) /*
	*/ note("Note: ES test p-value: $ks N control $NCONTROL, N treated $NI30")

	graph export "figure_INDEC_hist_treatment_effects_pi0_i30.eps", replace
	graph export "figure_INDEC_hist_treatment_effects_pi0_i30.png", replace
	

	myks2 control p10 pi0_orig
	two histogram pi0 if control, fcolor(gs8) lcolor(white) legend(region(lcolor(white)) size(*.8) cols(1) ring(0) position(1) label(1 "Control")) percent /*
	*/ yscale(range(0 35)) ylabel(0(5)36)  /*
	*/ xscale(range(0 60)) xlabel(3.5 "{&le}5" 8.5 "6-10" 13.5 "11-15" 18.5 "16-20" 23.5 "21-25" 28.5 "26-30" 33.5 "31-35" /*
	*/ 38.5 "36-40" 43.5 "41-45" 48.5 "46-50" 53.5 "51-55" 58.5 "{&ge}56",labsize(small) angle(45)) /* 
	*/ xtitle("$PI0_X_AXIS",height(7)) start(1) width(5) /*
	*/|| histogram pi0 if p10, start(1) width(5) percent fcolor(none) lcolor(black) scheme(s1mono) legend(label(2 "Unofficial 10%")) /*
	*/ note("Note: ES test p-value: $ks N control $NCONTROL, N treated $NP10")

	graph export "figure_INDEC_hist_treatment_effects_pi0_p10.eps", replace
	graph export "figure_INDEC_hist_treatment_effects_pi0_p10.png", replace


	myks2 control p20 pi0_orig
	two histogram pi0 if control, fcolor(gs8) lcolor(white) legend(region(lcolor(white)) size(*.8) cols(1) ring(0) position(1) label(1 "Control")) percent /*
	*/ yscale(range(0 35)) ylabel(0(5)36)  /*
	*/ xscale(range(0 60)) xlabel(3.5 "{&le}5" 8.5 "6-10" 13.5 "11-15" 18.5 "16-20" 23.5 "21-25" 28.5 "26-30" 33.5 "31-35" /*
	*/ 38.5 "36-40" 43.5 "41-45" 48.5 "46-50" 53.5 "51-55" 58.5 "{&ge}56",labsize(small) angle(45)) /* 
	*/ xtitle("$PI0_X_AXIS",height(7)) start(1) width(5) /*
	*/|| histogram pi0 if p20, start(1) width(5) percent fcolor(none) lcolor(black) scheme(s1mono) legend(label(2 "Unofficial 20%")) /*
	*/ note("Note: ES test p-value: $ks N control $NCONTROL, N treated $NP20")

	graph export "figure_INDEC_hist_treatment_effects_pi0_p20.eps", replace
	graph export "figure_INDEC_hist_treatment_effects_pi0_p20.png", replace
	

	myks2 control p30 pi0_orig
	two histogram pi0 if control, fcolor(gs8) lcolor(white) legend(region(lcolor(white)) size(*.8) cols(1) ring(0) position(1) label(1 "Control")) percent /*
	*/ yscale(range(0 35)) ylabel(0(5)36)  /*
	*/ xscale(range(0 60)) xlabel(3.5 "{&le}5" 8.5 "6-10" 13.5 "11-15" 18.5 "16-20" 23.5 "21-25" 28.5 "26-30" 33.5 "31-35" /*
	*/ 38.5 "36-40" 43.5 "41-45" 48.5 "46-50" 53.5 "51-55" 58.5 "{&ge}56",labsize(small) angle(45)) /* 
	*/ xtitle("$PI0_X_AXIS",height(7)) start(1) width(5) /*
	*/|| histogram pi0 if p30, start(1) width(5) percent fcolor(none) lcolor(black) scheme(s1mono) legend(label(2 "Unofficial 30%")) /*
	*/ note("Note: ES test p-value: $ks N control $NCONTROL, N treated $NP30")

	graph export "figure_INDEC_hist_treatment_effects_pi0_p30.eps", replace
	graph export "figure_INDEC_hist_treatment_effects_pi0_p30.png", replace

restore
aa
************************
*** Figure 5
*** PASS-THROUGH FIGURE
*** CONTROLS ONLY
************************

preserve
keep if control

xtile xtile_pi0=pi0, nq(100)
bysort xtile_pi0: egen aux_pi0=mean(pi0)
bysort xtile_pi0: egen aux_pi1=mean(pi1)

reg pi1 pi0
predict pi1hat_ols, xb

reg pi1 pi0 if control,rob
		local b: display %5.3f _b[pi0]
		local se: display %5.3f _se[pi0]
	
label var pi1hat_ols "OLS Fit"
two (scatter pi1 pi0, mcolor(gs15) msymbol(o) legend(on region(lcolor(white)) cols(1) ring(0) position(11) label(1 "Scatter"))) /*
*/ (scatter aux_pi1 aux_pi0,  mcolor(gs5) msymbol(O) legend(label(2 "Binned Scatter"))) /*
*/ (line pi1hat_ols  pi0, lpattern(solid) sort scheme(s1mono)), /*
*/ xtitle("Inflation Perceptions, Previous 12 Months (%)", margin(0 0 0 3)) title("") /*
*/ ytitle("Inflation Expectations, Next 12 Months (%)", margin(0 3 0 0)) /*
*/ note("Coef.=`b'     "  " ", size(medium) position(5) ring(0) bmargin(large))

graph export "figure_INDEC_pass_through.eps", replace
graph export "figure_INDEC_pass_through.png", replace

restore


	
**********************
*Figure 6: 
*TREATMENT ESTIMATES 
*COEFPLOTS
**********************

************
*pi0 and pi1
************

preserve 

reg pi0 i10-p30,rob
estimates store pi0
reg pi1 i10-p30,rob
estimates store pi1
	coefplot (pi0,label("Effect on" "Inflation Perceptions")) (pi1,label("Effect on" "Inflation Expectations")),/*
	*/ xline(0) drop(_cons) scheme(s1mono) ciopts(recast(rcap)) citop fcolor(*.5) recast(bar) barwidth(0.33)   /*
	*/ groups(control="{bf:Control}" i10 i20 i30="{bf:Official}" p10 p20 p30="{bf:Unofficial}") xtitle("")
	graph export "figure_INDEC_coefplot_pi0pi1.eps", replace
	graph export "figure_INDEC_coefplot_pi0pi1.png", replace

sum pi0 if control
local control_mean: display %6.2f r(mean)
reg pi0 i10-p30,rob
	coefplot,xtitle(" " "Effect on Inflation Perceptions" "Control Group Mean: `control_mean'") /*
	*/ xline(0) drop(_cons) scheme(s1mono) ciopts(recast(rcap)) citop fcolor(*.5) recast(bar) barwidth(0.33)   /*
	*/ groups(control="{bf:Control}" i10 i20 i30="{bf:Official}" p10 p20 p30="{bf:Unofficial}") 
	graph export "figure_INDEC_coefplot_pi0.eps", replace
	graph export "figure_INDEC_coefplot_pi0.png", replace

sum pi1 if control
local control_mean: display %6.2f r(mean)
reg pi1 i10-p30,rob
	coefplot,xtitle(" " "Effect on Inflation Expectations" "Control Group Mean: `control_mean'") /*
	*/ xline(0) drop(_cons) scheme(s1mono) ciopts(recast(rcap)) citop fcolor(*.5) recast(bar) barwidth(0.33)   /*
	*/ groups(control="{bf:Control}" i10 i20 i30="{bf:Official}" p10 p20 p30="{bf:Unofficial}") 
	graph export "figure_INDEC_coefplot_pi1.eps", replace
	graph export "figure_INDEC_coefplot_pi1.png", replace
	
reg confidencepi0 i10-p30,rob
	coefplot,xtitle(" " "Effect on Confidence on Inflation Perceptions (Standardized)" "Control Group Mean: 0") xlabel(, format(%5.1f))/*
	*/ xline(0) drop(_cons) scheme(s1mono) ciopts(recast(rcap)) citop fcolor(*.5) recast(bar) barwidth(0.33)   /*
	*/ groups(control="{bf:Control}" i10 i20 i30="{bf:Official}" p10 p20 p30="{bf:Unofficial}") 
	graph export "figure_INDEC_coefplot_confidencepi0std.eps", replace
	graph export "figure_INDEC_coefplot_confidencepi0std.png", replace

restore
	
**********
*Figure 7
**********

preserve
keep if control
gen pi0_aux=pi0
replace pi0_aux=60 if pi0>=61&pi0!=.
gen pi1_aux=pi1
replace pi1_aux=60 if pi1>=61&pi1!=.

*Perception vs expectation
two histogram pi0_aux if control, fcolor(gs8) lcolor(white) legend(region(lcolor(white)) size(*.8) cols(1) ring(0) position(1) /*
*/ label(1 "Inflation Perceptions")) percent yscale(range(0 32)) ylabel(0(5)40) xscale(range(0 60)) /*
*/ xlabel(2.5 "{&le}5" 7.5 "6-10" 12.5 "11-15" 17.5 "16-20" 22.5 "21-25" 27.5 "26-30" 32.5 "31-35" 37.5 "36-40" 42.5 "41-45" 47.5 "46-50" /*
*/ 52.5 "51-55" 57.5 "{&ge}56",labsize(small) angle(45)) /* 
*/ xtitle("$PI0_PI1_X_AXIS",height(7)) start(1) width(5) /*
*/ || histogram pi1_aux if control, start(1) width(5) percent fcolor(none) lcolor(black) scheme(s1mono) legend(label(2 "Inflation Expectations")) /*
*/ name("p_e", replace) note("") 

restore
