cap clear
cap clear matrix
cap clear mata
cap log close
set maxvar 32000
set more off

log using "/mecs/scf7/research/scf.soi.compare/pgm/files.for.bpea/joint.returns.char.foundations.log", replace

/*-------------------------
2010 Public data
-------------------------*/
*use /mecs/scf3/final/scf2010/data/transf/scf10i6.dta, clear
use /lcl/mecs/scf3/final/scf2010/data/transf/scf10i6.dta, clear

merge 1:1 yy1 y1 using /mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp2010.dta, gen(mergescf10)

keep yy1 y1 networth wgt x5744 x5746 married x30009 income x7660 x7661 

gen imp = mod(y1,10)


/*---------- JOINT RETURNS ----------*/
    
// Non-filers
gen nonfiler = (x5744==5)

summ nonfiler [aw=wgt], d

// Only married/living w partner here (they are only one who we care about joint filing)
gen joint = 1 if (x5744==1 | x5744==6) & x5746==1 & married==1
replace joint = 0 if (x5744==1 | x5744==6) & x5746==2 & married==1

// Percentile of NW
gsort - networth
gen count=sum(wgt)
summ networth [aw=wgt]
gen N=`r(sum_w)'
gen pctile = count/N
summ N pctile

gen top1=0
replace top1 = 1 if pctile<=0.01

// Percentile of income
gsort - income
gen countinc=sum(wgt)
summ income [aw=wgt]
gen Ninc=`r(sum_w)'
gen pctileinc = countinc/Ninc
summ Ninc pctileinc

gen top1inc=0
replace top1inc = 1 if pctileinc<=0.01

// Pct of joint filings in top 1 vs outside of top 1 (among married/lwp families)
tabstat joint [aw=wgt], by(top1)
tabstat joint [aw=wgt], by(top1inc)

/*---------- CHARITABLE FOUNDATIONS ----------*/
// $ held in char trusts and foundations by top 1 status
tabstat x7661 [aw=wgt ], by(top1) stats(mean sum)
// Net worth by top 1 status
tabstat  networth [aw=wgt ], by(top1) stats(mean sum)

/// Urban Institute "The Nonprofit Sector in Brief 2015" Talbe 1 says $5.17 trill in total nonprofit assets. Thus, total of x7661 (427 billion) is less than 10% of total nonprofit assets.
log close
