set type double
clear all
set more off
set matsize 11000
set maxvar 32767
adopath +  /lcl/mecs/scf7/analysis/software/stata/ados/
global datascfdir1 "/lcl/mecs/scf7/research/scf.soi.compare/data"
***LINK TO PUBLIC BULLETIN paths HERE
global datascfdir2 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal"
global datascfdir3 "/lcl/mecs/scf7/analysis/bulletin/2010/data/transf/bull_nominal"
global filepath /mecs/scf7/research/retirement.wealth/

***LINK TO PUBLIC datasets HERE (note: datasets too big to send via email but downloadable)
local scf2013 "/lcl/mecs/scf4/public/scf2013/data/transf/p13i6.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf2013s.zip
local scf2010 "/lcl/mecs/scf4/public/scf2010/data/transf/p10i6.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf2010s.zip
local scf2007 "/lcl/mecs/scf4/public/scf2007/data/transf/p07i6.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf2007s.zip
local scf2004 "/lcl/mecs/scf4/public/scf2004/data/transf/p04i6.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf2004s.zip
local scf2001 "/lcl/mecs/scf4/public/scf2001/data/transf/p01i6.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf2001s.zip
local scf1998 "/lcl/mecs/scf4/public/scf98/data/transf/p98i6.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf1998s.zip
local scf1995 "/lcl/mecs/scf4/public/scf95/data/transf/p95i6.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf1995s.zip
local scf1992 "/lcl/mecs/scf4/public/scf92/data/transf/p92i4.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf1992s.zip
local scf1989 "/lcl/mecs/scf4/public/scf89/data/transf/p89i6.dta"
* grab from http://www.federalreserve.gov/econresdata/scf/files/scf1989s.zip


***LINK TO PUBLIC BULLETIN datasets HERE
local scfpb2013 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp2013.dta"
local scfpb2010 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp2010.dta"
local scfpb2007 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp2007.dta"
local scfpb2004 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp2004.dta"
local scfpb2001 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp2001.dta"
local scfpb1998 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp1998.dta"
local scfpb1995 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp1995.dta"
local scfpb1992 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp1992.dta"
local scfpb1989 "/lcl/mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfp1989.dta"


use `scf1989', clear
ren x1 y1
tempfile scf1989
save `scf1989', replace

use `scfpb1989', clear
ren x1 y1
tempfile scfpb1989
save `scfpb1989',replace

capture log close
log using /lcl/mecs/scf7/research/scf.soi.compare/pgm/files.for.bpea/topshares.public.log, replace

global years="1989 1992 1995 1998 2001 2004 2007 2010 2013"
local numyears=9


foreach year of numlist $years {
use `scf`year'', clear 
ren *, lower
keep x* y1
gen year=`year'
sort y1
merge 1:1 y1 using `scfpb`year''
drop if _merge!=3

gen cpi=1
gen cpi_wealth=1
tempfile scf`year'
save `scf`year''

replace cpi=(1902/1902)*(1886/1808) if year==1989
replace cpi=(2116/2116)*(2103/2051) if year==1992
replace cpi=(2265/2265)*(2254/2201) if year==1995
replace cpi=(2405/2405)*(2397/2364) if year==1998
replace cpi=(2618/2618)*(2600/2529) if year==2001
replace cpi=(2788/2788)*(2774/2701) if year==2004
replace cpi=(3062/3062)*(3045/2961) if year==2007
replace cpi=(3208/3208)*(3202/3150) if year==2010
replace cpi=(3438/3438)*(3421/3372) if year==2013

gen corpinc=max(0,x3410*cpi)+max(0,x3414*cpi)+max(0,x3418*cpi)

* A. Corporate equities (excluding pensions)
* dividend income
gen divinc=x5710*cpi
* capital gains, kginc already exists
* equity wealth sum of direct stock holdings + mutual funds stock holdings
gen kgdivinc=max(-3000,kginc)+divinc
gen divinc_wscf=stocks+stmutf+.5*comutf
gen kgdivinc_wscf=stocks+stmutf+.5*comutf

* B. Fixed claim assets
* non-taxable bonds (munis)
gen intexm=x5706*cpi
gen intexm_wscf=notxbnd+tfbmutf

* taxable fixed claim assets
gen intinc=x5708*cpi
gen intinc_wscf=liq+cds+savbnd+bond-notxbnd+nmmf-stmutf-tfbmutf-.5*comutf

* C. Unincorporated businesses
* aggregates schedC+farm+schedE (schedE=rental, partnership, S-corp, royalties)
**instead of maxing bussefarminc -- max the two components separately. 
gen businc=max(0,x5704*cpi)+max(0,x5714*cpi)
gen businc_wscf=bus+othfin+nnresre

* D. Pension income
* ssretinc also includes social security so need to calculate social security income ssinc to subtract it
* ssinc is reported either monthly or annually so need to calculate this
gen ssinc=0
replace ssinc=ssinc+x5306*cpi if x5307==6
replace ssinc=ssinc+12*x5306*cpi if x5307==4
replace ssinc=ssinc+x5311*cpi if x5312==6
replace ssinc=ssinc+12*x5311*cpi if x5312==4
gen peninc= max(0,ssretinc-ssinc)
* peninc includes IRAs, 401(k) distributions and annuities from DBs
gen penincdb=max(0,peninc-penacctwd)
* penincdb should be DB pension income

* real estate taxes on owner occupied housing (need to adjust for periodicity)
gen realestatetax=x721*cpi
replace realestatetax=12*realestatetax if x722==4
replace realestatetax=4*realestatetax if x722==5
replace realestatetax=2*realestatetax if x722==11
replace realestatetax=max(0,realestatetax)

* mortgage payments per month variable is mortpay, create annualized variable
replace mortpay=12*mortpay

* generating total income variable totinc consistent with Piketty-Saez income definition (i.e. excluding SS and govt transfers and non-taxable interest)
gen othinc=x5724*cpi

gen capinc=max(0,businc)+intinc+divinc+max(-3000,kginc)
gen capinc_alt=max(0,businc)+intinc+divinc
gen capinc_wscf=kgdivinc_wscf+businc_wscf+intinc_wscf+0*intexm_wscf 

gen totinc=wageinc+capinc+peninc+othinc+penacctwd
gen totinc_alt=totinc-max(0,kginc)

gen kgdivbusinc=kgdivinc+businc 
gen inttotinc=intinc+intexm 
gen kgdivbusinc_wscf=kgdivinc_wscf+businc_wscf
gen inttotinc_wscf=intinc_wscf+intexm_wscf 

gen fixinc_tax=intinc
gen fixinc_tot=intinc+intexm

/*ALLOCATE MEDICARE TO HOUSEHOLDS*/
gen medicare_total=0
replace medicare_total=	86.3 	if year==	1989
replace medicare_total=	117.5	if year==	1992
replace medicare_total=	164.4	if year==	1995
replace medicare_total=	206.9	if year==	1998
replace medicare_total=	219.1	if year==	2001
replace medicare_total=	276.7	if year==	2004
replace medicare_total=	399.2	if year==	2007
replace medicare_total=	494.6	if year==	2010
replace medicare_total=	556.3	if year==	2013

*household count of 65+
if `year' >= 1995 & `year' <= 2004 {
g x228 = .
}
g tot65pl = 0
foreach var in x8022 x104 x110 x116 x122 x128 x134 x204 x210 x216 x222 x228 {
qui replace tot65pl = tot65pl + (`var' >= 65)
}

qui sum tot65pl [aw=wgt], detail
g tot65pl_agg = r(sum) 
g medicare_share = tot65pl/tot65pl_agg
g medicare = medicare_share*medicare_total*1E9

/*ALLOCATE EPHI*/
gen ephi_total=0
replace ephi_total=	151.5 	if year==	1989
replace ephi_total=	203.4	if year==	1992
replace ephi_total=	258.4	if year==	1995
replace ephi_total=	262.3	if year==	1998
replace ephi_total=	344.5	if year==	2001
replace ephi_total=	436.3	if year==	2004
replace ephi_total=	518.7	if year==	2007
replace ephi_total=	570.2	if year==	2010
replace ephi_total=	616.5	if year==	2013

*PEU with EPHI
*PEU with coverage outside R/SP

g ephi = 0
if `year' <= 2007 {
foreach var in x6317 x6316 x6319 x6320 {
qui replace ephi = 1 if `var' == 1
}
if `year' <= 1992 {
qui replace ephi = 1 if x6323 ==2 | x6323 == 3
}
if `year' > 1992 {
qui replace ephi = 1 if x6323 ==12 | x6323 == 14
}
}
if `year' > 2007 {
qui replace ephi = 1 if x6347 == 1 | x6350 == 13
}

*count of those without coverage
g notcov_hh = 0
if `year' <= 2007 {
foreach var in x6330 x6331 x6332 x6333 x6334 x6335 {
replace notcov_hh = notcov_hh + (`var' == 1)
}
replace notcov_hh = notcov_hh + (x6336 >= 8)
}
if `year' > 2007 {
foreach var in x6358 x6359 x6360 x6361 x6362 {
replace notcov_hh = notcov_hh + (`var' == 1)
}
replace notcov_hh = notcov_hh + (x6363 >= 8)
}

g totcov = x101 - notcov_hh
g ephi_hhtot = totcov*ephi
qui sum ephi_hhtot [aw=wgt], detail
g ephi_agg = r(sum) 
g ephi_share = ephi_hhtot/ephi_agg
g ephi_amt = ephi_total*ephi_share*1E9
g income_plHI = income + medicare + ephi_amt

*Forbes income estimate
g forbes_inc = 10280000000 	if year == 	1989
qui replace forbes_inc = 10770000000 	if year == 	1992
qui replace forbes_inc = 10090000000 	if year == 	1995
qui replace forbes_inc = 24240000000 	if year == 	1998
qui replace forbes_inc = 23940000000 	if year == 	2001
qui replace forbes_inc = 29540000000 	if year == 	2004
qui replace forbes_inc = 59400000000 	if year == 	2007
qui replace forbes_inc = 45710000000 	if year == 	2010
qui replace forbes_inc = 69600000000 	if year == 	2013
						   
qui g medicaid = .						   
qui replace	medicaid = 	102.1		if year == 	1992	   
qui replace	medicaid = 	144.9		if year == 	1995	   
qui replace	medicaid = 	168.3		if year == 	1998	   
qui replace	medicaid = 	205		if year == 	2001	   
qui replace	medicaid = 	274		if year == 	2004	   
qui replace	medicaid = 	311.2		if year == 	2007	   
qui replace	medicaid = 	383.5		if year == 	2010	   
qui replace	medicaid = 	431.3		if year == 	2013	 
 qui g foodstamps = .
qui replace	foodstamps=	32.2	if year == 	1989	   
qui replace	foodstamps=	48.1	if year == 	1992	   
qui replace	foodstamps=	63.8	if year == 	1995	   
qui replace	foodstamps=	75.9	if year == 	1998	   
qui replace	foodstamps=	81.1	if year == 	2001	   
qui replace	foodstamps=	111.4	if year == 	2004	   
qui replace	foodstamps=	140.4	if year == 	2007	   
qui replace	foodstamps=	232.7	if year == 	2010	   
qui replace	foodstamps=	259.8	if year == 	2013	 


** scf income w/o losses - no loss market income+socsec+tax exempt bonds + gov't transfers (other inc already in totinc) 
gen SCFinc_noloss=totinc+ssinc+intexm+(transfothinc-othinc)
**
gen totinc_loss=wageinc+(x5704*cpi)+(x5714*cpi)+intinc+divinc+kginc+peninc+othinc
gen capinc_loss=(x5704*cpi)+(x5714*cpi)+intinc+divinc+kginc

gen totinc_nokg=totinc_alt
gen totinc_loss_nokg=totinc_loss-kginc
gen SCFinc_noloss_nokg=SCFinc_noloss-max(-3000, kginc)
gen capinc_nokg=capinc-max(-3000, kginc)
gen capinc_loss_nokg=capinc_loss-max(-3000,kginc)
gen SCFinc_nokg=income-kginc-max(-3000,kginc)

//SCF versions of Piketty-Saez Income 
//SCFps1 
*SCFps1 - take bulletin income and subtract what we don't want
gen SCFps1=income-intexm-(transfothinc-othinc)-ssinc
replace SCFps1=0 if SCFps1<0
g SCFps1_nom = SCFps1/cpi
//gen SCFps1=wageinc+businc+intinc+divinc+max(-3000,kginc)+peninc+othinc
//SCFps2 bulletin income subtract what we don't want -- add in losses to business 
gen SCFps2=income-intexm-(transfothinc-othinc)-ssinc-min(bussefarminc, 0)-min(kginc,0)
replace SCFps2=SCFps2-3000 if kginc<-3000
replace SCFps2=0 if SCFps2<0
g SCFps2_nom = SCFps2/cpi
**FOR LEVELS -- we need to adjust back to syear-1 dollars!!!
foreach x in income wageinc bussefarminc intdivinc kginc ssretinc transfothinc  norminc equitinc corpinc divinc kgdivinc intinc businc ssinc peninc penacctwd penincdb othinc capinc capinc_alt totinc totinc_alt inttotinc SCFinc_noloss totinc_loss capinc_loss    SCFps1 SCFps2 fixinc_tax fixinc_tot income_plHI { 
replace `x'=`x'/cpi
}


///WEALTH

**matched to SZ - FA from 2014 
gen oore_scalar=	0		
replace oore_scalar=	1.125089147	if year==	1989
replace oore_scalar=	1.048102530	if year==	1992
replace oore_scalar=	1.043916784	if year==	1995
replace oore_scalar=	1.166994186	if year==	1998
replace oore_scalar=	1.143478570	if year==	2001
replace oore_scalar=	1.263815760	if year==	2004
replace oore_scalar=	1.242931763	if year==	2007
replace oore_scalar=	1.417706872	if year==	2010
replace oore_scalar=	1.360190555	if year==	2013
	
///nonoore_scalar w/o DB wealth	
gen nonoore_scalar=	0		
replace nonoore_scalar=	1.0386880	if year==	1989
replace nonoore_scalar=	0.9486929	if year==	1992
replace nonoore_scalar=	0.9275037	if year==	1995
replace nonoore_scalar=	0.9458698	if year==	1998
replace nonoore_scalar=	1.2456892	if year==	2001
replace nonoore_scalar=	1.2137120	if year==	2004
replace nonoore_scalar=	1.1353858	if year==	2007
replace nonoore_scalar=	1.1951133	if year==	2010
replace nonoore_scalar=	1.0929988	if year==	2013

gen liabilities_scalar=	0		
replace liabilities_scalar=	0.8287359	if year==	1989
replace liabilities_scalar=	0.8432290	if year==	1992
replace liabilities_scalar=	0.8271467	if year==	1995
replace liabilities_scalar=	0.9019867	if year==	1998
replace liabilities_scalar=	0.8513719	if year==	2001
replace liabilities_scalar=	0.9490476	if year==	2004
replace liabilities_scalar=	0.8867961	if year==	2007
replace liabilities_scalar=	0.8920087	if year==	2010
replace liabilities_scalar=	0.8933100	if year==	2013

//Create mortgage scalar for net housing portion of decomposition
gen mortgage_scalar=0
replace mortgage_scalar=	0.884694272	if year==	1989
replace mortgage_scalar=	0.919063608	if year==	1992
replace mortgage_scalar=	0.907792203	if year==	1995
replace mortgage_scalar=	0.996864232	if year==	1998
replace mortgage_scalar=	0.963344189	if year==	2001
replace mortgage_scalar=	1.046260089	if year==	2004
replace mortgage_scalar=	0.944264582	if year==	2007
replace mortgage_scalar=	0.940078767	if year==	2010
replace mortgage_scalar=	0.978462133	if year==	2013

gen debt_lessodebt=debt-odebt
/*------------
Liabilities rescale
--------------*/
**rentals
if `year'<=2007{
gen rental_properties1=0
replace rental_properties1=x1706*(x1705/10000) if inlist(x1703, 12, 14, 21, 22, 40, 41, 42, 43, 44, 49, 50, 52, 999)
replace rental_properties1=0 if x1729!=1
gen rental_properties2=0
replace rental_properties2=x1806*(x1805/10000) if inlist(x1803, 12, 14, 21, 22, 40, 41, 42, 43, 44, 49, 50, 52, 999)
replace rental_properties2=0 if x1829!=1
gen rental_properties3=0
replace rental_properties3=x1906*(x1905/10000) if inlist(x1903, 12, 14, 21, 22, 40, 41, 42, 43, 44, 49, 50, 52, 999)
replace rental_properties3=0 if x1929!=1
gen rental_properties_more=0
replace rental_properties_more=max(0, x2002) if x2009==1 
}
if `year'>=2010{
gen rental_properties1=0
replace rental_properties1=x1706*(x1705/10000) if inlist(x1703, 12, 14, 21, 22, 40, 41, 42, 43, 44, 49, 50, 52, 999)
replace rental_properties1=0 if x1729!=1
gen rental_properties2=0
replace rental_properties2=x1806*(x1805/10000) if inlist(x1803, 12, 14, 21, 22, 40, 41, 42, 43, 44, 49, 50, 52, 999)
replace rental_properties2=0 if x1829!=1
gen rental_properties3=0
gen rental_properties_more=0
replace rental_properties_more=max(0, x2002) if x2009==1 
}

gen rentals=0
replace rentals=rental_properties1 + rental_properties2 + rental_properties3 + rental_properties_more

** move rentals from oresre to nnresre
gen nonrental_oresre=oresre-rentals
gen nnresre_plus_rentals=nnresre+rentals

/*ALLOCATE DB PENSION WEALTH*/
g cpilag =.
gen curr_db_agg=0
gen fut_db_agg=0

foreach num in 1 2 3 4 5 6 {
foreach x in r sp{
gen fut_pen_`x'`num'=0
gen curr_jobpen_`x'`num'=0
}
}

*This is to bring each x4112 and x4712 number in line with the FA Q aggregates, which in this case is Q1 of the survey year
replace cpilag=(1886/1808) if year==1989
replace cpilag=(2103/2051) if year==1992
replace cpilag=(2254/2201) if year==1995
replace cpilag=(2397/2364) if year==1998
replace cpilag=(2600/2529) if year==2001
replace cpilag=(2774/2701) if year==2004
replace cpilag=(3045/2961) if year==2007
replace cpilag=(3202/3150) if year==2010
replace cpilag=(3421/3372) if year==2013

foreach x in r sp {
forval n = 1/6 {
qui g curr_recdb_`x'`n' = 0
}
}
if `year' >= 2001 {
qui replace curr_recdb_r1= 1 if x5315==1 & x6461==5 
qui replace curr_recdb_r2= 1 if x5323==1 & x6466==5 
qui replace curr_recdb_r3= 1 if x5331==1 & x6471==5 
qui replace curr_recdb_r4= 1 if x5415==1 & x6476==5 
qui replace curr_recdb_sp1= 1 if x5315==2 & x6461==5 
qui replace curr_recdb_sp2= 1 if x5323==2 & x6466==5 
qui replace curr_recdb_sp3= 1 if x5331==2 & x6471==5 
qui replace curr_recdb_sp4= 1 if x5415==2 & x6476==5 
if `year' < 2010 {
replace curr_recdb_r5= x5423==1 & x6481==5 
replace curr_recdb_r6= x5431==1 & x6486==5 
replace curr_recdb_sp5= x5423==2 & x6481==5 
replace curr_recdb_sp6= x5431==2 & x6486==5 
}
}
if `year' <= 1998 {
qui replace curr_recdb_r1 = 1 if x5315==1 & inlist(x5319,1,2,3,4,5,6,11,12,31,18)
qui replace curr_recdb_r2= 1 if x5323==1 & inlist(x5327,1,2,3,4,5,6,11,12,31,18) 
qui replace curr_recdb_r3= 1 if x5331==1 & inlist(x5335,1,2,3,4,5,6,11,12,31,18) 
qui replace curr_recdb_r4= 1 if x5415==1 & inlist(x5419,1,2,3,4,5,6,11,12,31,18) 
qui replace curr_recdb_sp1= 1 if x5315==2 & inlist(x5319,1,2,3,4,5,6,11,12,31,18)
qui replace curr_recdb_sp2= 1 if x5323==2 & inlist(x5327,1,2,3,4,5,6,11,12,31,18)
qui replace curr_recdb_sp3= 1 if x5331==2 & inlist(x5335,1,2,3,4,5,6,11,12,31,18)
qui replace curr_recdb_sp4= 1 if x5415==2 & inlist(x5419,1,2,3,4,5,6,11,12,31,18)
replace curr_recdb_r5= x5423==1 & inlist(x5427,1,2,3,4,5,6,11,12,31,18) 
replace curr_recdb_r6= x5431==1 & inlist(x5435,1,2,3,4,5,6,11,12,31,18) 
replace curr_recdb_sp5= x5423==2 & inlist(x5427,1,2,3,4,5,6,11,12,31,18) 
replace curr_recdb_sp6= x5431==2 & inlist(x5435,1,2,3,4,5,6,11,12,31,18) 
}


//this is same old code from scf.soi compare stuff just tweaked to better work on our data
if `year' >= 2010 {
replace fut_pen_r1=1 if x5606==1 & inlist(x5603, 1, 3) 
replace fut_pen_r2=1 if x5614==1 & inlist(x5611, 1, 3) 
replace fut_pen_r3=1 if x5622==1 & inlist(x5619, 1 ,3) 
replace fut_pen_r4=1 if x5630==1 & inlist(x5627, 1, 3) 

replace fut_pen_sp1=1 if x5606==2 & inlist(x5603, 1, 3) 
replace fut_pen_sp2=1 if x5614==2 & inlist(x5611, 1, 3) 
replace fut_pen_sp3=1 if x5622==2 & inlist(x5619, 1 ,3) 
replace fut_pen_sp4=1 if x5630==2 & inlist(x5627, 1, 3) 

replace curr_jobpen_r1=1 if x11001==1 
replace curr_jobpen_r2=1 if x11101==1 

replace curr_jobpen_sp1=1 if x11301==1 
replace curr_jobpen_sp2=1 if x11401==1 
}

if `year' >= 2004 & `year' <= 2007 {
replace fut_pen_r1=1 if x5606==1 & inlist(x5603, 1, 3) 
replace fut_pen_r2=1 if x5614==1 & inlist(x5611, 1, 3) 
replace fut_pen_r3=1 if x5622==1 & inlist(x5619, 1 ,3) 
replace fut_pen_r4=1 if x5630==1 & inlist(x5627, 1, 3) 
replace fut_pen_r5=1 if x5638==1 & inlist(x5635, 1, 3) 
replace fut_pen_r6=1 if x5646==1 & inlist(x5643, 1, 3) 
replace fut_pen_sp1=1 if x5606==2 & inlist(x5603, 1, 3) 
replace fut_pen_sp2=1 if x5614==2 & inlist(x5611, 1, 3) 
replace fut_pen_sp3=1 if x5622==2 & inlist(x5619, 1 ,3) 
replace fut_pen_sp4=1 if x5630==2 & inlist(x5627, 1, 3) 
replace fut_pen_sp5=1 if x5638==2 & inlist(x5635, 1, 3) 
replace fut_pen_sp6=1 if x5646==2 & inlist(x5643, 1, 3) 

replace curr_jobpen_r1=1 if x11001==1 
replace curr_jobpen_r2=1 if x11101==1 
replace curr_jobpen_r3=1 if x11201==1 
replace curr_jobpen_sp1=1 if x11301==1 
replace curr_jobpen_sp2=1 if x11401==1 
replace curr_jobpen_sp3=1 if x11521==1 
}

//the next following blocks can be combined
if `year' == 2001 {
replace fut_pen_r1=1 if x5606==1 & inlist(x5603, 1, 3) & year==2001
replace fut_pen_r2=1 if x5614==1 & inlist(x5611, 1, 3) & year==2001
replace fut_pen_r3=1 if x5622==1 & inlist(x5619, 1 ,3) & year==2001
replace fut_pen_r4=1 if x5630==1 & inlist(x5627, 1, 3) & year==2001
replace fut_pen_r5=1 if x5638==1 & inlist(x5635, 1, 3) & year==2001
replace fut_pen_r6=1 if x5646==1 & inlist(x5643, 1, 3) & year==2001

replace fut_pen_sp1=1 if x5606==2 & inlist(x5603, 1, 3) & year==2001
replace fut_pen_sp2=1 if x5614==2 & inlist(x5611, 1, 3) & year==2001
replace fut_pen_sp3=1 if x5622==2 & inlist(x5619, 1 ,3) & year==2001
replace fut_pen_sp4=1 if x5630==2 & inlist(x5627, 1, 3) & year==2001
replace fut_pen_sp5=1 if x5638==2 & inlist(x5635, 1, 3) & year==2001
replace fut_pen_sp6=1 if x5646==2 & inlist(x5643, 1, 3) & year==2001

replace curr_jobpen_r1=1 if x4202==1 & x4203==1 & year==2001
replace curr_jobpen_r2=1 if x4302==1 & x4303==1 & year==2001
replace curr_jobpen_r3=1 if x4402==1 & x4403==1 & year==2001
replace curr_jobpen_sp1=1 if x4802==1 & x4803==1 & year==2001
replace curr_jobpen_sp2=1 if x4902==1 & x4903==1 & year==2001
replace curr_jobpen_sp3=1 if x5002==1 & x5003==1 & year==2001
}

if `year' <= 1998 {
replace fut_pen_r1=1 if x5606==1 & inlist(x5603, 1, 3) & year<=1998 
replace fut_pen_r2=1 if x5614==1 & inlist(x5611, 1, 3) & year<=1998 
replace fut_pen_r3=1 if x5622==1 & inlist(x5619, 1 ,3) & year<=1998 
replace fut_pen_r4=1 if x5630==1 & inlist(x5627, 1, 3) & year<=1998 
replace fut_pen_r5=1 if x5638==1 & inlist(x5635, 1, 3) & year<=1998 
replace fut_pen_r6=1 if x5646==1 & inlist(x5643, 1, 3) & year<=1998 
replace fut_pen_sp1=1 if x5606==2 & inlist(x5603, 1, 3) & year<=1998 
replace fut_pen_sp2=1 if x5614==2 & inlist(x5611, 1, 3) & year<=1998 
replace fut_pen_sp3=1 if x5622==2 & inlist(x5619, 1 ,3) & year<=1998 
replace fut_pen_sp4=1 if x5630==2 & inlist(x5627, 1, 3) & year<=1998 
replace fut_pen_sp5=1 if x5638==2 & inlist(x5635, 1, 3) & year<=1998 
replace fut_pen_sp6=1 if x5646==2 & inlist(x5643, 1, 3) & year<=1998 
replace curr_jobpen_r1=1 if x4202==1 & x4203==1 & year<=1998 
replace curr_jobpen_r2=1 if x4302==1 & x4303==1 & year<=1998 
replace curr_jobpen_r3=1 if x4402==1 & x4403==1 & year<=1998 
replace curr_jobpen_sp1=1 if x4802==1 & x4803==1 & year<=1998 
replace curr_jobpen_sp2=1 if x4902==1 & x4903==1 & year<=1998 
}
foreach x in r sp{
foreach y in curr_recdb_ fut_pen_ curr_jobpen_{
gen `y'`x'tot=`y'`x'1 + `y'`x'2 + `y'`x'3 + `y'`x'4 + `y'`x'5 +`y'`x'6
**Cap at 1 per person
replace `y'`x'tot=1 if `y'`x'tot>=1
}
}


mconv x5318 x5319 db1
mconv x5326 x5327 db2
mconv x5334 x5335 db3
mconv x5418 x5419 db4
if `year' < 2010 {
mconv x5426 x5427 db5 
mconv x5434 x5435 db6 
}
if `year' >= 2010 {
g db5= 0 
g db6=0 
}
//Convert these dollar amounts to yearly dollars
foreach x in 1 2 3 4 5 6{
replace db`x'=db`x'*12
}

//assign these values to the r or sp as necessary
foreach x in 1 2 3 4 5 6{
foreach y in r sp{
gen dbamt_`y'`x'=0
replace dbamt_`y'`x'=db`x' if curr_recdb_`y'`x'==1
}
}

*Calculate total db bens+future db bens
egen dbamt_rtot=rowtotal(dbamt_r1 dbamt_r2 dbamt_r3 dbamt_r4 dbamt_r5 dbamt_r6)
egen dbamt_sptot=rowtotal(dbamt_sp1 dbamt_sp2 dbamt_sp3 dbamt_sp4 dbamt_sp5 dbamt_sp6)

g r = 0
*replace r = .05
replace r = .03
*replace r = .01
g rage = x14
g spage = x19
g rsex = x8021
g spsex = x103

//merge on life tables for each survey year (some years have identical life tables)
merge m:1 year using $filepath/doc/Retirement_Wealth_Inequality/ltabfull.dta, nogen

//assign starting survival years for both current bens and future bens to r/sp based on reported sex
foreach x in numlivescurr{
foreach y in r sp {
g `y'`x' = .
}
}

foreach x in r sp{
forval i = 1(1)119{
qui g `x'numlives`i' = numlivesmale`i' if `x'sex==1
qui replace `x'numlives`i' = numlivesfemale`i' if `x'sex==2

qui replace `x'numlivescurr =  numlivesmale`i' if (`x'age==`i' & `x'sex==1) 
qui replace `x'numlivescurr = numlivesfemale`i' if (`x'age==`i' & `x'sex==2)
}
}

*drop numlivesmale* numlivesfemale*

//compute survival probabilities based on starting age/future bens age
foreach x in r sp {
forval i = 1(1)119{
qui g `x'_currsurvprop_`i' = `x'numlives`i'/`x'numlivescurr if `i'>=`x'age
}
}

//compute survival-adjusted PV of current and future benefits for r and sp
//added the capped future benefits as described above
foreach x in r sp{
forval i = 1(1)119{
qui g benfact`x'`i' = (1/((1+r)^(`i'-`x'age)))*`x'_currsurvprop_`i' if `i'>=`x'age & `x'age!=0
}
qui egen benfact`x'sum = rowtotal(benfact`x'*)
qui g `x'benfact = benfact`x'sum 
qui g pv_dbamt_`x'tot = dbamt_`x'tot*`x'benfact if dbamt_`x'tot >0

}

egen pv_dbamt_hhtot = rowtotal(pv_dbamt_rtot pv_dbamt_sptot)
qui g curr_recdb_hhtot = pv_dbamt_hhtot
qui g db_wealth_curr = curr_recdb_hhtot

merge m:1 year using $filepath/doc/Retirement_Wealth_Inequality/fa_aggs.dta, nogen
rename fa_db_agg FA_db_agg

///calculate residual DB wealth for late CJ DB wealth allocation
g long FA_cj_residual = 0
g long pv_dbamt_agg = 0
format FA_db_agg FA_cj_residual pv_dbamt_agg pv_dbamt_hhtot %16.0g

summ pv_dbamt_hhtot [aw=wgt], format
replace pv_dbamt_agg = r(sum) 

replace FA_cj_residual = FA_db_agg - pv_dbamt_agg 

**"Future DB" Benefits are now redefined as cj_benefits to reduce confusion, complete calculations for those with cj pens first
/////Likely making changes to this stuff
*Create new var that can be tweaked and then summed
gen cj_db_rtot=curr_jobpen_rtot
gen cj_db_sptot=curr_jobpen_sptot
*Cap at 1 (again?)
replace cj_db_rtot=1 if cj_db_rtot>=1
replace cj_db_sptot=1 if cj_db_sptot>=1
*Create HH Total and then cap at 2 (needed to compute overall statistics)
gen cj_db_hhtot=cj_db_rtot+cj_db_sptot
replace cj_db_hhtot=2 if cj_db_hhtot>=2
//Calculate wages for people who will receive db pens in future
//Survey year dollars
gen cj_db_rwages=0
gen cj_db_spwages=0
replace cj_db_rwages=(max(0,x4112))*cpilag if cj_db_rtot==1
replace cj_db_spwages=(max(0,x4712))*cpilag if cj_db_sptot==1
//now assign wages from past job for those who report a future db benefit but no cj benefits
replace cj_db_rwages=(max(0,x4520))*cpilag if fut_pen_rtot>0 & cj_db_rwages==0
replace cj_db_spwages=(max(0,x5120))*cpilag if fut_pen_sptot>0 & cj_db_spwages==0

gen cj_db_totwages=cj_db_rwages+cj_db_spwages

*set number of years in DB plan
foreach x in r_ sp_ {
g `x'yearsatdbpj = 0
forval y = 1/3 {
g `x'yearsinpen`y' = 0
}
}
*defined as either number of years in db plan, or number of years on current job (if year==1989)
if `year' == 1989 {
replace r_yearsinpen1 = x4115 if curr_jobpen_r1==1 & year==1989 
replace r_yearsinpen2 = x4115 if curr_jobpen_r2==1 & year==1989 
replace r_yearsinpen3 = x4115 if curr_jobpen_r3==1 & year==1989 
replace sp_yearsinpen1 = x4715 if curr_jobpen_sp1==1 & year==1989 
replace sp_yearsinpen2 = x4715 if curr_jobpen_sp2==1 & year==1989 
replace sp_yearsinpen3 = x4715 if curr_jobpen_sp3==1 & year==1989 
}
if `year' > 1989 & `year' <= 2001 {
replace r_yearsinpen1 = x7685 if curr_jobpen_r1==1 & year>1989 & year<=2001
replace r_yearsinpen2 = x7687 if curr_jobpen_r2==1 & year>1989 & year<=2001
replace r_yearsinpen3 = x7689 if curr_jobpen_r3==1 & year>1989 & year<=2001
replace sp_yearsinpen1 = x7712 if curr_jobpen_sp1==1 & year>1989 & year<=2001 
replace sp_yearsinpen2 = x7714 if curr_jobpen_sp2==1 & year>1989 & year<=2001  
replace sp_yearsinpen3 = x7716 if curr_jobpen_sp3==1 & year>1989 & year<=2001
}
if `year' >= 2004 {
replace r_yearsinpen1 = x11002 if curr_jobpen_r1==1 & year>=2004 
replace r_yearsinpen2 = x11102 if curr_jobpen_r2==1 & year>=2004
replace sp_yearsinpen1 = x11302 if curr_jobpen_sp1==1 & year>=2004
replace sp_yearsinpen2 = x11402 if curr_jobpen_sp2==1 & year>=2004

if `year' < 2010 {
replace r_yearsinpen3 = x11202 if curr_jobpen_r3==1 & year>=2004 & year<2010
replace sp_yearsinpen3 = x11502 if curr_jobpen_sp3==1 & year>=2004 & year<2010
}
}
//allocate years at longest prior job to estimate "future benefits"
replace r_yearsatdbpj = (x4519-x4518) if fut_pen_rtot>0 & x4519>x4518
replace sp_yearsatdbpj = (x5119-x5118) if fut_pen_sptot>0 & x5119>=x5118
//Round up for those with less than one year on the job
replace r_yearsatdbpj = 1 if fut_pen_rtot>0 & (x4519==x4518) & (x4519>0 & x4518>0)
replace sp_yearsatdbpj = 1 if fut_pen_rtot>0 & (x5119==x5118) & (x5119>0 & x5118>0)

//allocate years to each r/ sp. Round up for those with less than one year (-1) in current pension systme
foreach x in r_ sp_ {
forval y = 1/3 {
replace `x'yearsinpen`y' = 1 if `x'yearsinpen`y'==-1
} 
egen `x'yearsincjdb = rowmax(`x'yearsinpen1 `x'yearsinpen2 `x'yearsinpen3)
g `x'totyears = `x'yearsincjdb + `x'yearsatdbpj
}

*now weight up appropriate wages to scale for number of years in plan
foreach x in r sp {
g cj_db_`x'_wgtwages = cj_db_`x'wages*`x'_totyears 
replace cj_db_`x'_wgtwages =  cj_db_`x'_wgtwages*(1/((1+r)^(60-`x'age))) if `x'age<60
}

*total at HH level
egen cj_db_hh_wgtwages = rowtotal(cj_db_r_wgtwages cj_db_sp_wgtwages)
egen totaldbyears = rowtotal(r_totyears sp_totyears)


g cj_db_r_wgtwageshare = 0
g cj_db_sp_wgtwageshare = 0
g cj_db_r_wealth = .
g cj_db_sp_wealth = .
g cj_db_wgtwages_agg = 0

format cj_db_wgtwages_agg  %16.0g
format cj_db_r_wgtwageshare cj_db_sp_wgtwageshare %9.8f

///allocate wages based on share of total * by FA residual
summ cj_db_hh_wgtwages  [aw=wgt], detail
replace cj_db_wgtwages_agg = r(sum) 
foreach y in r sp {
replace cj_db_`y'_wgtwageshare = cj_db_`y'_wgtwages/r(sum) 
replace cj_db_`y'_wealth = cj_db_`y'_wgtwageshare*FA_cj_residual 
}


egen cj_db_hh_wealth =rowtotal(cj_db_r_wealth cj_db_sp_wealth)
g db_wealth_fut = cj_db_hh_wealth
egen db_wealth = rowtotal(pv_dbamt_hhtot cj_db_hh_wealth)


foreach x in db_wealth pv_dbamt_hhtot cj_db_hh_wealth {
g `x'_real=.
}

foreach x in db_wealth pv_dbamt_hhtot cj_db_hh_wealth {
replace `x'_real=`x'*cpi
}


g pen_wealth = retqliq+db_wealth_real
g nopensnw = networth-retqliq
g pensnw = networth+db_wealth_real

gen pen_wealth_rescale=db_wealth_real + retqliq/(nonoore_scalar)

gen oore=houses+nonrental_oresre
gen nonhousenonfin=bus+nnresre_plus_rentals
gen fin_assets_ffa=liq+cds+bond+savbnd+stocks+nmmf+othma+retqliq
gen nonoore=nonhousenonfin+fin_assets
gen fin_assets_check=fin-othfin-cashli
gen liabilities=mrthel+resdbt+install+ccbal+othloc
gen liabilities_check=debt-odebt

gen networth_ffa_db=oore+nonhousenonfin+fin_assets_ffa-liabilities+db_wealth
g networth_db = networth + db_wealth

gen oore_db=oore
gen nonoore_db=nonoore+db_wealth
gen liabilities_db=liabilities

// Create Rescaled OORE, NONOORE, and LIABILITIES to create rescaled networth
gen oore_db_rescale=oore/oore_scalar
gen nonoore_db_rescale=nonoore/nonoore_scalar+db_wealth
gen liabilities_db_rescale=liabilities_db/(liabilities_scalar)
gen nw_ffa_db_rescale=oore_db_rescale+nonoore_db_rescale-liabilities_db_rescale

gen mort_rescale=(mrthel+resdbt)/(liabilities_scalar)
gen nethouse_rescale=oore_db_rescale-mort_rescale

gen nonmortdebt=liabilities-mrthel-resdbt
gen nonmortdebt_rescale=nonmortdebt/(liabilities_scalar)

/*------------------
Decomposing nonhousing assets for wealth composition comparison

	- fixed income
	- equities
	- pensions (already done above)
	- business
--------------------------*/
**create variable for total mutual funds and trusts
** we'll divide this into equity and fixed income portions
gen mut_othma=nmmf+othma
gen nmmf_equity= stmutf+(0.5*comutf)
gen nmmf_fixed=nmmf-nmmf_eq

*gen othma_equity=equity-deq-reteq-saveq
gen othma_equity=equity-deq-reteq
gen othma_fixed=othma-othma_eq

/* ----- 
for s and c corp equity 
--- to be added to directly held equity
sc_corp_value will be subtracted from non_corp_equity
let sc_corp_equity= sc_corp_value + sc_corp_stocks

-------------*/

gen sc_corp_equity=0
gen sc_corp_value=0
gen sc_corp_stocks=0

if `year'<2010 {
replace sc_corp_value= max(0,x3129) if x3119==3 | x3119==4 
replace sc_corp_value=sc_corp_value + max(0, x3229) if x3219==3 | x3219==4 
replace sc_corp_value=sc_corp_value + max(0, x3329) if x3319==3 | x3319==4 
replace sc_corp_value=sc_corp_value + max(0, x3417) + max(0,x3421)
replace sc_corp_stocks=x4022 if x4020==73 | x4020==74 
replace sc_corp_stocks=sc_corp_stocks + x4026 if x4024==73 | x4024==74 
replace sc_corp_stocks=sc_corp_stocks + x4030 if x4028==73 | x4028==74

replace sc_corp_equity=sc_corp_stocks + sc_corp_value
replace sc_corp_equity=0 if sc_corp_equity<0
}

if `year'>=2010{
replace sc_corp_value= max(0,x3129) if x3119==3 | x3119==4 
replace sc_corp_value=sc_corp_value + max(0, x3229) if x3219==3 | x3219==4 
replace sc_corp_value=sc_corp_value + max(0, x3417) + max(0,x3421)
replace sc_corp_stocks=x4022 if x4020==73 | x4020==74 
replace sc_corp_stocks=sc_corp_stocks + x4026 if x4024==73 | x4024==74 
replace sc_corp_stocks=sc_corp_stocks + x4030 if x4028==73 | x4028==74

replace sc_corp_equity=sc_corp_stocks + sc_corp_value
replace sc_corp_equity=0 if sc_corp_equity<0
}

gen bus_assets=bus+nnresre_plus_rentals-sc_corp_equity
**move mmmf from liq to equity
gen equity_assets=stocks+sc_corp_equity+nmmf_equity+othma_equity+mmmf
*g cj_db_`x'_wgtwages = cj_db_`x'wages*`x'_totyears 
gen fixed_assets=(liq-mmmf)+cds+nmmf_fixed+othma_fixed+savbnd+bond
foreach x in bus equity fixed {
gen `x'_assets_rescale=`x'_assets/(nonoore_scalar)
}
g oore_rescale = oore_db_rescale
g nonoore_rescale = nonoore_db_rescale
g liabilities_rescale = liabilities_db_rescale
//create unscaled summary datasets  -- owner occupied, nonhousnonfin assets, fin assets, liabilities, networth
preserve
collapse(sum) oore nonhousenonfin fin_assets_ffa liabilities networth_ffa_db db_wealth pen_wealth pen_wealth_rescale nonoore oore_rescale nonoore_rescale liabilities_rescale  nw_ffa_db_rescale nethouse_rescale  [pw=wgt]
gen year=`year'
order year, first
foreach x in oore nonhousenonfin fin_assets_ffa liabilities networth_ffa_db db_wealth pen_wealth pen_wealth_rescale nonoore oore_rescale nonoore_rescale liabilities_rescale  nw_ffa_db_rescale nethouse_rescale{
replace `x'=`x'/1E9
}
tempfile sumunscaled`year'
save `sumunscaled`year''
	restore

disp "no trouble so far `year'"

preserve
collapse(sum) oore_rescale nonoore_rescale liabilities_rescale  nw_ffa_db_rescale oore_db_rescale nonoore_db_rescale liabilities_db_rescale oore nonoore liabilities networth networth_ffa_db db_wealth db_wealth_fut db_wealth_curr retqliq  pen_wealth pen_wealth_rescale nethouse_rescale nonmortdebt_rescale  [pw=wgt]
gen rescale_networth_dif=networth_ffa_db-nw_ffa_db_rescale
gen nw_dif=networth-nw_ffa_db_rescale

foreach x in oore_rescale nonoore_rescale liabilities_rescale  nw_ffa_db_rescale oore_db_rescale nonoore_db_rescale liabilities_db_rescale oore nonoore liabilities networth_ffa networth networth_ffa_db db_wealth db_wealth_fut db_wealth_curr retqliq  pen_wealth pen_wealth_rescale nethouse_rescale nonmortdebt_rescale  {
replace `x'=`x'/1E6
}
gen year=`year'
order year, first
tempfile summary`year'
save `summary`year''
restore

tempfile scf`year'
save `scf`year''
disp "no trouble so far `year'"

foreach var of varlist networth networth_ffa_db networth_db db_wealth pen_wealth pen_wealth_rescale   nw_ffa_db_rescale income totinc totinc_alt capinc capinc_alt oore_db_rescale nethouse_rescale SCFps1 SCFps2 nonmortdebt_rescale nonoore_db_rescale liabilities_rescale oore_rescale income_plHI  {
	cumul `var' [aw=wgt], gen(rank`var')
	}

gen one=1
quietly: sum one [aw=wgt]
local num_tot=r(sum)

gen totfam=0
replace totfam=114.656  if year==1989
replace totfam=120.453  if year==1992
replace totfam=124.716  if year==1995
replace totfam=129.301  if year==1998
replace totfam=134.473  if year==2001
replace totfam=141.843  if year==2004
replace totfam=148.361  if year==2007
replace totfam=153.543  if year==2010
replace totfam=160.681  if year==2013

*** According to Piketty-Saez, there are 160,681,000 tax units in 2012 (this includes Forbes400)
** So SCF (without Forbes) should rank top 1% tax units as if there were 168,680,600 tax units
** then when ranking w/Forbes dollars we'll add them back in
replace totfam=(totfam*1e+6)-400
//MAKE ADJUSTMENT FOR FORBES 400 -- they're not in the SCF
gen totfam400=totfam+400
disp "TOTAL FAMILY COUNT `year'"
*g cj_db_`x'_wgtwages = cj_db_`x'wages*`x'_totyears 
summ totfam [aw=wgt]
disp r(mean)/(1e+3)
* ranking assuming the Piketty-Saez total number of tax units
** do tax unit ranking if total number of tax units was piketty-saez tax units, and piketty-saez units + Forbes400

foreach var of varlist networth networth_ffa_db db_wealth pen_wealth pen_wealth_rescale networth_db  nw_ffa_db_rescale income totinc totinc_alt capinc capinc_alt oore_db_rescale nethouse_rescale SCFps1 SCFps2 nonmortdebt_rescale nonoore_db_rescale liabilities_rescale oore_rescale income_plHI {
	gen rank`var'_ps=1-(1-rank`var')*`num_tot'/totfam
	gen rank`var'_ps_400=1-(1-rank`var')*`num_tot'/(totfam400)
	gen rank`var'_400 = rank`var'*totfam/(totfam400)
	}
/* SCF numbers */
gen forbes400=0
replace forbes400=269 if year==1989
replace forbes400=304.8 if year==1992
replace forbes400=395.1 if year==1995
replace forbes400=738.1 if year==1998
replace forbes400=946.38 if year==2001
replace forbes400=1002 if year==2004
replace forbes400=1540 if year==2007
replace forbes400=1369 if year==2010
replace forbes400=2021 if year==2013


tempfile cap`year'
save `cap`year''
}


//WEALTH
matrix results = J(8*`numyears',8,.)
local yy=0
foreach year of numlist $years {

use `cap`year'', clear

foreach var of varlist  nw_ffa_db_rescale networth networth_db networth_ffa_db pen_wealth pen_wealth_rescale oore_db_rescale nethouse_rescale {
quietly: sum `var' [aw=wgt] 
local `var'_tot=r(sum)*1e-9
}

local ii=1

/*------------
ORDER:
SCF HOUSEHOLDS -SCF NW
+ASSET ADJ w/FORBES -- new NW
+TAX UNIT BASIS
-----------*/
foreach fract of numlist .9 .95 .99 .995 .999 .9999 {
	matrix results[`numyears'*(`ii'-1)+`yy'+1,1]=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,2]=`year'
	
	quietly: sum networth [aw=wgt] 
	local aux=r(sum)
	qui: sum nw_ffa_db_rescale [aw=wgt]
	local aux_ffa_db_rescale=r(sum)
	quietly: sum forbes400 [aw=wgt] 
	local aux400=r(mean)*1e+9
	quietly: sum networth_db [aw=wgt]
	local aux_nw_db =r(sum)
	
	**SCF HOUSEHOLDS - SCF NW
	quietly: sum networth [aw=wgt] if ranknetworth>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,3]=r(sum)/`aux'

	** networth totals
	quietly: sum networth_db [aw=wgt] if ranknetworth_db >= `fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,5]=r(sum)/`aux_nw_db'
	** Add Forbes 400 Wealth to Bulletin + DB
	quietly: sum networth_db [aw=wgt] if ranknetworth_db_400>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,6]=(r(sum) +`aux400')/(`aux_nw_db' + `aux400')
	** Add Forbes 400 Wealth to rescaled wealth
	quietly: sum nw_ffa_db_rescale [aw=wgt] if ranknw_ffa_db_rescale_400>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,7]=(r(sum) +`aux400')/(`aux_ffa_db_rescale' + `aux400')
	** Add Forbes 400 Wealth 
	quietly: sum nw_ffa_db_rescale [aw=wgt] if ranknw_ffa_db_rescale_ps_400>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,8]=(r(sum) +`aux400')/(`aux_ffa_db_rescale' + `aux400')

		local ii=`ii'+1
	}
local yy=`yy'+1
}
matrix list results 

svmat results
keep results*
rename results1 fractile 
rename results2 year
rename results3 FFAnw_re_db_TU_f400
rename results5 SCFnw_DB
ren    results6 SCFnw_DB_f400
ren    results7 SCFnw_DB_rescale_f400


drop if fractile==.
list
log close
*export excel using "$datascfdir1/WealthShareOutput/Top Share GraphicsDB- SCF-BPEA.xls" , sheet("StataOut_wealth") sheetmodify cell(A1) firstrow(variables)

matrix results = J(48*`numyears',48,.)
local yy=0
foreach year of numlist $years {

use `cap`year'', clear

foreach var of varlist income norminc totinc SCFps1 SCFps2  {
quietly: sum `var' [aw=wgt]
local `var'_tot=r(sum)*1e-9
}
local ii=1

/*------------
	quietly: sum income [aw=wgt] if rankincome>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,3]=1e-9*r(sum)/`income_tot'
-----------*/
foreach fract of numlist .9 .95 .99 .995 .999 .9999 {
	matrix results[`numyears'*(`ii'-1)+`yy'+1,1]=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,2]=`year'
	quietly: sum forbes_inc [aw=wgt] 
	local aux400inc=r(mean)
	quietly: sum medicaid [aw=wgt] 
	local medicaid=r(mean)
	quietly: sum foodstamps [aw=wgt] 
	local fs = r(mean)
	quietly: sum income_plHI [aw=wgt] 
	local agginc_hi = r(sum)

	quietly: sum  income [aw=wgt] 
	matrix results[`numyears'*(`ii'-1)+`yy'+1,3]=1e-9*r(sum)
	quietly: sum  SCFps1 [aw=wgt] 
	matrix results[`numyears'*(`ii'-1)+`yy'+1,4]=1e-9*r(sum)
	quietly: sum income [aw=wgt] if rankincome>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,6]=1e-9*r(sum)/`income_tot'
	quietly: sum SCFps1 [aw=wgt] if rankSCFps1>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,7]=1e-9*r(sum)/`SCFps1_tot'
	
	quietly: sum income [aw=wgt] if rankincome>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,35]=1e-9*r(sum)
	matrix results[`numyears'*(`ii'-1)+`yy'+1,36]=`income_tot'	
	quietly: sum income_plHI [aw=wgt] if rankincome_plHI_400>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,41]=1e-9*r(sum) +  1e-9*`aux400inc'
	quietly: sum income_plHI [aw=wgt] 
	matrix results[`numyears'*(`ii'-1)+`yy'+1,42]=1e-9*r(sum) +  1e-9*`aux400inc'
	quietly: sum SCFps1 [aw=wgt] if rankSCFps1_400 >= `fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,43]=(r(sum) + `aux400inc')/(1E9*`SCFps1_tot'+`aux400inc')
	quietly: sum SCFps1 [aw=wgt] if rankSCFps1_ps_400>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,44]=(r(sum) + `aux400inc')/(1E9*`SCFps1_tot'+`aux400inc')

	quietly: sum income_plHI [aw=wgt] if rankincome_plHI_400>=`fract'
	matrix results[`numyears'*(`ii'-1)+`yy'+1,45]=(1e-9*r(sum) +  1e-9*`aux400inc')/(`agginc_hi'*1e-9 + `fs' + `medicaid')
	
	local ii=`ii'+1
	}
local yy=`yy'+1
}
matrix list results 

svmat results

keep results*
rename results1 fractile 
rename results2 year
rename results3 bullinc_sum
rename results4 SCFps1_sum
rename results5 SCFps2_sum
rename results6 inc_by_inc
rename results7 SCFps1_rank
ren    results35 bullinc_agg_rank
ren    results36 bullinc_agg
ren    results39 bullincHI_agg_rank
ren    results40 bullincHI_agg
ren    results41 bullincHI_agg_rank400
ren    results42 bullincHI_agg400
ren    results43 SCFps1_rank400
ren    results44 SCFps1_rank400TU
ren results45 pref_incshare

*export excel using "$datascfdir1/WealthShareOutput/Top Share GraphicsDB- SCF-BPEA.xls" , sheet("StataOut_income") sheetmodify cell(A1) firstrow(variables)

