set more off
capture log close
*log using "/mecs/scf2/sample/design/pgm/2013/testing/2013data.log", replace
adopath + /mecs/scf7/analysis/software/stata/ados/ 

tempfile ctrl2013

capture clear
#delimit ;

infix

double alt_xx1 1-8
double ls_ind 10
double both_ls 12
double sampladd 14
double num_mhu 16-17
double add_mhu 19
double parentid 21-28
double seqid01 30-35
double sampstr 37
double str_case 39-42
double str_inel 44-46
double str_comp 48-50
double nfa 52-57
double nfa_case 59-62
double nfa_inel 64-65
double nfa_comp 67-69
double nfa_ln 71-76
double nfa_ex 78-84
double nfa_mhu 86-87
double pairnfa 89-91
double segment 93-99
double seg_ln 101-105
double seg_ex 107-111
double seg_mhu 113-114
double block 116-120
double block_ln 122-125
str state 127-128
double fips 130-134
double tract 136-141
double cens_reg 143-144 
double seg_samp 146-147
double cen_pop 152-160
double cen_hh 162-170
str fi_id 181-188 
double fld_disp 190-191
double dlogged 194-195
double mlogged 197-198
double ylogged 200-203
double zipcode 205-209
double fee 215-220
double prob_nfa 222-230
double prob_seg 233-241 
double probchnk 244-252
double seginnfa 254-256
double replicate 258-260

using /mecs/scf2/sample/control/data/raw/2013/control_scf2013_042314.txt;

#delimit cr

gen status = 1 if (fld_disp>=70 & fld_disp<=76)
replace status = 2 if (fld_disp>=80 & fld_disp<85) | fld_disp==86
replace status = 3 if fld_disp==85
replace status = 4 if (fld_disp>=93 & fld_disp<=94) | fld_disp==97 | fld_disp==99
replace status = 5 if fld_disp==97 | fld_disp==107
replace status = 6 if (fld_disp>=90 & fld_disp<=92) | fld_disp==95 | fld_disp==96 | fld_disp==98 | fld_disp==99
replace status = 7 if fld_disp==101 | fld_disp==106
replace status = -1 if fld_disp==0

gen respond = 1 if status==1
replace respond = 2 if (status>=3 & status<=7)
replace respond = 0 if status==2

*-- Note: in control.1 statuses of 3-7 have perel=2, here I call it 0 to later use in nonresp regs.
gen perel = 1 if status==1
replace perel = 0 if (status>=3 & status<=7)

keep if missing(seqid01)==0
keep status respond perel alt_xx1 sampstr seqid01 nfa replicate
save `ctrl2013', replace


/*-------------------------------
 BPWICM for all respondents and nonrespondents
-------------------------------*/
tempfile index
clear
use "/lcl/mecs/scf2/sample/control/data/transf/2013/allindex.dta", clear
ren seqid seqid01

gen sche=(E26200!=0)
gen schc=((E00900+E02540+E02700)!=0)

keep seqid01 bpstdwinm bpwicm LBWINDEX* BWINDEX* BWIC0 BWIC1 BSTDWINL0 BSTDWINL1 bstdwinlm bwicm bwiclm fininc finc agep N6 schc sche E00200 E00300 E00400 E00600 dobmo E02300 E02400 E18500 E19800 region soiwgt SOIWGT0 agesoi NFA_SOIWGT NFA_SOIWGT0 nfaprob ESTATE RENT PART SCH_C_GROSS GROSS_FARM NET_KG salaries totinc E25300 E26200 E26390 E91010 E96310 E96610 E02400 E01500 E02650 R00200 R00300 R00400 R00600 R02300 R02400 R18500 R19800 R25300 R26200 R26390 R91010 R96310 R96610 R02400 R01500 R02650 U00200 U00300 U00400 U00600 U02300 U02400 U18500 U19800 U25300 U26200 U26390 U91010 U96310 U96610 U02400 U01500 U02650 mars E91100 R91100 U91100 E96640 R96640 U96640 E01000 R01000 U01000 E25350 R25350 U25350 E02600 R02600 U02600 E01100 E01200 R01100 R01200 U01100 U01200

sort LBWINDEX0
egen poptot = sum(SOIWGT0)
g cum = sum(SOIWGT0)
g bpstdwin0 = cum/poptot
save `index', replace

/*-------------------------------
 Merge the two together
-------------------------------*/
tempfile mrg
sort seqid01
merge 1:1 seqid01 using `ctrl2013', gen(merge1)

keep if merge1==3

save `mrg', replace

*summ
*count

/*-------------------------------
 Merge the bselect data (to get selwgt for all)
  The selwgt is the base LS weight - adjusted for NFA selection in select.sample)
-------------------------------*/
tempfile selwgt
use /mecs/scf2/sample/control/data/transf/2013/bselect.dta, clear
ren seqid seqid01
keep seqid01 selwgt
save `selwgt', replace

sort seqid01
merge 1:1 seqid01 using `mrg', gen(merge2)
* drop unused replicates
keep if merge2==3
tempfile merge
save `merge', replace

/*-------------------------------
 Merge some SCF data on
  (grab the final weight from bulletin)
-------------------------------*/
tempfile scfb13
clear
use /mecs/scf7/analysis/bulletin/2013/data/transf/bull_nominal/scfb2013.dta
gen imp=mod(x1,10)
keep if x30009>0 & imp==1
*keep alt_xx1 wgt
save `scfb13', replace
use x53* x57* x30009 x1 alt_xx1 using /mecs/scf3/final/scf2013/data/transf/scf13i6.dta
gen imp=mod(x1,10)
keep if x30009>0 & imp==1
tempfile scfr13
save `scfr13', replace

tempfile scfw13
clear
use "/mecs/scf2/sample/weight/data/transf/2013/hawts6.dta", clear
gen imp=mod(X1,10)
keep if imp==1
ren ALT_XX1, lower
keep alt_xx1 lwt
save `scfw13', replace

merge 1:m alt_xx1 using `scfb13'
drop _m
merge 1:1 alt_xx1 using `scfr13'
tempfile scf13
save `scf13'

use `merge', clear
merge 1:m alt_xx1 using `scf13', gen(scfmrg)

g year = 2013
tempfile soi2013
save `soi2013', replace


/*****************************************************************************************/
g divinc = x5710
g intinc = x5708 
g businc = max(0,x5704) + max(0,x5714)
g capinc = max(0,businc) + intinc + divinc + max(-3000,kginc)
g peninc = ssretinc - x5306*(x5307==6) - 12*x5306*(x5307==4) - x5311*(x5312==6) - 12*x5311*(x5312==4) 
g othinc = x5724
g mktinc = wageinc + capinc + peninc + othinc

g lnest_trst = log(ESTATE_TRUST)
g lnrnt_roy = log(RENT_ROY)
g lnscorp = log(PART_SCORP)
g lnschc_g = log(SCH_C_GROSS)
g lnfrm_g = log(GROSS_FARM)
g lnkg = log(NET_KG)
g lnfininc = log(fininc)
g lsalary = log(salaries)
g ltotinc = log(totinc)
g ltotinckg = log(totinc+NET_KG)

qui g cpi=(1902/1902)*(1886/1808) if year==1989
replace cpi=(2116/2116)*(2103/2051) if year==1992
replace cpi=(2265/2265)*(2254/2201) if year==1995
replace cpi=(2405/2405)*(2397/2364) if year==1998
replace cpi=(2618/2618)*(2600/2529) if year==2001
replace cpi=(2788/2788)*(2774/2701) if year==2004
replace cpi=(3062/3062)*(3045/2961) if year==2007
replace cpi=(3208/3208)*(3202/3150) if year==2010
replace cpi=(3438/3438)*(3421/3372) if year==2013
g income_nom = income/cpi

g inc_nowage0 = fininc + ESTATE_TRUST+RENT_ROY + PART_SCORP+SCH_C_GROSS + GROSS_FARM + NET_KG
g inc_nowage2 = totinc - salaries
g inc_nowage1 = fininc + ESTATE_TRUST+RENT_ROY + PART_SCORP+SCH_C_GROSS + GROSS_FARM 
g linc_nowage0 = log(inc_nowage0)
g linc_nowage1 = log(inc_nowage1)
g linc_nowage2 = log(inc_nowage2)

*want to compare 2012 SCF income with 2011 SOI income
*want both SOI calculated total income and our sum of the components
foreach t in E R U {
g sch_c`t' = max((`t'90010-`t'90100), (`t'91010-`t'91100),0)
g farm1`t' = max(`t'95640, `t'96640,0)
g posrent`t' = max(0,`t'25350)

g soiincome`t'kg = `t'00200 + `t'00300 + `t'00400 + `t'00600 + `t'25300 + `t'26200 + `t'26390 + sch_c`t' + farm1`t' + `t'02400 + `t'01500 +`t'01100 + `t'01200

g soiinc_nowage`t'kg = `t'00300 + `t'00400 + `t'00600 + `t'25300 + `t'26200 + `t'26390 + sch_c`t' + farm1`t' +`t'01100 + `t'01200

*Figure 4
tabstat soiincomeEkg if perel == 0 [aw=selwgt], by(bpwicm)
tabstat soiincomeEkg if perel == 1 [aw=selwgt], by(bpwicm)

g mktinc500K_soi`t' = soiincome2`t' >= 500000
replace mktinc500K_soi`t' = . if soiincome2`t' == .

g inc500K_scf_t1 = income >= 500000
replace inc500K_scf = . if income == .
g mktinc500K_scf_t1 = mktinc >= 500000
replace mktinc500K_scf = . if mktinc == .

*distribution of income changes between t-2 and t-1
g chinc_t2_t1c = (income_nom - soiincomeEkg)/soiincomeEkg
replace cpi=(1902/1902)*(1886/1808) if year==1989
replace cpi=(2116/2116)*(2103/2051) if year==1992
replace cpi=(2265/2265)*(2254/2201) if year==1995
replace cpi=(2405/2405)*(2397/2364) if year==1998
replace cpi=(2618/2618)*(2600/2529) if year==2001
replace cpi=(2788/2788)*(2774/2701) if year==2004
replace cpi=(3062/3062)*(3045/2961) if year==2007
replace cpi=(3208/3208)*(3202/3150) if year==2010
replace cpi=(3438/3438)*(3421/3372) if year==2013

g chmktinc_t2_t1 = (mktinc - soiincome2E)/soiincome2E
g chmktinc_t3_t2 = (soiincome2E - soiincome2R)/soiincome2R
g chcapinc_t3_t2 = (soiinc_nowageE - soiinc_nowageR)/soiinc_nowageR 
g chcapinc_t3_t2kg = (soiinc_nowageEkg - soiinc_nowageRkg)/soiinc_nowageRkg 
g chinc_t3_t2b = (soiincomeE- soiincomeR)/soiincomeR
g chinc_t3_t2bkg = (soiincomeEkg- soiincomeRkg)/soiincomeRkg

*categories for change in income
*For Figure 6
local var = chinc_t2_t1c
g chinc_cat = 0 if `var' <-0.5
replace chinc_cat = 1 if `var'>=-0.5 & `var' < -0.25
replace chinc_cat = 2 if `var'>=-0.25 & `var' < -0.1
replace chinc_cat = 3 if `var'>=-0.1 & `var' < -0.05
replace chinc_cat = 4 if `var'>=-0.05 & `var' < 0
replace chinc_cat = 5 if `var'>=0 & `var' < 0.05
replace chinc_cat = 6 if `var'>=0.05 & `var' < 0.1
replace chinc_cat = 7 if `var'>=0.1 & `var' < 0.25
replace chinc_cat = 8 if `var'>=0.25 & `var' < 0.5
replace chinc_cat = 9 if `var'>=0.5
replace chinc_cat = . if income == .

*Figure 5b
g chcapinckg_cat = 0 if chcapinc_t3_t2kg <-0.5
replace chcapinckg_cat = 1 if chcapinc_t3_t2kg  >=-0.5 & chcapinc_t3_t2kg < -0.25
replace chcapinckg_cat = 2 if chcapinc_t3_t2kg  >=-0.25 & chcapinc_t3_t2kg < -0.1
replace chcapinckg_cat = 3 if chcapinc_t3_t2kg  >=-0.1 & chcapinc_t3_t2kg < -0.05
replace chcapinckg_cat = 4 if chcapinc_t3_t2kg  >=-0.05 & chcapinc_t3_t2kg  < 0
replace chcapinckg_cat = 5 if chcapinc_t3_t2kg >=0 & chcapinc_t3_t2kg < 0.05
replace chcapinckg_cat = 6 if chcapinc_t3_t2kg >=0.05 & chcapinc_t3_t2kg  < 0.1
replace chcapinckg_cat = 7 if chcapinc_t3_t2kg  >=0.1 & chcapinc_t3_t2kg < 0.25
replace chcapinckg_cat = 8 if chcapinc_t3_t2kg >=0.25 & chcapinc_t3_t2kg < 0.5
replace chcapinckg_cat = 9 if chcapinc_t3_t2kg >=0.5
replace chcapinckg_cat = . if soiinc_nowageRkg == .

*Figure 5a
g chinc_catERkg = 0 if chinc_t3_t2bkg <-0.5
replace chinc_catERkg = 1 if chinc_t3_t2bkg >=-0.5 & chinc_t3_t2bkg  < -0.25
replace chinc_catERkg = 2 if chinc_t3_t2bkg >=-0.25 & chinc_t3_t2bkg  < -0.1
replace chinc_catERkg = 3 if chinc_t3_t2bkg >=-0.1 & chinc_t3_t2bkg < -0.05
replace chinc_catERkg = 4 if chinc_t3_t2bkg >=-0.05 & chinc_t3_t2bkg < 0
replace chinc_catERkg = 5 if chinc_t3_t2bkg >=0 & chinc_t3_t2bkg < 0.05
replace chinc_catERkg = 6 if chinc_t3_t2bkg >=0.05 & chinc_t3_t2bkg  < 0.1
replace chinc_catERkg = 7 if chinc_t3_t2bkg >=0.1 & chinc_t3_t2bkg  < 0.25
replace chinc_catERkg = 8 if chinc_t3_t2bkg >=0.25 & chinc_t3_t2bkg < 0.5
replace chinc_catERkg = 9 if chinc_t3_t2bkg >=0.5


forval y = 2103(3)2013 {
*Figure 5
tab chinc_catERkg if year == `y' & sampstr >= 4 & perel == 1 [aw=selwgt_int]
tab chinc_catERkg if year == `y' & sampstr >= 4 & perel == 0 [aw=selwgt_int]
tab chcapinckg_cat if year == `y' & sampstr >= 4 & perel == 1 [aw=selwgt_int]
tab chcapinckg_cat if year == `y' & sampstr >= 4 & perel == 0 [aw=selwgt_int]
}
*Figure 6
g selwgt_int = round(selwgt)
tab chinc_cat if year == `y' & soiincomeEkg>=500000 [aw=selwgt_int]
