function forc_mat=zb_quickforecast_sub(stforc,popsTF,in) 
% =========================================================================
% Given the matrix of state forecasts STFORC 
% 1) Obtain GDP deflator in position POS_GDPDEF 
%    and add constants PARAM_GDPSS     
% 2) Perform adjustments by scale, constant, population and deflation 
% 
% This is the subroutine for operations in ZB_QUICKFORECAST.M, only
% requires defining forc_pos and part of IN 
% 
% AJ 1/18/2011
% =========================================================================
consnoadj       =in.consnoadj ; 
forc_pos        =in.forc_pos  ; 
forc_scale      =in.forc_scale; 
forc_addp       =in.forc_addp; 
forc_pop        =in.forc_pop ; 
param_gdpss     =in.param_gdpss; 


%% Obtain Annualized GDP 
if any(forc_addp ~= 0 ); 
        gdpdef_fancons=4*( stforc(:,in.pos_gdpdef)+param_gdpss ); 
end 

%% Transform forecasts 
nser=length(forc_pos);
nforc=size(stforc,1) ; 
if length(popsTF)~=nforc
    error('popTF must be a vector'); 
end
forc_mat=zeros(nforc,nser);
for ii=1:nser;
    forc_mat(:,ii)      =forc_scale(ii)*(stforc(:,forc_pos(ii))+consnoadj(ii) ) ;
    if forc_addp(ii)    ==1;
        forc_mat(:,ii)  =forc_mat(:,ii)-gdpdef_fancons;
    end
    if forc_pop(ii)==1;
        forc_mat(:,ii)  =forc_mat(:,ii)+popsTF;
    end
end