function [stringDiff,count]=stringDifference(leftString,rightString,removeString)
% function [stringDiff,count]=stringDifference(leftString,rightString,removeString)
%
% stringDifference 
% Given leftString and rightString 
% extract the non-overlapping portion in the leftString 
% if removeString is given, replace occurances of that string with a blank
% space 
% 
% E.g. stringDifference(savePath,loadPath,'\') 
%      will extract the subfolder in loadPath 
% 
% AJ Feb 2 2012
flagMatch=1; 
count=0; 
while flagMatch > 0 
    count=count+1; 
    flagMatch=strncmp(leftString,rightString,count); 
end 
count=count-1; 
if count==0 
    stringDiff=[]; 
    return
else 
    stringDiff=leftString(count:end); 
end 
if nargin == 3 || isempty(removeString)==false     
    stringDiff=regexprep(stringDiff,removeString,' '); 
    if isspace(stringDiff(1))==true 
        stringDiff=stringDiff(2:end); 
    end 
end 
    
    