function stIn=plotAssignDefaults(stIn) 
% Given the structure stIn Assign default values to all structures used for
% plotting 
% 
%% 1. Fields
% 
% *.lineWithds* 
%       [2.5 |  2 |  2 ]  
%
% *.lineStyles*
%       [ -  | -- | -. ]
%
% *.markers*
%       [ none | none | o ]
%
% *.markerSize*
%       [    1 |    1 | 4 ] 
%
% *.flagColor* 
%       Default is 0 
%
% *.colors* 
%
%       if flagColor==0 
%          [light grey | black | dark grey ]
%
%       if flagColor==1
%          [blue       | black | red       ] 
% 
% *.flagLandscape* 
%       Default is 0 
%
% *.flagBoxOff*
%
%       Default is 0 
% 
% *.titleFontSize'
%   
%       Default is 12 
% 
% *.flagLandscape' Default is 0 
% 
% *.flagBoxOff' Default is 0 
% 
% *.flagBar' Default is 0 
% 
% *.paperPosition* Default depends on Lanscape vs. Portrait 
%
% 
%% A. Lines, Colors and Markers 
if isempty(stIn)==true 
    stIn.emptyStructure=true; 
end 
lineWidths=[2.5 2.2 2 2 2 3]; 
[~,stIn]=ch_field(stIn,'lineWidths',lineWidths); 
lineStyles={'-','--','-.','-',':','-'}; 
[~,stIn]=ch_field(stIn,'lineStyles',lineStyles); 
markers={'none','none','o','*','x','none'}; 
[~,stIn]=ch_field(stIn,'markers',markers); 
markersSize=[1 1 5 5 5 1]; 
[~,stIn]=ch_field(stIn,'markersSize',markersSize); 
[~,stIn]=ch_field(stIn,'flagColor',0); 
if stIn.flagColor==0
    colors=[0.5 0.5 0.5;0 0 0;0.3 0.3 0.3;0 0 1;0 0 0;1 0 0];
else
    colors=[0 0 1;0 0 0;1 0 0;0 1 0;0 1 0];
end
[~,stIn]=ch_field(stIn,'colors',colors);
%% B. Figure Aspects 
[~,stIn]=ch_field(stIn,'flagLandscape',0); 
[~,stIn]=ch_field(stIn,'flagBoxOff',1); 
[~,stIn]=ch_field(stIn,'flagBar',0); 
if stIn.flagLandscape==0 
    paperPosition=[0.75 0.5 7.5 10]; 
else 
    paperPosition=[0.2 0.1 10.5 8.3]; 
end 
[~,stIn]=ch_field(stIn,'paperPosition',paperPosition); 
%% C. FontSizes 
[~,stIn]=ch_field(stIn,'titleFontSize',12); 
[~,stIn]=ch_field(stIn,'suptitleFontSize',14); 
[~,stIn]=ch_field(stIn,'suptitleFontWeight','normal'); 

[~,stIn]=ch_field(stIn,'axesFontSize',[]); 
[~,stIn]=ch_field(stIn,'FontName','Helvetica'); 
[~,stIn]=ch_field(stIn,'yLabel',[]); 
[~,stIn]=ch_field(stIn,'xLabel',[]);
[~,stIn]=ch_field(stIn,'xtickValues',[]); 
[~,stIn]=ch_field(stIn,'xtickLabels',[]); 
[flagYlim,stIn]=ch_field(stIn,'ylim',[]); 
[flagXlim,stIn]=ch_field(stIn,'xlim',[]); 
if flagYlim==0
    [~,stIn]=ch_field(stIn,'yOffset',0.01);
end
if flagXlim==0
    [~,stIn]=ch_field(stIn,'xOffset',0.01);
end
%% D. Legends 
[~,stIn]=ch_field(stIn,'legendLocation','bottom'); 
[~,stIn]=ch_field(stIn,'flagNoLegend',0); 
[~,stIn]=ch_field(stIn,'legend',{'Series 1','Series 2','Series 3'}); 
[~,stIn]=ch_field(stIn,'legendFontSize',10); 
[~,stIn]=ch_field(stIn,'flagLegendBoxOff',1); 

%% E. Horizontal Line 
[~,stIn]=ch_field(stIn,'hlineOn',0);
[~,stIn]=ch_field(stIn,'hlineVal',[]);
if stIn.hlineOn==1 && isempty(stIn.hlineVal)==true
    error('With hlineOn==1 Must provide hlineVal') 
end    
if stIn.hlineOn==1
    [~,stIn]=ch_field(stIn,'hlineColor',[1 0 0]);
    [~,stIn]=ch_field(stIn,'hlineWidth',1.5);
    [~,stIn]=ch_field(stIn,'hlineStyle','--');    
end 
