function hand=plot2samp(sample,xmat,str1,str2,flag_2y,legfont,widthvec,yoffset,xoffset,flag_color)
%function
%hand=plot2samp(sample,xmat,str1,str2,flag_2y,legfont,widthvec,yoffset,xoffset,flag_color)
% PLOT 2 SAMP 
% Input 
% Sample vector     [T 1]
% XMAT              [T 2] matrix of series 
% STR1              Name of first series legend 
% STR2              Name of second series legend
flag_doubley=0; lfsize=7; 
leg1='Series 1'; 
leg2='Series 2'; 
% =========================================================================
switch nargin 
    case 1
        error('Must provide SAMPLE and MATRIX') 
    case 2
        check=size(xmat);
        if check(2) ~= 2 ; error('XMAT must have 2 columns'); end
        if length(sample)~=check(1);error('Mismatch in length SAMPLE and XMAT'); end
  
end 
if nargin <= 3 || isempty(str1); 
    flag_nolegend=1; 
end 
if nargin > 3 && ~isempty(str1) && ~isempty(str2)
    flag_nolegend=isempty(str1); 
    if flag_nolegend==0
        if ~ischar(str1)
            if iscell(str1);
                str1=char(str1);
            else
                error('STR1 must be cell or string')
            end
        end
        if ~ischar(str2)
            if iscell(str2);
                str2=char(str2);
            else
                error('STR2 must be cell or string')
            end
        end
        leg1=str1; leg2=str2;
    end 
end
if nargin > 4
        if ~isempty(flag_2y) && flag_2y==1 
            flag_doubley=1; 
        end 
        if ~isempty(legfont); 
            lfsize=legfont; 
        end 
end 

if nargin < 7 || isempty(widthvec); 
    widthvec=[2.5 2]; 
else 
    if length(widthvec(:))~=2 
        error('WIDTHVEC must be 2x1') 
    end 
end 
if nargin < 8 || isempty(yoffset); 
    yoffset=0; 
end 

if nargin < 9 || isempty(xoffset); 
xoffset=0; 
end 

if nargin < 10 || isempty(flag_color); 
    flag_color=1; 
end 
% ========================================================================
if ~flag_doubley
    hand1=plot(sample,xmat(:,1),'LineWidth',widthvec(1));hold on;
    hand2=plot(sample,xmat(:,2),'--*','LineWidth',widthvec(2));

    %set(hand,'Color',[0.5 0.5 0.5])
    
    if flag_color==1
        set(hand1,'Color','b')
        set(hand2,'Color','r','MarkerSize',3);  hold off;
    else
        veclight=[0.7 0.7 0.7];
        set(hand1,'Color',veclight,'LineWidth',widthvec(1));
        set(hand2,'Color',[0.0 0.0 0.0],'LineStyle','--','MarkerSize',1,'LineWidth',widthvec(2));
    end
    
    %set(hand,'Color',[0.5 0.5 0.5]);  hold off;
    %axis tight;
    if flag_nolegend==0
        hh=legend(leg1,leg2,'Location','Best');
        set(hh,'EdgeColor','w');
        set(hh,'FontSize',lfsize);
        set(hh,'Box','Off'); 
    end
    
    ymin=min(min(xmat)); 
    ymax=max(max(xmat)); 
    
    ylim([ymin-yoffset ymax+yoffset]); 
    
    xlim([sample(1) sample(end)+xoffset]); 
    
else  
    [junk,hand1,hand2]=plotyy(sample,xmat(:,1),sample,xmat(:,2)); 
    set(hand1,'LineWidth',2,'LineStyle','--'); 
    set(hand1,'Color',[0 0 0]); 
    set(hand2,'LineWidth',3);
    set(hand2,'Color',[0.55 0.55 0.55]);
end 
hand=gcf;     


