  function numcell=num2cprec(numat,prec); 
% function numcell=num2cprec(numat,prec); 
% Convert a matrix of numbers into a cell
% but using a precision as to the number of decimal places 
% Use num2cellaj for a general conversion 
% Prec must be a number for how many decimal places to use in the conversion 
% If not defined, default is 3
% 
% Alejandro Justiniano ajustiniano@imf.org
% 1/22/05 
% =====================================================================
if nargin < 2 
    prec='.3f'; 
else 
    prec=['.',num2str(prec),'f']; 
end 
[m,n]=size(numat); 

numcell=cell(m,n); 
ii=1; 
for ii=1:m; 
    jj=1; 
    for jj=1:n; 
        st=numat(ii,jj);     
        stemp=num2str(st); 
        if ( st-round(st) ) ~= 0 
            a=findstr(stemp,'.' );              
            st=sprintf(['%',num2str(a),prec],st);
        else 
            st=stemp; 
        end
        numcell(ii,jj)={st}; 
    end; 
end; 
