  function mc=merge_cells( c1, c2 ,dspace ); 
% function mc=merge_cells( c1, c2 , dspace); 
% Merge cells 
% Given cells c1 and c2 create a new cell mc 
% by putting c1 on top of c2
%
% dpsace determines how may spaces to leave between them 
% default (not defined or empty) is none  
% Alejandro Justiniano 10/19/04 
% 4/3/2005 
if nargin ==2 | isempty( dspace ); 
    flag_space = 0 ; 
else 
    flag_space = 1; 
end 
a=size(c1); 
b=size(c2); 

cdim = max( [a(2) b(2)]  );
if flag_space == 0;  
mc=emptycell( a(1)+b(1) , cdim ); 
mc(1:a(1),1:a(2) ) = c1; 
mc(a(1)+1:end,1:b(2) ) = c2; 
else 
    mc = emptycell( a(1) + b(1)  + dspace , cdim ); 
    mc(1:a(1),1:a(2) ) = c1;  
    mc( a(1) + dspace + 1:end, 1:b(2) ) = c2 ;
end 
