function [stforc,yforc]=forecastLoop(GBook,RBook,ZBook,CBook,tauVec,stateJump,innovMat,Nforc)
%% Key is that tauVec, vector indicating which page to use, must match
%% Nforc!!!
Ns=length(stateJump(:));
%% If Pass in InnovMat, generate forecasts using that Matrix
if ~isempty(innovMat)
    dim=size(innovMat);
    if dim(1)~=Nforc
        error('EMAT Matrix of shocks must be [NFORC NX]')
    end
    flag_useShocks=1;
else
    flag_useShocks=0;
end
if length(tauVec)~=Nforc;
    error('tauVec must match number of forecasts');
end

% Define matrices
stforc=zeros(Ns,Nforc);
yforc =zeros(size(ZBook(:,:,tauVec(1)),1),Nforc);

% Fill in first state
switch flag_useShocks
    case 0
        stforc(:,1)=GBook(:,:,tauVec(1))*stateJump(:);
    case 1
        stforc(:,1)=GBook(:,:,tauVec(1))*stateJump(:) + ...
            RBook(:,:,tauVec(1))*( innovMat(1,:)' ) ;
end
yforc( :,1)=ZBook(:,:,tauVec(1))*(CBook(:,tauVec(1))+stforc(:,1) );

for ii=2:Nforc;
    switch flag_useShocks
        case 0
            stforc(:,ii)=GBook(:,:,tauVec(ii))*stforc(:,ii-1);
        case 1
            stforc(:,ii)=GBook(:,:,tauVec(ii))*stforc(:,ii-1) + RBook(:,:,tauVec(ii))*( innovMat(ii,:)' ) ;
    end
    yforc(:, ii)=ZBook(:,:,tauVec(ii))*(CBook(:,tauVec(ii))+stforc(:,ii) );
end
stforc=stforc';
yforc =yforc' ;