function dateMat=dateXLSToMatlab(datecell)
% function dateMat=dateXLSToMatlab(datecell)
% Convert a cell array of dates, datcell, in the form 
% MM / DD / YYYY into a Matrix of dates with 3 columns 
% [YYYY MM DD], dateMat 
% Alejandro Justiniano (C), March 2012 
T=length(datecell(:));
dateMat=zeros(T,3);
for ii=1:T
    tempString=datecell{ii};
    delimiters=findstr(tempString,'/');
    if isempty(delimiters) 
        error('Could not find / as delimiter'); 
    end        
    % Month
    dateMat(ii,2)=str2num( tempString(1:delimiters(1)-1) );
    % Day
    dateMat(ii,3)=str2num( tempString(delimiters(1)+1:delimiters(2)-1) );
    % Year
    dateMat(ii,1)=str2num( tempString(delimiters(2)+1:end) );
end