function pos=cellposition(csmall,cbig,flagAllowErrors)
% CELLPOSITION 
% function pos=cellposition(csmall,cbig)
% Pass a string or a cell in CSMALL
% Find location of in cell in CBIG 
% Does not allow for repeated entries 
% AJ 
% =================================================
if nargin < 2;error('Need at least 2 inputs');end
if nargin < 3 || ( flagAllowErrors~=1 & flagAllowErrors~=0 )
    flagAllowErrors=0;
end
if ( size(csmall,1)==1 )  && ( ~iscell(csmall) )
    csmall=cellstr(csmall);
end
if ~iscell(csmall);error('CSMALL must be a cell'); end
if ~iscell(cbig); error('CBIG must be a cell'); end
csmall=csmall(:);
cbig=cbig(:);
ns=length(csmall);
nb=length(cbig);
if ns > nb;error('Small cell is bigger than big cell'); end
pos=zeros(ns,1);
for ii=1:ns;
    if flagAllowErrors==0
        try
            temp=strmatch(csmall{ii},cbig,'exact');
            if length(temp) > 1
                disp('More than one row has same name');
                error('More than one row has same name');
            end
            pos(ii)=temp;
        catch
            %if isempty(pos(ii))
            lasterr
            disp(['Could not find a match for ',csmall{ii}])
            error(['Could not find a match for ',csmall{ii}])
        end
    else
        temp=strmatch(csmall{ii},cbig,'exact');
        if length(temp) > 1
            disp('More than one row has same name');
            error('More than one row has same name');
        end
        if isempty(temp); 
            disp(['Could not find a match for ',csmall{ii}])
            error(['Could not find a match for ',csmall{ii}])
        end             
        pos(ii)=temp;     
    end
end
