function [forc_mat,yforc]=zb_quickforecast(forc_pos,GG,ZZ,CC,nforc,sT,pos_gdpdef,popsTF,in) 
% =========================================================================
% =========================================================================
% ZB_QUICKFORECASTS 
% 
% Generate model-based forecasts. Code is used both for the constrainted
% and unconstrained model 
% 
% function [forc_mat,yforc]=zb_quickforecast(forc_pos,GG,ZZ,CC,nforc,sT,pos_gdpdef,popsTF,in) 
% 
%% 1. Inputs 
% -------------------------------------------------------------------------
% GG,ZZ,CC  :Solution matrices of model 
% NFORC     :Number of Forecasts    
% ST        :Last data state 
% POS_GDPDEF:Position of GDPDEF *in FORC_NAMES NOT in STANAMES* 
% POPST     :Last data of population growth (annualized) matching end of sample 
% POPF      :Series of forecast population growth, matching forecast period 
%            *NOTE* if length(POPF) is less than NFORC, last point will be
%            extended, but user will be queried about it. 
%
% IN requires fields
% .CONSNONADJ:      Non-adjusted constant 
% .ADDP:            Prices flag 
% .POP :            Population flag 
% .PARAM_GDPSS:     Constant for GDP Deflator 
%
%% 2. Outputs 
% -------------------------------------------------------------------------
% FORC_MAT:     [length(forc_pos) NFORC] Matrix of forecasts 
% YFORC   :     [NZ               NFORC] Matrix of forecasts 
% *Note:* last state is in the first row 
% 
% Alejandro Justiniano December 1st 2010 
% =========================================================================
% =========================================================================
consnoadj       =in.consnoadj ; 
forc_scale      =in.forc_scale; 
forc_addp       =in.forc_addp; 
forc_pop        =in.forc_pop ; 
param_gdpss     =in.param_gdpss; 

%% Padd population series with last entry if necessary 
if length(popsTF) < nforc
    disp('Extending Population series with end-point to cover forecast horizon'); 
    quer('c'); 
    paddf=popsTF(end)*zeros( nforc - length(popsTF) ,1  ); 
    popsTF =[popsTF;paddf]; 
end 

%% Generate Forecasts 
% sT is untransformed final state, in deviations from model mean 
% Number of actual forecasts is NFORC; last state is NOT first entry 
nst=length(sT(:)); 
stforc=zeros(nst,nforc); 
yforc =zeros(size(ZZ,1),nforc); 
stforc(:,1)=GG*sT(:); 
yforc( :,1)=ZZ*(CC+stforc(:,1) ); 
for ii=2:nforc; 
    stforc(:,ii)=GG*stforc(:,ii-1);
    yforc(:, ii)=ZZ*(CC+stforc(:,ii) ); 
end
stforc=stforc'; 
yforc =yforc' ; 

%% Obtain Annualized GDP 
if any(forc_addp ~= 0 ); 
        gdpdef_fancons=4*( stforc(:,pos_gdpdef)+param_gdpss ); 
end 

%% Transform forecasts 
nser=length(forc_pos);
forc_mat=zeros(nforc,nser);
for ii=1:nser;
    forc_mat(:,ii)      =forc_scale(ii)*(stforc(:,forc_pos(ii))+consnoadj(ii) ) ;
    if forc_addp(ii)    ==1;
        forc_mat(:,ii)  =forc_mat(:,ii)-gdpdef_fancons;
    end    
    if forc_pop(ii)==1;
        forc_mat(:,ii)  =forc_mat(:,ii)+popsTF;
    end        
end