function fighand=zb_plot2forecasts(forc1,forc2,titulo,labels,xaxis,sernames,outpath,figname)
if nargin ==8 & ~isempty(figname) 
    flag_savegraph=1; 
else 
    flag_savegraph=0; 
end 

fighand=figure;
nvar =length(sernames); 
nr  =ceil(nvar/2); 
nc  =2; 
for ii=1:nvar;
    handplot=subplot(nr,nc,ii);
    % Actual Values 
    hand1=plot(xaxis,forc1(:,ii),'b','LineWidth',2); 
    set(hand1,'Color',[0.55 0.55 0.55]); 
    hold on; 
    hand2=plot(xaxis,forc2(:,ii),'--','LineWidth',2);
    set(hand2,'Color',[0 0 0]);
    hold off; 
    
    % Set upper and lower limits of Y and X axis 
    yoffset=0.25;
    ymin=min(min([forc1(:,ii);forc2(:,ii)]));
    ymax=max(max([forc1(:,ii);forc2(:,ii)]));
    ylim([ymin-yoffset ymax+yoffset]);
    xlim([xaxis(1) xaxis(end)+0.25]);
    
    set(handplot,'box','off'); 
    
    title(sernames{ii},'FontSize',14,'FontName','Helvetica');
end

set(gcf,'PaperPosition',[0.75 0.5 7.5 10])
suptitle(titulo,12);
handleg=legend([220 10 0.4 0.4],labels,'orientation','horizontal','FontSize',12);
set(handleg,'Box','off'); 

if flag_savegraph==0;return;end 
cucd=cd;
cd(outpath);
print(gcf,'-dpdf',figname);
cd(cucd);

end 

