function [plotHandle,legendHandle,figHandle]=plot3sampSub(xaxis,mat,titulo,flagSubplot,stIn)
%% Do this if a new figure only
if flagSubplot==0
    if ~isempty(stIn.axesFontSize);
        set(0,'DefaultAxesFontSize',stIn.axesFontSize);
    end
    figHandle=figure;
else 
    figHandle=[]; 
end 
%% Plot Mat Agaist Xaxis
Nlines=size(mat,2);
if Nlines > 6
    error('Code defined for at most 3 lines');
end
%% Plot
if stIn.flagBar==0
    for ii=1:Nlines
        plotHandle=plot(xaxis,mat(:,ii),'LineWidth',stIn.lineWidths(ii));
        set(plotHandle,'Color',stIn.colors(ii,:),'LineStyle',stIn.lineStyles{ii},...
            'Marker',stIn.markers{ii},'MarkerSize',stIn.markersSize(ii));
        if ii==1; hold on; end
    end
else
    plotHandle=bar(xaxis,mat,0.95,'grouped');
    shading(gca,'flat');
end

if stIn.hlineOn==1
    %if isfield(stIn.hlineStyle)==1 && isempty(stIn.hlineStyle)==false; 
            hlineHand=hline(stIn.hlineVal,stIn.hlineStyle);
    %else 
    %       hlineHand=hline(stIn.hlineVal,stIn.hlineStyle);
    %end
    set(hlineHand,'Color',stIn.hlineColor,'LineWidth',stIn.hlineWidth); 
    set(hlineHand,'LineStyle',stIn.hlineStyle);
end

title(titulo,'FontSize',stIn.titleFontSize);
hold off;
if stIn.flagBoxOff==1
    set(gca,'Box','off')
end
if ~isempty(stIn.ylim)%==false;
    set(gca,'Ylim',stIn.ylim);
else
    if stIn.yOffset~=0
        ymin=min(min(mat));
        ymax=max(max(mat));
        set(gca,'Ylim',[ymin-stIn.yOffset ymax+stIn.yOffset]);
    end
end
if isempty(stIn.xlim)==false;
    set(gca,'xlim',stIn.xlim);
else
    if stIn.xOffset~=0
        set(gca,'Xlim',[xaxis(1)-stIn.xOffset xaxis(end)+stIn.xOffset]);
    end
end 
if ~isempty(stIn.yLabel); 
    ylabel(stIn.yLabel);
end
if ~isempty(stIn.xLabel); 
    xlabel(stIn.xLabel);
end
if ~isempty(stIn.xtickValues)
    set(gca,'Xtick',stIn.xtickValues);
end
if isempty(stIn.xtickLabels)==false 
    set(gca,'XtickLabel',stIn.xtickLabels);
end
flagSubtitle=ch_field(stIn,'subtitle'); 
if flagSubtitle==1 && isempty(stIn.subtitle)==false; 
    subHand=subtitle(stIn.subtitle); 
    set(subHand,'FontSize',stIn.titleFontSize-1); 
end 
if stIn.flagNoLegend==0
    if strcmpi(char(stIn.legendLocation),'bottom')==1
        legendHandle=legend([220 10 0.4 0.4],stIn.legend,'orientation','horizontal','FontSize',...
            stIn.legendFontSize);
    else
        legendHandle=legend(stIn.legend,'FontSize',stIn.legendFontSize,'Location',stIn.legendLocation);
    end
    if stIn.flagLegendBoxOff==1
        set(legendHandle,'Box','Off');
    end
else 
    legendHandle=[]; 
end 
if flagSubplot==1;return;end
if  stIn.flagLandscape==1
    set(figHandle,'Orientation','Landscape')
end
set(figHandle,'PaperPosition',stIn.paperPosition);
