function plot3samp(xaxis,mat,in)
% PLOT3SAMP.m plot 3 lines in the same graph 
% XMAT [T 3] matrix will plot each column 
% All other inputs governed by strucure IN 
% IN.names: [3,1] cell with names of the 3 series (default values below)

% *Settings for Lines* 
% IN.lineStyles     :[3,1] cell with Line styles (default assigned); 
% IN.lineWidths     :[3,1] vector with Line widths (default assigned) 
% IN.markersSize    :[3,1] vector with marker widths (default assigned)
% IN.colors         :[3,3] colormap matrix (will assign to greys if
%                          undefined)
%
% IN.flagLandscape  ==1 if wish to use Landscape 
%
% *Settings for Axes* (will only use those found) 
% IN.axesFontSize   : default value for Axes 
% IN.yLabel         : String with Y Labels 
% IN.xLabel         : String with X Labels 
% IN.xtickValues    : Values to plot on X-axis 
% IN.xtickLabels    : Labels for the X-axis values to plot     
% IN.xOffset        : will expand x-axis by [min-offset,max+offset] 
% IN.yOffset        : will expand y-axis by [min-offset,max+offset]
%
% *Settings for Titles* 
% IN.title           : Title to put on graph 
% IN.titleFontSize   : Size of title font 
% 
% *Settings for Legends* (always used, will asign default) 
% IN.legendsOff      : ==1 if do not wish any legends
% IN.legends         : Legends 
% IN.legendsFontSize : Legends Font Size 
% IN.legendsLocation : usual location of legends except for "Bottom" which
%                      will put it below the graph
            

%% Check if Line setting values exist if not assign defaults
if nargin < 3 
    in.empty=true; 
end 
lineWidths=[2.5 2.2 2]; 
[~,in]=ch_field(in,'lineWidths',lineWidths); 
lineStyles={'-','--','-.'}; 
[~,in]=ch_field(in,'lineStyles',lineStyles); 
markers={'none','none','o'}; 
[~,in]=ch_field(in,'markers',markers); 
markersSize=[1 1 4]; 
[~,in]=ch_field(in,'markersSize',markersSize); 
colors=[0.5 0.5 0.5;0 0 0;0.7 0.7 0.7]; 
[~,in]=ch_field(in,'colors',colors); 

%% Check if Axis setting values exist,use only those defined 
[~,in]=ch_field(in,'flagLandscape',0); 
[~,in]=ch_field(in,'flagBoxOff'   ,0); 
[~,in]=ch_field(in,'flagBar'      ,0); 
[~,in]=ch_field(in,'axesFontSize',[]); 
[~,in]=ch_field(in,'legendLocation',[]); 

[~,in]=ch_field(in,'titleFontSize',12); 
[~,in]=ch_field(in,'titleFontSize',12); 

[~,in]=ch_field(in,'legendFontSize',10); 
[~,in]=ch_field(in,'title',''); 


flagAxesFontSize=ch_field(in,'axesFontSize'); 
flagyLabel      =ch_field(in,'yLabel'); 
flagxLabel      =ch_field(in,'XLabel');
flagxtickValues =ch_field(in,'xtickValues',[]); 
flagxtickLabels =ch_field(in,'xtickLabels',0); 
flagxOffset     =ch_field(in,'xOffset'); 
flagyOffset     =ch_field(in,'yOffset'); 

%% Check settings for Legends 
[~,in]                  =ch_field(in,'flagNoLegend',0); 
[~,in]                  =ch_field(in,'legends',{'Series 1','Series 2','Series 3'}); 
[~,in]                  =ch_field(in,'legendsFontSize',10); 
flagLegendsLocation     =ch_field(in,'legendsLocation'); 

if isempty(in.axesFontSize)==false;
    set(0,'DefaultAxesFontSize',in.axesFontSize);
end 

Nlines=size(mat,2); 
if Nlines > 3 
    error('Code defined for at most 3 lines'); 
end 

if in.flagBar==0    
    for ii=1:Nlines
        hand=plot(xaxis,mat(:,ii),'LineWidth',in.lineWidths(ii));
        set(hand,'Color',in.colors(ii,:),'LineStyle',in.lineStyles{ii},...
            'Marker',in.markers{ii},'MarkerSize',in.markersSize(ii));
        if ii==1; hold on; end
         end
else 
    handbar=bar(xaxis,mat,0.95,'grouped');
%     set(handbar(1),'FaceColor','b'); 
%     set(handbar(2),'FaceColor','r'); 
%     set(handbar(3),'FaceColor','g'); 
    shading(gca,'flat');
end 
  
title(in.title,'FontSize',in.titleFontSize);

hold off; 
if in.flagBoxOff==1 
    set(gca,'Box','off') 
end 
if flagyOffset==1     
    ymin=min(min(mat));
    ymax=max(max(mat));
    set(gca,'Ylim',[ymin-in.yOffset ymax+in.yOffset]); 
end 
if flagxOffset==1     
    set(gca,'Xlim',[xaxis(1)-in.xOffset xaxis(end)+in.xOffset]); 
end 
if flagyLabel==1
    ylabel(in.yLabel);
end
if flagxLabel==1
    xlabel(in.xLabel);
end
if flagxtickValues==true && ~isempty(in.xtickValues) 
    set(gca,'Xtick',in.xtickValues);
end
if flagxtickLabels==1 && ~isempty(in.xtickLabels)
    set(gca,'XtickLabel',in.xtickLabels);
end
if in.flagNoLegend==0
    if strcmpi(char(in.legendLocation),'bottom')==1
        handleg=legend([220 10 0.4 0.4],in.legend(1:Nlines),'orientation','horizontal','FontSize',...
            in.legendFontSize);
    else
        handleg=legend(in.legend,'FontSize',in.legendFontSize);
    end
    set(handleg,'Box','Off');
end
if  in.flagLandscape==1 
    set(gcf,'PaperOrientation','Landscape') 
    set(gcf,'PaperPosition',[0.2 0.1 10.5 8.3]);
else 
    set(gcf,'PaperPosition',[0.75 0.5 7.5 10]); 
end 

end