function [beta,resid,sigma]=ols(yd,xd)
%function [beta',resid,sigma]=ols(yd,xd);
% OLS when yd is univariate
%   yd must be Tx1 and xd Txk
%   beta is a row vector
%   sigma is the standard deviation
k=size(xd,2);
q=(xd'*xd);
q=q\eye(k);
beta=q*xd'*yd;
resid=yd-xd*beta;
sigma=std(resid);
beta=beta';

