 function [GBook,RBook,CBook,euGlobal,SDXBook,ZBook,structOne,ssBook,flag,ssNames,stateNames,shockNames]...
     =modCEFJBigARMAHPSigSA(parest,~,addsol,parposest,parposcal,parvalcal) 
% ========================================================================
% New Keynesian Model with flex wages
% Allows for Habit and Indexation 
% One Split in all coefficients of the rule
% Uses kfilterNSplits so requires structures in Outputs 
%
% A. Justiniano Dec 23 2011
% =========================================================================
% 1. Parameter size 
NSplits=2; 
NParBase=3*(addsol.NLeadsFFRObs+1)+71; 
structOne=[]; 
% fp=19 
% fy=20 
% rhoR=21 
% rhoB=27
% stdB=40
% sdFacOne=44
% sdFacTwo=45; 
% stdSpread=46; 
% caseRule = 63
startSigParam=48; 
%% Find Position of B Vector 
posStdUU=(startSigParam+1:startSigParam+addsol.NLeadsFFRObs); 
% Loadings First Factor
posAVec=(posStdUU(end)+1:posStdUU(end)+1+addsol.NLeadsFFRObs); 
% Loadings Second Factor
posBVec =(posAVec(end)+1:posAVec(end)+1+addsol.NLeadsFFRObs);

posChangeSplitOne=[19 20 21 27 40 42 44 45 46 posStdUU posAVec posBVec]; 
NChangeSplitOne=length(posChangeSplitOne); 
numpar=NParBase+NChangeSplitOne; 
% Estimated parameter 
if nargin < 4 || isempty( parposcal) 
    param=parest  ; 
    if length(param)~=numpar 
        error('Length NUMPAR does not match number of specified parameters') 
    end        
else
    param=zeros(numpar,1); 
    param(parposest)=parest; 
    param(parposcal)=parvalcal; 
end; 

%% Parameters Sample 1 | 2 
parMat=repmat(param(1:NParBase),[1 NSplits]);
% Original Parameters 
equalVal=999; 
parSubSampleOne=param(posChangeSplitOne,1); 
parSubSampleTwo=param(NParBase+1:NParBase+NChangeSplitOne); 
for ii=1:length(parSubSampleTwo); 
    if abs( parSubSampleTwo(ii) - equalVal ) < 0.01 ; 
        parSubSampleTwo(ii)=parSubSampleOne(ii); 
    end 
end 
parMat(posChangeSplitOne,2)=parSubSampleTwo; 
if length( param(NParBase+1:end) )~=NChangeSplitOne
    error('Parameter Last Split Wrong Dimension') 
end

%% Pre-assigned SS Solvers
flag.ssok  =1;
flag.solver=1;
euGlobal=[0;0];

%% Correct Later 
%structOne.tauVec=op.tauVec; 
funcmod=@modCEFJBigARMAHPSigObs; 

%% Solution First Sample 
if nargout < 10
    [G,R,C,eu,SDX,Z,~,ssVec,structTwo]=feval(funcmod,parMat(:,1),[],addsol);
else
    [G,R,C,eu,SDX,Z,~,ssVec,flag,ssNames,stateNames,shockNames]=feval(funcmod,parMat(:,1),[],addsol);
end 
if ~isequal(eu,[1;1])
    %disp('Indeterminacy First Sample')
    structOne=[];flag.euok =0;structOne=[];
    GBook=[]; 
    RBook=[]; 
    CBook=[]; 
    SDXBook=[]; 
    ZBook=[]; 
    ssBook=[]; 
    return
end
NS=size(G,1); 
NX=size(R,2); 
NZ=size(Z,1); 

GBook=zeros(NS,NS,2); 
RBook=zeros(NS,NX,2); 
CBook=zeros(NS,2); 
ZBook=zeros(NZ,NS,2); 
SDXBook=zeros(NX,NX,2); 
ssBook =zeros(size(ssVec(:),1),2); 

GBook(:,:,1)=G; 
RBook(:,:,1)=R; 
CBook(:,1)=C;
ZBook(:,:,1)=Z;
SDXBook(:,:,1)=SDX; 
ssBook(:,1)=ssVec; 

%% Solution Second Sample
[G,R,C,eu,SDX,Z,~,ssVec]=feval(funcmod,parMat(:,2),[],addsol);
if ~isequal(eu,[1;1])
    %disp('Indeterminacy 2nd Sample')
    return
end
GBook(:,:,2)=G; 
RBook(:,:,2)=R; 
CBook(:,2)=C;
ZBook(:,:,2)=Z;
SDXBook(:,:,2)=SDX; 
ssBook(:,2)=ssVec(:); 

% Both Solutions OK
euGlobal=[1;1]; 

% discrepancy=comparemat(parMat(:,1),parMat(:,2)); 
% if discrepancy < 1e-9 
%     disp('Comparing Matrix Solutions'); 
%     comparemat(GBook(:,:,1),GBook(:,:,2));
%     comparemat(RBook(:,:,1),RBook(:,:,2));
%     comparemat(CBook(:,1),CBook(:,2));
%     comparemat(ZBook(:,:,1),ZBook(:,:,2));
%     comparemat(SDXBook(:,:,1),SDXBook(:,:,2));
% end 
