 function [GG,RR,C,eu,SDX,ZZ,initss,ssvec,flag,ssnames,stanames,shockNames]=modCEFJBigARMAHPSig(parest,~,addsol,calval,posest,poscal)
% =========================================================================
% Coded signals differently than HP Sig
% Labor Disutility shock is an ARMA(1,1), Normalized as in SW
% HP in the policy rule 
% In addsol, need define addsol.NLeadsFFRObs which will determine the
% length of the parameter vector. In the parameter vector it is located in
% position 48.  
%
% Std of Idiosyncratic innovations. If == 1001 then takes the same value as
% previous std. First one cannot be 1001. Cannot use 999 since this is used
% in the Split Code. 
%
%% 1. Normalize Price markup and Labor disutility 
% to have a 1/10 on the respective Phillips curves. Normalize B by 1/10 as well.  
%
%% 2. Paramater *caseRule* controls what rule responds to: 
%    = 0  Annualized GDP and Inflation 
%    = 1  Contemporaneous GDP and Inflation 
%    = 2  Annualized Inflation and output deviation from trend. 

% This is modchimodDtFacpInfExpFAMECRGDP
% modified to include the signals in factors form as coded in CEFJSmall
% 
% Parametrized in terms of slopes as opposed to Calvo Parameters 
% Labor disutility shock remains UNORMALIZED!!! 
%
% Checked identical Jan 6 2012, before adding N signal indicator 
%
% Last Modified July 26 2011. Compatibility with code in
% FOMC directory, except for STDSIGNALS which are turned off here
%
% function [GG,C,impact,eu,SDX,ZZ,NY,NX,NETA,gev,ncof]=...
% modchimodDtFacpXSpreadNews(parest,calval,posest,poscal)
%
%% *I. Description for CHIMOD DT FACP X SPREAD NEWS4* 
% 
% Model code for Chicago Fed model (CHIMOD) with 
% Double Trend (DT) Factor structure for prices (FACP) 
% Separates the ARMA(1,1) wage markup/labor disutility shock into a 
% white noise wage markup and an AR(1) labor disutility shock (X) 
% with a spread observable (SPREAD) and allowing for policy news shocks
% upto 4 periods ahead (NEWS4). 
% 
%% *II. Input* 
%
% There are either 1 or 4 inputs 
% *CASE 1* If there is 1 input, then PAREST should be the whole parameter
% vector. 
% 
% *CASE 2* If there are 4 inputs, the parameter vector PARAM is created
% from the estimated and calibrated values. 
% PAREST are the estimated values in rows POSEST and CALVAL are the
% calibrated values in position POSCAL. 
%
%% *III. Output*  
%
% The model to be solved is written, inside this code, as $$ A_{0}Y_{t+1} +
% A_{1}Y_{t}=A_{2}Y_{t-1} + PSI \eta_{t} $$  where the A matrices are
% filled with the linearized equation and entries depend on the parameter
% vector PARAM. 
%
% The solution of the model is a state space system characterized by 
%
% *Transition Equation* $$ S_{t} = GG S_{t-1} + RR \eta_{t} $$ and variance covariance matrix, 
% where $$ S_{t} $$ is the vector of all
% variables (endogenous and exogenous) of the model of dimension [NY 1],
% and $$ \eta $$  is the vector of exogenous innovations of dimension [NX 1] with 
% variance covariance matrix $$ V(\eta) = SDX'SDX $$. 
% Matrix dimensions: 
% GG [NY NY], IMPACT [NY NX], SDX [NX NX].  
%
% *Measurement Equation* $$ Y_{t} = ZZ S_{t} + ZZ C  $$ , 
% where $$ Y_{t} $$ is the data vector of dimension [NZ 1], $$ ZZ $$ is a selection matrix indicating 
% which states are observed, and $$ CC $$ is a vector of constants of
% dimension [NY 1]. 
% 
% EU is a [2 1] vector equal to [1;1] if there is a unique stable RE
% solution 
% 
% NETA GEV and COF are obsolete outputs that are still called in some codes
% and will be deleted in the new streamlined version of the estimation
% routine. 
%
%% *IV Notes on Multiple Prices* 
% 
% This version accomodates as observables an Investment Deflator and an additional NSERP prices. 
% Of these NSERP prices the first one should be the GDP deflator and the
% remaining NSERP-1 series multiple observables for the Consumption
% Deflator (e.g. chain weighted model consistent, Core PCE, Core CPI). 
% 
%% *V. Notes on Parametrization* 
% 1. Taylor rule written in terms of annualized output and inflation
% growth, with an inflation drift. 
% 2. Wage markup and labor disutility shock split. 
% 3. The composite steady state (SS) growth rate of the trend and the (SS)
% growth rate of ISTS progress are controlled by separate parameterss
% *gamma100* and *gammamiu100* rather than two parameters connected with
% ALPHA. This facilitates putting priors. 
% 4. AR coefficients of idiosyncratic errors are given by 2*PAR-1, where
% PAR is the paramater plugged into solution. Hence while PAR should be in
% the [0,1] interval, the AR coefficients are allowed to go negative. 
% 
%% *IV.a Model and data means* 
% 
% The model based means in the observation equation are given by the
% parameters *gammamiu100* and *pss100* which correspond to the mean growth
% rate of the relative price of investment to consumption and the mean
% growth rate of the consumption deflator. In addition, we allow the means
% of the observed price series to differ from these model based means
% according to extra parameters, intended to capture the discrepancy
% between model and data. 
% 
% Hence the model based mean of the Investment deflator is obtained as
% *pss100-gammamiu100-CMIU*.
% Similarly, the constants for the Consumption prices  is given by
% *pss100+CP* where CP differs by price. For simplicity this is also the
% constant for the GDP deflator, rather than aggregating that for
% investment and consumption; historically for instance Core PCE and the
% GDP deflator have grown at very similar rates. 
% 
%% *V. Related models* 
% 
% *MOD CHIMOD DT FAC P3 X SPREAD NEWS4 _ OBS:* is used to declare
% additional variables not used in estimation but annalized (e.g. output
% gap, real rate). 
% 
% *MOD CHIMOD DT FAC P3 SPREAD NEWS4:* very similar code but without split
% of wage markup and labor distulity shocks 
% 
%% *Version*
% Created by Alejandro Justiniano 12/13/2010  
% 
% Last Modified 12/13/2010. Run code ZB_CHECKWAGESPC to ensure alternative
% form of the wage Phillips curve matches model without split of wage markup and labor
% disutility shock. Also IRF of I to neutral shock is reasonable. 
% =========================================================================

if nargout < 11 
    flag_repstanames=0; 
else 
    flag_repstanames=1; 
end 
if nargout < 10 
    flag_repssnames=0; 
else
    flag_repssnames=1; 
end

flag.ssok=1;
flag.solver=1; 

initss=[]; 
ssnames=[]; 
ssvec  =[]; 


% =========================================================================
%% *PART 2. Declare Parameters* 

%% In addsol, need define addsol.NLeadsFFRObs which will determine the
%% length of the parameter vector. In the parameter vector it is located in position 48.  
if abs( round(addsol.NLeadsFFRObs)-addsol.NLeadsFFRObs ) > 0.001 
    error('NLeadsFFRObs must be an integer') 
end 
ncof=        3*(addsol.NLeadsFFRObs+1)+71;% Number of coefficients 
numpar=      ncof;  % Equal to Parameters, distinction irrelevant here 
if nargin < 4 || isempty( calval ) 
    param=parest  ; 
else
    param=zeros(numpar,1); 
    param(posest)=parest; 
    param(poscal)=calval; 
end; 
%__________________________________________________________________________
% 3.1 Parameters for all but multiple prices, GDP and I deflators 

alpha=param(1);         % share of capital in the prod. function
delta=param(2);         % capital depreciation rate
iotap=param(3);         % price indexation (=0 is static indexation, =1 is dynamic)
iotaw=param(4);         % wages indexation
gammastar100=param(5);  % steady state growth rate of technology
gammamiu100=param(6);   % steady state growth rate of capital embodied technology
h=param(7);             % habit formation parameter
lambdapss=param(8);     % steady state of mark-up shock (pins down steady state of wages)
rhoARMAPsi=param(9);    %(2*param(9)-1);% wage mark-up MA 
Lss=param(10);          % steady state for leisure (the ss for leisure is pinned down by psiss. convenient to parameterize the model in terms of Lss)
pss100=param(11);       % steady state quarterly inflation (multiplied by 100)
Fbeta=param(12);        % weird parameter of SW that is a function of beta and the steady state quarterly real rate of interest (ensures that beta is less than 1)
gss=param(13);          % steady state of the public spending shock
niu=param(14);          % curvature of the utility function for leisure
kappaP=param(15); 
kappaW=param(16); 
chi=param(17);          % elasticity of the capital utilization cost function
S=param(18);            % investment adjustment cost
fp=param(19);           % reaction to annualized inflation
fy=param(20);           % reaction to annualized output growth 
rhoR=param(21);         % policy smoothing  
rhoz=param(22); 
rhog=param(23); 
rhomiu=param(24); 
rholambdap=param(25); 
rhopsi=param(26); 
rhob=param(27); 
rhopitarg=param(28); 
rhoupsilon=param(29); 
%% New Parameters with the FA
rhovarsig =param(30);   % Persistence shock to net worth
BNratio   =param(31);   % Capital to NW ratio in SS 
KNratio   =BNratio+1; 
FKN100    =param(32);   % 100*log( F(K/N) ), approximately the spread    
tau       =param(33);   % Elasticity of external premium w.r.t. KQ/N
zeta      =param(34);   % Survival Probability of entrepeneurs 
sdStructNoSig=param(35:45); %% 11 Shocks, last one is Net Worth VARSIG 
stdSpreadME=param(46); %% Measurement error spread
% sdZ=param(35); 
% sdG=param(36); 
% sdMiu=param(37); 
% sdLambda=param(38); 
% sdPSI=param(39); 
% sdB=param(40); 
% sdUps=param(41); 
% sdPitarg=param(42); 
% sdVarsig=param(43); 
% sdFactors=param(44:45); 
stdB2YME= param(47); 
startSigParam=48; 
NLeadsFFRObs=param(startSigParam); 
if abs( NLeadsFFRObs - addsol.NLeadsFFRObs ) > 0.001 
    error('Number of Leads of FFR in Addsol must match Number in Parameter Vector') 
end 
%% Position of the Signal Parameters 
% Std of Idiosyncratic Innovations 
posStdUU=(startSigParam+1:startSigParam+NLeadsFFRObs); 
% Loadings First Factor
posAVec=(posStdUU(end)+1:posStdUU(end)+1+NLeadsFFRObs); 
% Loadings Second Factor
posBVec =(posAVec(end)+1:posAVec(end)+1+NLeadsFFRObs); 
stdUU=param(posStdUU); 
if abs( stdUU(1) - 1001 ) < 1; 
    error('First stdUU cannot be calibrated'); 
end 
for kkk=2:length(stdUU); 
    if abs( stdUU(kkk) - 1001 ) < 0.1; 
        stdUU(kkk)=stdUU(kkk-1); 
    end 
end 
sdstruct=[sdStructNoSig;stdUU]; 
aVec=param(posAVec);
bVec=param(posBVec);
%% Automatic Indexing of Post Signal Parameters 
caseRule=round(param(posBVec(end)+1)); 
posCPI=param(posBVec(end)+2); 
expInfLoading=param(posBVec(end)+3); 
HPLambda=param(posBVec(end)+4); 
end_nonp=posBVec(end)+4; %% This must much the number for expInfLoading 
% _________________________________________________________________________
% 3.2  Begin Parameters for Multiple Prices 
%__________________________________________________________________________
% 3.2.1  How to aggregate gdp deflator
flag_wadd1  =param(end_nonp+1); 
nserp       =param(end_nonp+2); 
% __________________________________________________________________
% 3.2.1 Declare positions for 
% Rows for 
% a) loadings 
% b) ar ID errors 
% c) constants 
% d) volatilities 
%
% *Note:* There are NSERP+1 loadings. First 2 are for the GDP Deflator.
% 1st of W(1)*Price consumption.2nd on W(2)*Prince Investment. 
% Remaining are for other prices on the Consumption Deflators 
row_load=(end_nonp+3):(end_nonp+nserp+3); 
row_ar  =row_load(end)*ones(1,nserp)+(1:nserp); 
row_std =row_ar(end)*ones(1,nserp)+(1:nserp);
row_c   =row_std(end)*ones(1,nserp)+(1:nserp); 

%__________________________________________________________________________
% 3.2.3 vector of factor loadings 
bet_gdpdef  =param(row_load(1:2)); 
bet_c       =param(row_load(3:end)); 

bet_CPI     =bet_c(posCPI-1); 
if abs(expInfLoading-999) < 0.01; 
    expInfLoading=bet_CPI;
end



%__________________________________________________________________________
% 3.2.4 vector of idiosyncratic errors 
rhoid=2*param(row_ar)-1; 
if any(rhoid < -0.995)~=0 || any(rhoid > 0.995)~= 0 
    disp('Explosive AR ID roots'); 
    GG=[];C=[];RR=[];eu=[0;0];SDX=[];ZZ=[];
    return
end

%__________________________________________________________________________
% 3.2.5 vector of constants 
cprices =param(row_c); 
% if all( cprices ~= 0 ) 
%     error('At least one of the constants must be set equal to 0')
% end
constantCPI=cprices(posCPI); 

%__________________________________________________________________________
% 3.2.6 vector of idiosyncratic errors
sdid             =param(row_std); 

%__________________________________________________________________________
% 3.2.7 constants for I deflator 
cons_idef        =param(row_c(end)+1:end);
if length(cons_idef)> 1 
    error('Wrong Dimension of Investment Deflator') 
end 

% =========================================================================

% =========================================================================
%% *PART 1. Declare All Variables in the Model Solution $$ S_{t} $$* 

%__________________________________________________________________________
% 1.a Endogenous Variables 
y=1;            % output
k=2;            % capital
L=3;            % hours
Rk=4;           % return on capital
w=5;            % real wages
x=6;            % marginal utility of labor
p=7;            % inflation
s=8;            % marginal cost
lambda=9;       % multiplier
c=10;           % consumption
R=11;           % interst rate
u=12;           % capital utilization
%% Delete PHI replace with q
q=13;           % q: real price of installed capital in C units
i=14;           % investment
kbar=15;        % "gross" capital
spread=16; 
%__________________________________________________________________________
% 1.b Exogenous driving processes
z =17;          % Productivity shock
g =18;          % Public spending shock
miu=19;         % Relative price (non stationary), this is Growth Rate
lambdap=20;     % Markup shock AR(1) 
psi=21;         % Preference shock AR(1) 
b=22;           % Discount factor shock 
upsilon=23;     % MEI, stationary, investment shock
pitarg=24;      % Inflation Drift
psiMA=25;     % White Noise Wage Markup 
%__________________________________________________________________________
% 1.c Observable growth rates (nominal) 
ynomobs=26; 
cnomobs=27;
inomobs=28; 
wnomobs=29; 
%__________________________________________________________________________
% 1.c.a Auxiliary Variables or Observable Prices
yrobs   =30; 
gdp     =31; 
dpinv   =32; 
gdpdef  =33; 
%__________________________________________________________________________
% 1.d Lags
yrobs_1=34;   % Real Observable Output (adjusted for utilization) lag1      
yrobs_2=35;   % Real Observable Output (adjusted for utilization) lag2
yobsan =36;   % Annualize Observable Output 
p_1    =37; 
p_2    =38; 
dpma   =39;   % Four quarter inflation  
% New variables with the FA
nw       =40;    % Real Net Worth  
rfa      =41;    % Return on Capital, do not confuse with Rk, rental rate of capital
rfaEtpone=42;    % E[Return on Capital(t+1)|t ]
varsig   =43;    % Shock to net Worth 
b2y      =44;    % Borrowing to GDP
db2y     =45;    % First Difference Borrowing to GDP
dagtrend =46;  % First difference of the aggregate trend 
gdp_leadOne=47; 
gdp_lagOne=48; 
gdpHP=49; 
gdpHP_leadOne=50; 
realRateExpected=51; 
gdpHPRule=52;
% =========================================================================
%% PART 1.B States related to expected FFR and Signals 
% ffrAROnly=52; 
% ffrRuleBased=53;
gdpHP_lagOne=53; 
% Note *gdpHP_lagOne* must ALWAYS BE last before the FFR Expectations
LeadsFFRVec=(gdpHP_lagOne+1:gdpHP_lagOne+NLeadsFFRObs); 
R_lead1=LeadsFFRVec(1); 
%% Declaration of period zero signal 
startSig=LeadsFFRVec(end)+1;
signalZero=startSig; 
%% Declaration of subsequent Lags
% First Column is declaration position 
% Subsequent Columns are lags 
% For each row there are ii-1 lags required
% E.g. with  4 Signals 
%
% [  S(1,t)     0           0           0
%    S(2,t)     S(2,t-1)    0           0
%    S(3,t)     S(3,t-1)    S(3,t-2)    0 
%    S(4,t)     S(4,t-1)    S(4,t-2)    S(4,t-3) ]
% 
% 
NperLag=zeros(NLeadsFFRObs,1); 
sigPos=zeros(NLeadsFFRObs,NLeadsFFRObs); 
tempCount=startSig; 
for ii=1:NLeadsFFRObs; 
    NperLag(ii)=ii; 
    for jj=1:ii; 
        tempCount=tempCount+1; 
        sigPos(ii,jj)=tempCount; 
    end; 
end; 
posExpInf=sigPos(NLeadsFFRObs,NLeadsFFRObs)+1; 
%% Expectations of inflation 1 through 40 quarters ahead
pe_vec=(posExpInf):(posExpInf+39); 
expectedPi40=posExpInf+40; 
NY=posExpInf+40;
% End Matt Check 
% =========================================================================

% =========================================================================
%% *PART 2. Declare Innovations to the exogenous variables $$ \eta_{t} $$* 

%__________________________________________________________________________
% 2.a Structural Disturbances 
zs=1;           % Technology 
gs=2;           % Public spending
mius=3;         % Investment     
lambdaps=4;     % Mark-up
psis=5;         % Leisure preference
bs=6;           % Discount factor
upsilons=7;     % External Finance Premium 
shpitarg=8;     % Inflation Drift
varsigsh =9;   % Shock to net Worth
%__________________________________________________________________________
% 2.b Policy Signals 
%__________________________________________________________________________
% 2.b Policy Signals 
facOne     =10; 
facTwo     =11; 
%==========================================================================
%% Matt Check (Idiosyncratic Shocks) 
uOneToTen=(facTwo+1:facTwo+NLeadsFFRObs); 
NX=uOneToTen(end); 
% End Matt Check
% =========================================================================

%==========================================================================
%% *PART 4. Compute Steady State (SS)*  
gammastar=gammastar100/100;
gammamiu=gammamiu100/100;
beta=100/(Fbeta+100);
rss=exp(gammastar)/beta-1;
rss100=rss*100;
gss=1/(1-gss);

%% Additional variables from the FA
% SS return on Capital in FA model 
rfaSS=exp(FKN100/100)*(1+rss)-1;
nomss=rss+pss100/100; 
% SS spread 
spreadSS=rfaSS-rss;
% Rental rate of capital 
Rkss=exp(gammamiu)*(1+rfaSS)-(1-delta); 

sss=1/(1+lambdapss);
wss=(sss*((1-alpha)^(1-alpha))/((alpha^(-alpha))*Rkss^alpha))^(1/(1-alpha));
kLss=(wss/Rkss)*alpha/(1-alpha);
FLss=(kLss^alpha-Rkss*kLss-wss);
yLss=kLss^alpha-FLss;

% Scale of the economy is fixed at 1, i.e. independent of LSS which now
% only enters observation equation for hours 
Lsscale=1;
kss=kLss*Lsscale;
iss=(1-(1-delta)*exp(-gammastar-gammamiu))*kss*exp(gammastar+gammamiu);
F=FLss*Lsscale;
yss=yLss*Lsscale;
css=yss/gss-iss;

% SS net worth 
nss=kss/KNratio; 
% SS entrepeneur transfer
xss=nss*(1-exp(-gammastar)*zeta*(1+rfaSS))/(1-zeta); 

ssvec  =[css/yss;iss/yss;kss/yss;rss100;100*Rkss;100*rfaSS;100*spreadSS;kss/nss]; 
if  flag_repssnames==1;
    ssnames={'c/y'  ;'i/y'  ;'k/y';  'rss100';'Rkss100';'RkFAss100';'100*Spread';'k/n'};
    %printcell([ssnames num2cprec(ssvec)]); 
end
    
%%==========================================================================

%==========================================================================
%% *PART 5. Declare System Matrices* 
% Model to be solved is written as 
% $$ A_{0}Y_{t+1} + A_{1}Y_{t}=A_{2}Y_{t-1} + PSI \eta_{t} $$  
A0  = zeros(NY,NY) ;
A1  = zeros(NY,NY) ;
A2  = zeros(NY,NY) ;
PSI = zeros(NY,NX) ;
%==========================================================================
expg=exp(gammastar);

%% *PART 6. Begin Filling Equation Rows* 

%% Eq 1, Output (y) from production function 
A1(y,y)=1;
A1(y,k)=-((yss+F)/yss)*alpha;
A1(y,L)=-((yss+F)/yss)*(1-alpha);

%% Eq. 2, Effective Capital (K) 
A1(k,k)=1;
A1(k,u)=-1;
A1(k,z)=1;
A2(k,kbar)=1;
A1(k,miu)=alpha/(1-alpha)+1;

%% Eq. 3 Hours (L), from cost minimization 
A1(L,Rk)=1;
A1(L,w)=-1;
A1(L,k)=1;
A1(L,L)=-1;

%% Eq. 4 Return to Capital (Rk) from utilization FOC
A1(Rk,Rk)=1;
A1(Rk,u)=-chi;

%% Eq. 5, Real Wages (w) PC (with split of shocks)
%slopewages=(1-beta*xiw)*(1-xiw)/((1+beta)*xiw*(1+niu*(1+1/lambdaw)));
A1(w,w)=1;
A0(w,w)= -beta/(1+beta);
A0(w,p)= -beta/(1+beta);
A1(w,x)=kappaW;
A1(w,z)=(1+iotaw*beta-rhoz*beta)/(1+beta);
A1(w,miu) =(alpha/(1-alpha))*((1+iotaw*beta-rhomiu*beta)) *(1/(1+beta)); 

A1(w,p)=(1+iotaw*beta)/(1+beta);
A2(w,p)=iotaw/(1+beta);
A2(w,w)=1/(1+beta);

A2(w,z)=iotaw/(1+beta);
A2(w,miu)=(alpha*iotaw)/( (1+beta)*(1-alpha) ); 

A1(w,psi)= -1/10; % Scaled by 10

%% Eq. 6, Wage Gap (x), (MRS-Real Wage)
A1(x,x)=1;
A1(x,w)=-1;
A1(x,lambda)=-1;
%% Normalized AJ 1/23/2012 by 0.5
%%A1(x,b)=1/((1-rhob)*(expg-h*beta*rhob)*(expg-h)/(expg*h+expg^2+beta*h^2));
normalizationB=0.1;
A1(x,b)=(normalizationB)/((1-rhob)*(expg-h*beta*rhob)*(expg-h)/(expg*h+expg^2+beta*h^2)); 
A1(x,L)=niu;
%%A1(x,psi)=1; Normalized AJ 1/23/12
%A1(x,psi)=1/(10*kappaW);  %%Normalized AJ 1/23/12

%% Eq 7, Prices (p) PC 
A1(p,p)=1;
A0(p,p)=-beta/(1+iotap*beta);
A2(p,p)=iotap/(1+iotap*beta);
%% $$ kappa_{P}^{Small}= \frac{1}{ [ \frac{1}{lambda_{P}} +1
%% ][\frac{1}{alpha}-1] } kappa_{P}^{Big $$}
A1(p,s)=-kappaP; %((1-beta*xip)*(1-xip)/((1+iotap*beta)*xip));
A1(p,lambdap)=-1/10; %%Normalized AJ 1/23/12      
%A1(p,lambdap)= -1/10; %%Normalized AJ 1/23/12         

%% Eq 8, Marginal Cost (s)
A1(s,s)=1;
A1(s,Rk)=-alpha;
A1(s,w)=-(1-alpha);

%% Eq 9, Lagrange Multiplier IBC (Lambda) 
A1(lambda,lambda)=1;
A1(lambda,R)=-1;
A0(lambda,lambda)=-1;
A0(lambda,p)=1;
A1(lambda,z)=rhoz;
A1(lambda,miu)=(rhomiu)*alpha/(1-alpha);

%% Eq 10, Consumption (c)
A1(c,lambda)=(expg-h*beta)*(expg-h);
A1(c,b)=-normalizationB*(expg-h*beta*rhob)*(expg-h)/((1-rhob)*(expg-h*beta*rhob)*(expg-h)/(expg*h+expg^2+beta*h^2)); 
%A1(c,b)=-(expg-h*beta*rhob)*(expg-h)/((1-rhob)*(expg-h*beta*rhob)*(expg-h)/(expg*h+expg^2+beta*h^2)); 

A1(c,z)=-(beta*h*expg*rhoz-h*expg);
A1(c,miu)=(-(beta*h*expg*rhomiu-h*expg))*alpha/(1-alpha);
A1(c,c)=(expg^2+beta*h^2);
A0(c,c)=-beta*h*expg;
A2(c,c)=expg*h;

%% Eq 11, Taylor Rule for Nominal Interest Rate (R)
A1(R,R)=1;
if caseRule > 4 
    error('CaseRule cannot be greater than 4'); 
end 
switch caseRule
    case 0
        A1(R,dpma)  = -(1-rhoR)*fp; % Annualized Inflation
        A1(R,yobsan)= -(1-rhoR)*fy; % Annualized Observable Output
    case 1
        A1(R,p)  = -(1-rhoR)*fp; % Annualized Inflation
        A1(R,yrobs)= -(1-rhoR)*fy; % Annualized Observable Output
    case 2
        A1(R,dpma)  = -(1-rhoR)*fp; % Annualized Inflation
        A1(R,gdpHP)= -(1-rhoR)*fy; % GDP Deviation from Trend
    case 3 
        A1(R,dpma)  = -(1-rhoR)*fp; % Annualized Inflation
        A1(R,gdpHP)= -(1-rhoR)*fy/3; % GDP Deviation from Trend        
        A1(R,gdpHP_leadOne)= -(1-rhoR)*fy/3; % GDP Deviation from Trend
        A1(R,gdpHP_lagOne)=-(1-rhoR)*fy/3;
        %A1(R,gdpHP_leadOne)= -(1-rhoR)*fy/4; % GDP Deviation from Trend
    case 4 
        A1(R,dpma)  = -(1-rhoR)*fp; % Annualized Inflation
        A1(R,gdpHP)= -(1-rhoR)*fy/4; % GDP Deviation from Trend        
        A1(R,gdpHP_leadOne)= -(1-rhoR)*fy/4; % GDP Deviation from Trend
        A0(R,gdpHP_leadOne)= -(1-rhoR)*fy/4; % GDP Deviation from Trend
        A1(R,gdpHP_lagOne)=  -(1-rhoR)*fy/4;        
end
A1(R,pitarg)  =(1-rhoR)*fp; % Inflation Drift
A1(R,signalZero)= -1; 

%% Matt Check 
A2(R,R)=rhoR;
A2(R,sigPos(1,1))=1; 

%% Declaration of subsequent Lags
% First Column is declaration position 
% Subsequent Columns are lags 
% For each row there are ii-1 lags required
% E.g. with  4 Signals 
%
% [  S(1,t)     0           0           0
%    S(2,t)     S(2,t-1)    0           0
%    S(3,t)     S(3,t-1)    S(3,t-2)    0 
%    S(4,t)     S(4,t-1)    S(4,t-2)    S(4,t-3) ]
% 
% 
%NperLag
for iRow=1:NLeadsFFRObs;     
    %% Contemporaneous definition 
    % 
    % For j > 1 
    % $$ \xi_{t,j} = a_{j+1} f^{1}_{t} + b_{j+1} f^{2}_{t} + u_{j,t} $$
    % where $$ [ a_{j+1} , b_{j+1} ] $$ correspond to the rows of the a and b 
    % vectors   
    %
    % Recall Position indicators for U defined above     
    A1(sigPos(iRow,1),sigPos(iRow,1))=1;
    PSI(sigPos(iRow,1),facOne)=aVec(iRow+1);
    PSI(sigPos(iRow,1),facTwo)=bVec(iRow+1);
    PSI(sigPos(iRow,1),uOneToTen(iRow))=1;        
    if iRow==1 
        continue 
    end    
    
    %disp('FIlling....'); 
    %dispaj( sigPos(iRow,1) ); 
    
    %% Effect on Rule
    A2(R,sigPos(iRow,NperLag(iRow)))=1;   % Longest Lag effect on rule
    
    %% Definition of Lags 
    % Recall model is written as $$ A_{0} y{t+1} + A_{1} y{t} = A_{2} y_{t-1} +
    % B \eps{t} $$
    for jCol=2:iRow;
        %dispaj(sigPos(iRow,jCol),',',sigPos(iRow,jCol)); 
        A1(sigPos(iRow,jCol),sigPos(iRow,jCol))=1;
        A2(sigPos(iRow,jCol),sigPos(iRow,jCol-1))=1;
    end
end 

%% Contemporaneous Shock 
A1(signalZero,signalZero)=1; 
PSI(signalZero,facOne)=aVec(1);     
PSI(signalZero,facTwo)=bVec(1);     

%% Expected real rate $$ r^{e}_{t} = R(t) - E[ \pi{t+1} | t ] $$
A1(realRateExpected,realRateExpected)= -1; 
A1(realRateExpected,R)=1; 
A0(realRateExpected,p)= -1; 


%% Eq. 12, Utilization (U) from market clearing condition 
A1(u,c)=css/yss;
A1(u,i)=iss/yss;
A1(u,y)=-1/gss;
A1(u,g)=1/gss;
A1(u,u)=kss*Rkss/yss;

%% Eq. 13, Price of Installed capital in C units(Q) modified by FA
% Replace this equation with the FOC for the return on capital 
A1(q,rfaEtpone)= -1; 
A0(q,Rk)=Rkss/(Rkss + (1-delta) ); 
A0(q,q )=(1-delta)/(Rkss + (1-delta) ); 
A1(q,miu)= -rhomiu; 

A1(q,q)= -1; 

% Old equation 
% A1(phi,phi)=1;
% A0(phi,phi)=-beta*exp(-gammastar-gammamiu)*(1-delta);
% A1(phi,z)=rhoz;
% A1(phi,miu)=(rhomiu)*(alpha/(1-alpha)+1);
% A0(phi,lambda)=-(1-beta*exp(-gammastar-gammamiu)*(1-delta));
% A0(phi,Rk)=-(1-beta*exp(-gammastar-gammamiu)*(1-delta));


%% Eq. 14 Real return on capital expected next period  NEW 

A1(rfa,rfa)=  -1; 
A1(rfa,Rk)=Rkss/(Rkss + (1-delta) );  
A1(rfa,q)=(1-delta)/(Rkss + (1-delta) ); 
A1(rfa,miu)= -1; 
A2(rfa,q)=1;  

%% Eq. 15, Definition of the external finance premium NEW
% Note that this combined with the two previous equations defines 
A1(rfaEtpone,rfaEtpone)= -1; 
A0(rfaEtpone,p  )= -1; 

A1(rfaEtpone,R)=1;  
A1(rfaEtpone,kbar)=tau; 
A1(rfaEtpone,q)=tau; 
A1(rfaEtpone,nw)= -tau; 
A1(rfaEtpone,upsilon)=1; 

A1(spread,spread)= -1; 
A1(spread,rfaEtpone)=1; 
A1(spread,R)= -1;  
A0(spread,p  )=1; 

%% Eq. 16 Net Worth NEW
A1(nw,nw    )=exp(gammamiu)/( zeta*(1+rfaSS) ); 
A1(nw,rfa   )= -KNratio; 
A1(nw,varsig)= -1/A1(nw,nw); 

A2(nw,nw)=1; 
A2(nw,rfaEtpone)=(1-KNratio); 
A2(nw,z)= -1; 
A2(nw,miu)= -1; 

%% Debt to GDP Ratio NEW
A1(b2y,b2y)= -1; 
A1(b2y,q  )=1/(1-(1/KNratio)); 
A1(b2y,kbar)=1/(1-(1/KNratio)); 
A1(b2y,nw  )=-( 1/(KNratio-1)); 
A1(b2y,gdp)= -1; 

%% First Difference of Debt to GDP Ratio NEW
A1(db2y,db2y)= -1; 
A1(db2y,b2y)= 1;

A2(db2y,b2y)=1;

%% Eq. 17, Investment MODIFIED by FA 
% New Investment Equation 
expgmiu=exp(gammastar+gammamiu);
% Phi-Lambda=q 
A1(i,q)     = -1/(S*expgmiu^2); 

A1(i,miu)=((1-beta*rhomiu))*(alpha/(1-alpha)+1); %no normalization
A1(i,i)=(1+beta);
A1(i,z)=(1-beta*rhoz);
A0(i,i)=-beta;
A2(i,i)=1;


%% Eq 18, Capital accumulation (kbar)
% Note: Recall, effective capital above is KBAR*UTILIZATION 
A1(kbar,kbar)=1;
A1(kbar,i)=-(1-(1-delta)*exp(-gammastar-gammamiu));
%A1(kbar,upsilon)=-(1-(1-delta)*exp(-gammastar-gammamiu));
A2(kbar,kbar)=(1-delta)*exp(-gammastar-gammamiu);
A1(kbar,z)=(1-delta)*exp(-gammastar-gammamiu);
A1(kbar,miu)=((1-delta)*exp(-gammastar-gammamiu))*(alpha/(1-alpha)+1);


%% Eq 20, Exogenous Growth Rate in Neutral Technoloy 
A1(z,z)=1; A2(z,z)=rhoz; PSI(z,zs)=1;

%% Eq 21, Exogenous Process in G Spending 
A1(g,g)=1; A2(g,g)=rhog; PSI(g,gs)=1;

%% Eq 22, Exogenous Process in Investment Specific Tech or Relative Price C
% to I 
A1(miu,miu)=1; A2(miu,miu)=rhomiu; PSI(miu,mius)=1;

%% Eq 23, Exogenous Process in Price Markup 
A1(lambdap,lambdap)=1; A2(lambdap,lambdap)=rholambdap;PSI(lambdap,lambdaps)=1;

%% Eq 24, Exogenous Process in Labor Disutility ARMA (1,1) 
A1(psi,psi)=1; A2(psi,psi)=rhopsi; A1(psi,psiMA)= -1;  A2(psi,psiMA)= -rhoARMAPsi; 
A1(psiMA,psiMA)=1; PSI(psiMA,psis)=1;

%% Eq 25, Exogenous Process in Intertemporal Preference
A1(b,b)=1; A2(b,b)=rhob; PSI(b,bs)=1;

%% Eq 26, Exogenous Process in External Finance Premium
A1(upsilon,upsilon)=1; A2(upsilon,upsilon)=rhoupsilon; PSI(upsilon,upsilons)=1;

%% Eq 27, Exogenous Process in Inflation Drift 
A1(pitarg,pitarg)=1; A2(pitarg,pitarg)=rhopitarg; PSI(pitarg,shpitarg)=1;


%% Eq 29, Exogeneous Process VARSIG in Net Worth 
A1(varsig,varsig)=1; A2(varsig,varsig)=rhovarsig; PSI(varsig,varsigsh)=1;

%% Eq. 30, Observable GDP Nominal (add P back)
A1(ynomobs,ynomobs) =  1;
A1(ynomobs,gdp)     = -1; 
A1(ynomobs,dagtrend)= -1; 
% Add inflation, since nominal 
A1(ynomobs,p)       = -1; 

A2(ynomobs,gdp)     = -1; 

%% Eq. 31, Observable Consumption Nominal (add P back)
A1(cnomobs,cnomobs) =1;
A1(cnomobs,c)       = -1; 
A1(cnomobs,dagtrend)= -1; 
% Add inflation, since nominal 
A1(cnomobs,p)= -1; 

A2(cnomobs,c)= -1; 

%% Eq. 32 Observable Investment Nominal (add P back)
% In consumption units
A1(inomobs,inomobs)   =1;
A1(inomobs,i)         = -1; 
A1(inomobs,dagtrend)  = -1; 
% Add inflation, since nominal 
A1(inomobs,p)= -1; 

A2(inomobs,i)= -1; 

%% Eq. 33 Observable Hourly Wages  Nominal (add P back)
A1(wnomobs,wnomobs) =1;
A1(wnomobs,w)       = -1; 
A1(wnomobs,dagtrend)= -1; 
% Add inflation, since nominal 
A1(wnomobs,p)= -1; 

A2(wnomobs,w)= -1; 

%% Eq. 34 Observable Real GDP Growth (in C Units)
% Corrected observation equation for utilization 
% $$ yrobs_{t} = gdp_{t}-gdp_{t-1} + agtrend_{t} $$ 
% where AGTREND is the aggregate trend 
A1(yrobs,yrobs)=1; 
A1(yrobs,gdp)= -1;
A1(yrobs,dagtrend)= -1; 
A2(yrobs,gdp)= -1; 

%% Eq. 35 GDP (detrended), Real Detrended Output corrected for Utilization 
A1(gdp,gdp)= -1; 
A1(gdp,y)=1; 
A1(gdp,u)= -kss*Rkss/yss; 

%% Eq. 36 Growth Rate in Investment Deflator 
% $$ \Delta P^{I}_{t} = \Delta P^{C}_{t} - \mu_{t} $$
A1(dpinv,dpinv)= -1; 
A1(dpinv,p)    =  1; 
A1(dpinv,miu)  = -1; 

%% Eq. 37 GDP Deflator 
% $$ P^{GDP}_{t} = \beta_{1} P^{C}_{t} + \beta_{2} P^{I}_{t} $$ 
% 
% Recall there are 2 ways to define the weights 
%
% *First:* $$ {\frac{C}{C+I} , \frac{I}{C+I} } $$ 
% 
% *Second:* $$ {\frac{C}{Y}  , \frac{I}{Y}   } $$
%
% Note that in second case weights will not add up to one, which is not
% desirable, but opens up the door for adding a 3 deflator, i.e. price of G
% and NX. 
bet_gdpdef=bet_gdpdef(:); 
weights=zeros(1,2); 
if flag_wadd1==1
    weights(1)=css/(css+iss);
    weights(2)=iss/(css+iss);
else
    weights(1)=css/yss;
    weights(2)=iss/yss;
end
A1(gdpdef,gdpdef) = -1; 
A1(gdpdef,p)      = weights(1)*bet_gdpdef(1); 
A1(gdpdef,dpinv)  = weights(2)*bet_gdpdef(2); 

%% Eq. 38 Lag 1 Observable Real GDP Growth (in C Units)
A1(yrobs_1,yrobs_1)=1; A2(yrobs_1,yrobs)=1;

%% Eq. 39 Lag 2 Observable Real GDP Growth (in C Units)
A1(yrobs_2,yrobs_2)=1; A2(yrobs_2,yrobs_1)=1;

%% Eq. 40 Annualized Observable Real GDP Growth (in C Units)
% $$ \Delta y^{A}_{t}= \sum_{j=0}^{3}yrobs_{t-j} $$
A1(yobsan,yobsan)= -1;

A1(yobsan,yrobs)  =1; 
A1(yobsan,yrobs_1)=1; 
A1(yobsan,yrobs_2)=1;
A2(yobsan,yrobs_2)= -1;

% A1(p_leadOne,p_leadOne)=1; 
% A0(p_leadOne,p        )= -1; 

%% Eq. 41 Lag 1 Inflation (C)
A1(p_1,p_1)=1; A2(p_1,p)=1;

%% Eq. 42 Lag 2 Inflation (C)
A1(p_2,p_2)=1; A2(p_2,p_1)=1;

%% Eq. 43 Annualized Inflation (C) 
% $$ \Delta P^{A,C}_{t}= \frac{ \sum_{j=0}^{3} \Delta P^{C}_{t-j} }{4} $$
A1(dpma,dpma)= -1;
A1(dpma,p)   = 1/4;
A1(dpma,p_1) = 1/4;
if caseRule < 4 
    A1(dpma,p_2) = 1/4;
    A2(dpma,p_2) = -1/4;
elseif caseRule==4  
    A1(dpma,pe_vec(1))=1/4; 
    A1(dpma,pe_vec(2))=1/4; 
else 
    error('CaseRule cannot be greater than 4'); 
end 
    
%% Eq. 44, Growth Rate in Aggregate Trend 
% $$ \Gamma_{t} = Z_{t} + \frac{\alpha}{1-\alpha} \mu_{t} $$ 
A1(dagtrend,dagtrend)= -1; 
A1(dagtrend,z)=1; 
A1(dagtrend,miu)=alpha/(1-alpha); 


%% Expected FFR 1 through 5 
% Declaration of FFR 
% LeadsFFRVec={ E[R_{t+1} | t ],....,E[R_{t+10} | t ] }; 
A1(R_lead1,R_lead1)=1; A0(R_lead1,R)= -1;
for kkk=2:length(LeadsFFRVec);
    A1(LeadsFFRVec(kkk),LeadsFFRVec(kkk))=1;
    A0(LeadsFFRVec(kkk),LeadsFFRVec(kkk-1))= -1;
end

%% 
pe_vec=pe_vec(:); 
A1(pe_vec,pe_vec)=eye(length(pe_vec)); 
A0(pe_vec,[p;pe_vec(1:end-1)])= -eye(length(pe_vec)); 

A1(expectedPi40,expectedPi40)= -1; 
A1(expectedPi40,pe_vec      )= (expInfLoading/length(pe_vec))*ones(1,length(pe_vec));  

%% GDP Lead One 
A1(gdp_leadOne,gdp_leadOne)=1; 
A0(gdp_leadOne,gdp)= -1; 

%% GDP Lag One
A1(gdp_lagOne,gdp_lagOne)=1; 
A2(gdp_lagOne,gdp)=1; 

%% HP Lead One 
A1(gdpHP_leadOne,gdpHP_leadOne)=1; 
A0(gdpHP_leadOne,gdpHP)= -1; 

%% HP Lag One 
A1(gdpHP_lagOne,gdpHP_lagOne)=1; 
A2(gdpHP_lagOne,gdpHP)=1; 

%% Definition HP Output 
A1(gdpHP,gdpHP)=1+6*HPLambda; 
A1(gdpHP,gdpHP_leadOne)= -4*HPLambda; 
A0(gdpHP,gdpHP_leadOne)=HPLambda; 
A1(gdpHP,gdpHP_lagOne)= -4*HPLambda; 
A2(gdpHP,gdpHP_lagOne)= -HPLambda; 

A1(gdpHP,gdp)= -6*HPLambda; 
A1(gdpHP,gdp_leadOne)=4*HPLambda;
A0(gdpHP,gdp_leadOne)= -HPLambda; 
A1(gdpHP,gdp_lagOne )=4*HPLambda; 
A2(gdpHP,gdp_lagOne)=HPLambda; 

A1(gdpHPRule,gdpHPRule)= -1;
if caseRule < 3
    A1(gdpHPRule,gdpHP)=1;
elseif caseRule==3
    A1(gdpHPRule,gdpHP)=1/3;
    A1(gdpHPRule,gdpHP_leadOne)=1/3;
    A1(gdpHPRule,gdpHP_lagOne)=1/3;
elseif caseRule==4
    A1(gdpHPRule,gdpHP)=1/4;
    A1(gdpHPRule,gdpHP_leadOne)=1/4;
    A0(gdpHPRule,gdpHP_leadOne)=1/4;
    A1(gdpHPRule,gdpHP_lagOne)=1/4;
else
    error('caseRule cannot be greater than 4');
end


%% *PART 7: Solve Model using AMASOLVE*
[GG,~,impact,~,~,~,~,eu]=amasolve(A0,A1,A2,zeros(NY,1),PSI) ;
% EU =[1;1] if unique and stable RE solution 
if ~isequal(eu,[1;1]); 
    flag.euok=0; 
    ZZ=[]; C=[]; SDX=[]; RR=[]; 
    return 
end 

flag.euok=1; 
%% *PART 8: Addition of Measurement Equations for Prices*

%% 8.1 Extend model solution by 2*NSERP rows 
% Number of rows to add to the solution 
nadd=nserp*2; 
% Part 1: Position of prices 
posp =(NY+1):(NY+nserp); 
% Part 2: Position of ID errors 
posid=(posp(end)+1):(NY+2*nserp); 
GG=blkdiag(GG,zeros(nadd)); 
% Matrix of impact coefficients 
RR=zeros(NY+nadd,NX+nserp); 
RR(1:NY,1:NX)=impact; 

%% 8.2 Idiosyncratic errors 
% Which evolve as $$ \nu^{i}_{t} = \rho  \nu^{i}_{t-1} + \varsigma^{i}_{t} $$
% as independent AR(1) processes 
GG(posid,posid   )=diag(rhoid); 
RR(posid,NX+1:end)=eye(nserp); 

%% 8.3 General Structure of Observable Price Equation 
% 
% For price $$ P^{i,C}_{t} = \beta^{i} P^{C}_{t} + \nu^{i}_{t} $$ written in terms
% of lagged variables as 
% $$ P^{i,C}_{t} = \beta^{i} G_{P^{C}} S_{t-1} + \beta^{i} R_{P^{C}}
% \eta_{t} + \rho \nu^{i}_{t-1} + \varsigma^{i}_{t} $$ ,
% where $$ \beta^{i} $$ is the series specific factor loading, and, $$ G_{P^{C}}  R_{P^{C}} $$ correspond to the rows of the solution
% matrix for the model consumption price 

%% 8.3.a First row is GDP 
GG(posp(1),1:NY)=GG(gdpdef,1:NY);
RR(posp(1),1:NX)=RR(gdpdef,1:NX); 

%% 8.3.b Remaining rows are multiple indicators for consumption prices 
% Recall Structural part of observation equation $$ \beta^{i} G_{P^{C}} S_{t-1} +
% \beta^{i} R_{P^{C}} \eta_{t}  $$ 
GG(posp(2:end),:)       =repmat( GG(p,:)    ,[nserp-1 1] ); 
RR(posp(2:end),1:NX)    =repmat( RR(p,1:NX) ,[nserp-1 1] );
% Multiply by Factor Loadings  
bet_c=bet_c(:); 
GG(posp(2:end),1:NY)=(repmat(bet_c,[1 NY])).*GG(posp(2:end),1:NY); 
RR(posp(2:end),1:NX)=(repmat(bet_c,[1 NX])).*RR(posp(2:end),1:NX);
%% 8.3.c Add idiosyncratic errors 
GG(posp,posid)   =diag(rhoid); 
RR(posp,NX+1:end)=eye(nserp); 

% Update model dimensions after adding prices 
NY=size(GG,1); 
NX=size(RR,2); 
%% *Part 9: Addition of Measurement Equations for Spread*
% 
%% 9.1 Extend model solution by 1 row 
GG    =blkdiag(GG,zeros(2));
RR=[RR zeros(NY,2);zeros(2,NX+2)];

%% 9.2 Fill in last row for the spread 
% 
% $$ sp_{t} = \kappa \upsilon_{t} + \varsigma^{sp}_{t} $$ 
posspread=NY+1;
GG(posspread,:)       =GG(spread,:); 
RR(posspread,:)   =RR(spread,:); 
RR(posspread,NX+1)=1; 


posB2Yobs=NY+2; 
GG(posB2Yobs,:)       =GG(b2y,:); 
RR(posB2Yobs,:)   =RR(b2y,:); 
RR(posB2Yobs,NX+2)=1; 

NY=size(GG,1); 
NX=size(RR,2); 

nadd2=4; 
GG       =blkdiag(GG,zeros(nadd2)); 
RR       =[RR;zeros(nadd2,size(RR,2))]; 
posGDPreal  =NY+1; 
posCreal    =NY+2; 
posIreal    =NY+3; 
posWreal    =NY+4; 

%% Eq. Real GDP: Nominal Deflated by GDP deflator 
GG(posGDPreal,:)     =GG(ynomobs,: )-GG( posp(1),:); 
RR(posGDPreal,:)     =RR(ynomobs,: )-RR( posp(1),:); 

%% Eq. Real Consumption: Nominal Deflated by C deflator 
GG(posCreal,:) =GG(cnomobs,: )-GG( posp(3),:); 
RR(posCreal,:) =RR(cnomobs,: )-RR( posp(3),:); 

%% Eq. Real Investment: Nominal Deflated by I deflator 
GG(posIreal,:) =GG(inomobs,: )-GG(dpinv,:); 
RR(posIreal,:) =RR(inomobs,:) -RR(dpinv,:); 

%% Eq. Real Wages: Nominal Deflated by C deflator 
GG(posWreal,:) =GG(wnomobs,: )-GG(posp(3),:); 
RR(posWreal,:) =RR(wnomobs,: )-RR(posp(3),:); 

NY=size(GG,1); 
NX=size(RR,2); 


%% *PART 10: Declare Cholesky of Variance Covariance Matrix* 
% Recall $$ V = SDX'SDX $$ and the order of the shocks is 
% 1. Structural 2. Policy Signals 3. Idiosyncratic Prices 4. Measurement
% Error Spread 
SDX=diag([sdstruct(:);sdid(:);stdSpreadME;stdB2YME]);
if size(SDX,1)~=NX;error('Dimensions of errors and SDX do not match');end

%% *PART 11: Declare ZZ, Matrix of Pointers to Observables*
% Ordering 
% 1) Nominal GDP Growth. 
% 2) Nominal C   Growth.
% 3) Nominal I   Growth.
% 4) Hours. 
% 5) Nominal W   Growth. 
% 6) Feds Fund Rate. 
% 7) Investment Deflator. 
% 8) GDP Deflator. 
% 9 though NSERP-1) Indicators of C Prices. 
% Last is Spread
dimZ=10+nserp+NLeadsFFRObs; 
ZZ=zeros(dimZ,NY); 
ZZ(1,ynomobs)=1; 
ZZ(2,cnomobs)=1; 
ZZ(3,inomobs)=1; 
ZZ(4,L)=1; 
ZZ(5,wnomobs)=1; 
ZZ(6,R)=1;
ZZ(7,dpinv)=1;
ZZ(8:8+nserp-1,posp)=eye(nserp);
bottomRows=8+nserp; 
ZZ(bottomRows,posspread)=1; 
ZZ(bottomRows+1,expectedPi40)=1; 
ZZ(bottomRows+2,posB2Yobs  )=1; 
if NLeadsFFRObs > 0 
    ZZ(bottomRows+3:bottomRows+2+NLeadsFFRObs,LeadsFFRVec(1:NLeadsFFRObs))...
        =eye(NLeadsFFRObs); 
end 

%% *PART 12: Declare C, Matrix of Constants*
C=zeros(NY,1); 
C(ynomobs)=gammastar100+pss100;
C(cnomobs)=gammastar100+pss100;
C(inomobs)=gammastar100+pss100;
C(L)=Lss;
C(wnomobs)=gammastar100+pss100;
C(R)    =pss100+rss100;
C(dpinv)=(pss100-gammamiu100)+cons_idef; 
C(posp )= pss100*ones(nserp,1)+cprices(:); 
C(expectedPi40)=pss100+constantCPI;
C(posspread   )=100*spreadSS; 
if NLeadsFFRObs > 0 
    C(LeadsFFRVec(1:NLeadsFFRObs))=C(R)*ones(NLeadsFFRObs,1); 
end 
if flag_repstanames==0; 
    return 
end 
%________________________________________________________
%% 16.1 STANAMES: Cell with Names of ALL states 
sigNames=[];
FFRExpectedNames=cell(NLeadsFFRObs,1); 
sigIDShockNames=cell(NLeadsFFRObs,1); 
for ii=1:NLeadsFFRObs;
    tempNames=cell(ii,1);
    FFRExpectedNames(ii)={['FFR Lead ',num2str(ii)]}; 
    sigIDShockNames(ii) ={['ID Signal ',num2str(ii)]}; 
    for jj=1:ii;
        if jj==1
            tempNames(jj)={['Signal ',num2str(ii)]};
        else
            tempNames(jj)={['Signal ',num2str(ii),' Lag ',num2str(jj-1)]};
        end
    end;
    sigNames=[sigNames(:);tempNames(:)]; 
end;
sigNames=[{'Signal 0'};sigNames(:)]; 
%% 16.1.a Names until GDPm HP Lag One which is the last state before the
%% expected FFR 
stanames1={'Y Detrended','khat','Hours','Rental rate K','what','MgRSLC','Inflation',...
    'Marginal Cost','MgUC','chat',...
    'FFR','Utilization ','Q','ihat','kbar','Spread model','Neutral','G+NX','ISTS','Price Markup',...
    'Labor Disutility','Discount','Spread Shock','Inflation Drift','Labor Disutility MA',.....
    'GDPm nominal','Cm nominal','Im nominal','Wm nominal',...  % Position 29
    'GDPm real','GDPm level','Inv deflator','GDPm deflator','GDPm real lag1','GDP real lag2','GDP Annualized',....
    'Inflation lag1','Inflation lag2','Average Inflation',...
    'Net Worth','Return on K','Expected return on K','Net Worth Shock','Borrowing to GDP model','Chg Borrowing to GDP model',...
    'Aggregate trend','GDPm Lead One','GDPm Lag One','GDPm HP','GDPm HP Lead One',...
    'Expected Real Rate','GDPm HP Rule',...
    'GDPm HP Lag One'};
inflationNames={'ExpInf1','ExpInf2','ExpInf3','ExpInf4','ExpInf5','ExpInf6','ExpInf7','ExpInf8','ExpInf9','ExpInf10',...
    'ExpInf11','ExpInf12','ExpInf13','ExpInf14','ExpInf15','ExpInf16','ExpInf17','ExpInf18','ExpInf19','ExpInf20',...
    'ExpInf21','ExpInf22','ExpInf23','ExpInf24','ExpInf25','ExpInf26','ExpInf27','ExpInf28','ExpInf29','ExpInf30',...
    'ExpInf31','ExpInf32','ExpInf33','ExpInf34','ExpInf35','ExpInf36','ExpInf37','ExpInf38','ExpInf39','ExpInf40',...
    'AvgExpInf10y','GDP deflator'};
stanames1=[stanames1(:);FFRExpectedNames(:);sigNames(:);inflationNames(:)];     
if nserp==3 
    stanames2={'C deflator','PCE Core','GDP def Id','C def Id','PCE Core Id'}; 
elseif nserp==4 
    stanames2={'C deflator','PCE Core','CPI Core','GDP def Id','C def Id','PCE Core Id','CPI Core Id'}; 
else 
    disp('Nprices > 4 please add names to STANAMES') 
end 
stanames3={'Spread','Borrowing to GDP','GDP','Consumption','Investment','Real Wage'};  %,'Spread Me','RealY','RealC','RealI','RealW','SumR'}; 
stanames=[stanames1(:);stanames2(:);stanames3(:)]; 

%% 16.2 STSHOCKS: Cell with Names of Shocks in STANAMES 
% *Note:* Technically not true for the policy signals, for which looking
% only at the cummulative signals. Hence isolate policy innovations rather
% than policy states.
stshocks1={'z','g','miu','lambdap','psi','b','shock spread','pitarg','wmarkwn',...
    'Factor 1','Factor 2'}; 
stshocks3={'GDP def Id','C def Id','PCE Core Id'};
if nserp==4
    stshocks3=[stshocks3(:);'CPI Id'];
end
stshocks=[stshocks1(:);sigIDShockNames(:);stshocks3(:)]; 
stshocks=[stshocks;'Spread Me';'B2Y Me'];
stshocks=stshocks(:);
shockNames.short=stshocks; 
shockNames.long =[{'Neutral';'CIV+G+NX';'ISTS';'Price Markup';'Labor Disutility';'Discount';...
    'Spread';'Inflation Drift';'Net Worth';'Factor 1';'Factor 2'};...
    sigIDShockNames(:);...
    {'GDP def Id';'C def Id';'PCE Core Id'}];
if nserp==4
    shockNames.long =[shockNames.long;'CPI Id'];
end
shockNames.long=[shockNames.long;'Spread MeaErr';'B2Y MeaErr'];
shockNames.long=shockNames.long(:); 

%% 16.4 Quick check dimensions 
if length(stanames)~=size(GG,1)
    error('Mistmatch STANAMES and NY');
end
if length(stshocks)~=size(SDX,1)
    error('Mistmatch STSHOCKS and NX');
end
if length(shockNames.long )~=size(SDX,1)
    error('Mistmatch Long SHONAMES and NX');
end
if length(shockNames.short)~=size(SDX,1)
    error('Mistmatch Short SHONAMES and NX');
end
