function [G1,CC,impact,fmat,fwt,ywt,gev,eu]=amaingensysout(A0,A1,A2,psi,uprbnd,condn)
%========================================================================== 
% AMA IN GENSYS OUT.m
% Similar to AMAGENSYS.m but this code already receives AMA Input and then
% translates it into GENSYS output 

% Inputs: 
% -------
% Write the matrices using Joe Pearlman's notation 
% A0*E[y{t+1}|t]+A1*y(t)=A2*y(t-1)+ PSI*eps(t)
% which implies 
% H=[-A2 A2 A0] 
%
% Additional inputs from standard gensys used in SPAmalg.m 
% UPRBND    upper bound allowed for unit roots, similar to DIV in
%           gensys
% CONDN     Zero tolerance used as a condition number test
%           by numeric_shift and reduced_form
% If not defined will be set to their default values 
%
% Outputs
% -------
% Same as Gensys solution 
% y(t)=G1*y(t-1)+C+impact*z(t)+ywt*inv(I-fmat*inv(L))*fwt*z(t+1) 
%
% Note: In gensys GEV=[A B] and compute the roots as B./A 
% AMA returns only a subset of the roots so to make output comparable 
% will report an artificial variable GEV=[Aama Bama] 
% where Bama has in the first K rows the roots returned by AMA 
% and zeros in the next (NY-NK) rows, while A is an NY x 1 column of 1s
%
% Alejandro Justiniano
% Adapted from Gary Anderson's GENSYStoAMA matlab code. 
% Changed sorting of output by AIMCODE values to guarantee output is
% produced
% July 9th 2007 
% =========================================================================
if nargin < 6
    condn=1.e-10;
    if nargin < 5
        uprbnd =1+1.e-6;%allow unit roots
    end
end
ny=size(A0,1); 
% No longer need to conver Gensys inputs into AMA
%[theHM,theH0,theHP]=convertFromGensysIn(g0,g1,pi);
%theH=[theHM,theH0,theHP];
theH=[-A2 A1 A0]; 
% 1. Call SPAMAlg that implements AMA
% -----------------------------------
[bb,rts,ia,nexact,nnumeric,lgroots,aimcode]=SPAmalg(theH,ny,1,1,condn,uprbnd);
if aimcode > 5
    G1=[];CC=[];impact=[];ywt=[];fmat=[];fwt=[];gev=[];
    eu=[0;0]; return;
end
eu=setEu(aimcode);eu=eu(:); 
% 3. If a solution exists, convert output from AMA to Gensys 
% -----------------------------------------------------------
if isequal(eu,[1;1])
    %phi=(theH0+theHP*sparse(bb))\eye( size(theH0,1));
    phi=(A1+A0*sparse(bb))\eye(ny);
    G1=bb(1:ny,1:ny);
    impact=phi*psi; 
    %[CC,G1,impact,ywt,fmat,fwt]=convertToGensysOut(bb,phi,(-phi*A0),cc,g0,g1,psi,size(pi,2));
    gev=[ones(ny,1) [rts;ones(ny-length(rts),1)]]; 
    CC=zeros(ny,1); 
    fmat=[];fwt=[];ywt=[];  
else
    %%disp('No unique stable solution with AMA'); 
    G1=[];CC=[];impact=[];ywt=[];fmat=[];fwt=[];gev=[];   
end
% ======================================
% Solution indicator same as Gensys 
% =======================================
function euVal=setEu(aimCode)
euVal=zeros(1,2);
switch aimCode
    case 1
        euVal(1,1)=1;
        euVal(1,2)=1;
    case 2
        euVal(1,1)=-2;
        euVal(1,2)=-2;
        disp('Coincident Zeros');
    case 3
        euVal(1,1)=0;
        euVal(1,2)=0;
        disp('No solution'); 
    case 4
        euVal(1,1)=1;
        euVal(1,2)=0;
        disp('Indeterminacy'); 
    case 5
        euVal(1,1)=-5;
        euVal(1,2)=-5;
end